/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Contraction;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class ContractionRulesTest
extends AbstractDTAnalysisTest {
    @Test
    public void testContractionRules() {
        List validate = validator.validate(this.getReader("Contraction.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = ContractionRulesTest.getAnalysis(validate, "_01d9abb9-b968-49c0-b6ab-909f3e03d8d3");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getContractions()).hasSize(2);
        List<Contraction> results = Arrays.asList(new Contraction(4, List.of(Integer.valueOf(5)), 2, List.of(new Interval(Range.RangeBoundary.CLOSED, (Comparable)new BigDecimal("0.35"), Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, 0))), new Contraction(3, List.of(Integer.valueOf(6)), 1, List.of(new Interval(Range.RangeBoundary.CLOSED, (Comparable)new BigDecimal("600"), Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, 0))));
        Assertions.assertThat(results).hasSize(2);
        Assertions.assertThat((List)analysis.getContractions()).containsAll(results);
        ((ListAssert)Assertions.assertThat(validate.stream().filter(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_CONTRACTION_RULE)).collect(Collectors.toList())).as("It should contain 2 DMNMessage for the Contraction", new Object[0])).hasSize(2);
    }
}

