/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.mcdc;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.mcdc.MCDC2TCKGenerator;
import org.kie.dmn.validation.dtanalysis.mcdc.MCDCAnalyser;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleMCDCTest
extends AbstractDTAnalysisTest {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleMCDCTest.class);

    @Test
    public void test1() throws Exception {
        String resourceFileName = "example1.dmn";
        List validate = validator.validate(this.getReader("example1.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE, DMNValidator.Validation.COMPUTE_DECISION_TABLE_MCDC});
        DTAnalysis analysis = ExampleMCDCTest.getAnalysis(validate, "_452a0adf-dd49-47c3-b02d-fe0ad45902c7");
        Collection<MCDCAnalyser.Record> mcdcCases = this.computeMCDCCases(analysis.getMCDCSelectedBlocks());
        Assertions.assertThat(mcdcCases).hasSize(16);
        this.assertMCDCCases("example1.dmn", analysis.getSource(), mcdcCases);
        String mcdc2tck = MCDC2TCKGenerator.mcdc2tck((DecisionTable)analysis.getSource(), (List)analysis.getMCDCSelectedBlocks());
    }

    @Test
    public void test2() throws Exception {
        String resourceFileName = "example2.dmn";
        List validate = validator.validate(this.getReader("example2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE, DMNValidator.Validation.COMPUTE_DECISION_TABLE_MCDC});
        DTAnalysis analysis = ExampleMCDCTest.getAnalysis(validate, "_e31c78b7-63ef-4112-a0bc-b0546043ebe9");
        Collection<MCDCAnalyser.Record> mcdcCases = this.computeMCDCCases(analysis.getMCDCSelectedBlocks());
        Assertions.assertThat(mcdcCases).hasSize(14);
        this.assertMCDCCases("example2.dmn", analysis.getSource(), mcdcCases);
        String mcdc2tck = MCDC2TCKGenerator.mcdc2tck((DecisionTable)analysis.getSource(), (List)analysis.getMCDCSelectedBlocks());
    }

    private void assertMCDCCases(String resourceFileName, DecisionTable sourceDT, Collection<MCDCAnalyser.Record> mcdcCases) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)resourceFileName, ExampleMCDCTest.class);
        MCDCListener mcdcListener = new MCDCListener();
        runtime.addListener((DMNRuntimeEventListener)mcdcListener);
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        Assertions.assertThat((Object)dmnModel).isNotNull();
        for (MCDCAnalyser.Record mcdcCase : mcdcCases) {
            mcdcListener.selectedRule.clear();
            DMNContext context = runtime.newContext();
            for (int i = 0; i < mcdcCase.enums.length; ++i) {
                context.set(((InputClause)sourceDT.getInput().get(i)).getInputExpression().getText(), mcdcCase.enums[i]);
            }
            DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
            LOG.debug("{}", (Object)evaluateAll);
            Assertions.assertThat(mcdcListener.selectedRule).contains((Object[])new Integer[]{mcdcCase.ruleIdx + 1});
        }
    }

    private Collection<MCDCAnalyser.Record> computeMCDCCases(List<MCDCAnalyser.PosNegBlock> mcdcSelectedBlocks) {
        LinkedHashSet<MCDCAnalyser.Record> mcdcRecords = new LinkedHashSet<MCDCAnalyser.Record>();
        for (MCDCAnalyser.PosNegBlock b : mcdcSelectedBlocks) {
            mcdcRecords.add(b.posRecord);
            mcdcRecords.addAll(b.negRecords);
        }
        return mcdcRecords;
    }

    public static void debugOutputAndOpenXLSX(DecisionTable dt, List<MCDCAnalyser.PosNegBlock> selectedBlocks) {
        File file;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCreationHelper ch = wb.getCreationHelper();
        XSSFCellStyle styleColumn = wb.createCellStyle();
        styleColumn.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        styleColumn.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = wb.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle styleRepeated = wb.createCellStyle();
        styleRepeated.setFont((Font)font);
        XSSFSheet sheet = wb.createSheet("MC DC Analysis");
        int r = 0;
        int c = 0;
        Row row = sheet.createRow(r++);
        row.createCell(c++).setCellValue(ch.createRichTextString("Rule:"));
        for (InputClause input : dt.getInput()) {
            row.createCell(c++).setCellValue(input.getInputExpression().getText());
        }
        for (Object output : dt.getOutput()) {
            row.createCell(c++).setCellValue(dt.getOutputLabel());
        }
        row.createCell(c++).setCellValue(ch.createRichTextString("Rule:"));
        for (InputClause input : dt.getInput()) {
            row.createCell(c++).setCellValue(input.getInputExpression().getText());
        }
        for (Object output : dt.getOutput()) {
            row.createCell(c++).setCellValue(dt.getOutputLabel());
        }
        LinkedHashSet<MCDCAnalyser.Record> mcdcRecords = new LinkedHashSet<MCDCAnalyser.Record>();
        for (MCDCAnalyser.PosNegBlock b : selectedBlocks) {
            int i;
            row = sheet.createRow(r++);
            c = 0;
            boolean add = mcdcRecords.add(b.posRecord);
            Cell ruleIdxCell = row.createCell(c++);
            ruleIdxCell.setCellValue((double)(b.posRecord.ruleIdx + 1));
            if (!add) {
                ruleIdxCell.setCellStyle((CellStyle)styleRepeated);
            }
            for (i = 0; i < b.posRecord.enums.length; ++i) {
                Object en = b.posRecord.enums[i];
                Cell enCell = row.createCell(c++);
                enCell.setCellValue(en.toString());
                if (!add) {
                    enCell.setCellStyle((CellStyle)styleRepeated);
                }
                if (b.cMarker != i) continue;
                enCell.setCellStyle((CellStyle)styleColumn);
            }
            for (Object out : b.posRecord.output) {
                Cell outCell = row.createCell(c++);
                outCell.setCellValue(out.toString());
                if (add) continue;
                outCell.setCellStyle((CellStyle)styleRepeated);
            }
            for (i = 0; i < b.negRecords.size(); ++i) {
                MCDCAnalyser.Record negRecord = (MCDCAnalyser.Record)b.negRecords.get(i);
                if (i != 0) {
                    row = sheet.createRow(r++);
                    c = 1 + b.posRecord.enums.length + b.posRecord.output.size();
                }
                add = mcdcRecords.add(negRecord);
                ruleIdxCell = row.createCell(c++);
                ruleIdxCell.setCellValue((double)(negRecord.ruleIdx + 1));
                if (!add) {
                    ruleIdxCell.setCellStyle((CellStyle)styleRepeated);
                }
                for (Object en : negRecord.enums) {
                    Cell enCell = row.createCell(c++);
                    enCell.setCellValue(en.toString());
                    if (add) continue;
                    enCell.setCellStyle((CellStyle)styleRepeated);
                }
                for (Object out : negRecord.output) {
                    Cell outCell = row.createCell(c++);
                    outCell.setCellValue(out.toString());
                    if (add) continue;
                    outCell.setCellStyle((CellStyle)styleRepeated);
                }
            }
        }
        try {
            file = Files.createTempFile("mcdc " + dt.getOutputLabel(), ".xlsx", new FileAttribute[0]).toFile();
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            wb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        LOG.trace(System.getProperty("java.io.tmpdir"));
    }

    public static void debugTCKXML(DecisionTable dt, String xmlContent) throws Exception {
        File file = Files.createTempFile("mcdcTCK " + dt.getOutputLabel(), ".xml", new FileAttribute[0]).toFile();
        FileWriter fw = new FileWriter(file);
        fw.append(xmlContent);
        fw.close();
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        LOG.debug(System.getProperty("java.io.tmpdir"));
    }

    public static class MCDCListener
    implements DMNRuntimeEventListener {
        public final List<Integer> selectedRule = new ArrayList<Integer>();

        public void afterEvaluateDecisionTable(AfterEvaluateDecisionTableEvent event) {
            this.selectedRule.addAll(event.getSelected());
        }
    }
}

