/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.documentation.ws;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.remote.client.api.RemoteWebserviceClientBuilder;
import org.kie.remote.client.documentation.objects.MyType;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.jaxb.gen.GetTaskCommand;
import org.kie.remote.jaxb.gen.GetTaskContentCommand;
import org.kie.remote.jaxb.gen.GetTasksByProcessInstanceIdCommand;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.remote.jaxb.gen.util.JaxbStringObjectPair;
import org.kie.remote.services.ws.command.generated.CommandWebService;
import org.kie.remote.services.ws.command.generated.CommandWebServiceException;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbLongListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceJavaApiExamples {
    private Logger logger = LoggerFactory.getLogger(WebserviceJavaApiExamples.class);

    private static CommandWebService createWebserviceClient(URL applicationUrl, String user, String password, String deploymentId) {
        CommandWebService client = (CommandWebService)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)((RemoteWebserviceClientBuilder)RemoteRuntimeEngineFactory.newCommandWebServiceClientBuilder().addServerUrl(applicationUrl).addUserName(user)).addPassword(password)).addDeploymentId(deploymentId)).addExtraJaxbClasses(new Class[]{MyType.class})).buildBasicAuthClient();
        return client;
    }

    private static <T> T doWebserviceSingleCommandRequest(CommandWebService service, Command<?> cmd, Class<T> respClass, String deploymentId) throws CommandWebServiceException {
        JaxbCommandsRequest req = new JaxbCommandsRequest(deploymentId, cmd);
        JaxbCommandsResponse response = service.execute(req);
        JaxbCommandResponse cmdResp = (JaxbCommandResponse)response.getResponses().get(0);
        return (T)cmdResp;
    }

    public static void startSimpleProcess(URL applicationUrl, String user, String password, String deploymentId, String processId) throws Exception {
        CommandWebService commandWebService = WebserviceJavaApiExamples.createWebserviceClient(applicationUrl, user, password, deploymentId);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(processId);
        JaxbStringObjectPairArray map = new JaxbStringObjectPairArray();
        JaxbStringObjectPair keyValue = new JaxbStringObjectPair();
        keyValue.setKey("myobject");
        keyValue.setValue((Object)new MyType("variable", 29));
        map.getItems().add(keyValue);
        spc.setParameter(map);
        JaxbProcessInstanceResponse jpir = WebserviceJavaApiExamples.doWebserviceSingleCommandRequest(commandWebService, spc, JaxbProcessInstanceResponse.class, deploymentId);
        long procInstId = jpir.getId();
        GetTasksByProcessInstanceIdCommand gtbic = new GetTasksByProcessInstanceIdCommand();
        gtbic.setProcessInstanceId(Long.valueOf(procInstId));
        JaxbLongListResponse jllr = WebserviceJavaApiExamples.doWebserviceSingleCommandRequest(commandWebService, gtbic, JaxbLongListResponse.class, deploymentId);
        List taskIds = jllr.getResult();
        long taskId = (Long)taskIds.get(0);
        GetTaskCommand gtc = new GetTaskCommand();
        gtc.setTaskId(Long.valueOf(taskId));
        GetTaskContentCommand gtcc = new GetTaskContentCommand();
        gtcc.setTaskId(Long.valueOf(taskId));
        JaxbCommandsRequest req = new JaxbCommandsRequest(deploymentId, (Command)gtc);
        req.getCommands().add(gtcc);
        JaxbCommandsResponse response = commandWebService.execute(req);
        Task task = (Task)((JaxbCommandResponse)response.getResponses().get(0)).getResult();
        Map contentMap = (Map)((JaxbCommandResponse)response.getResponses().get(1)).getResult();
    }
}

