/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.api.identifiers;

import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.drl.api.identifiers.DrlSessionIdFactory;
import org.kie.drl.api.identifiers.LocalComponentIdDrlSession;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.identifiers.ReflectiveAppRoot;

class DrlSessionIdFactoryTest {
    DrlSessionIdFactoryTest() {
    }

    @Test
    void get() {
        long identifier = Math.abs(new Random().nextLong());
        String basePath = "/TestingRule/TestedRule";
        ModelLocalUriId modelLocalUriId = new ModelLocalUriId(LocalUri.parse((String)("/pmml" + basePath)));
        Assertions.assertThat((String)modelLocalUriId.model()).isEqualTo("pmml");
        Assertions.assertThat((String)modelLocalUriId.basePath()).isEqualTo(basePath);
        LocalComponentIdDrlSession retrieved = ((DrlSessionIdFactory)new ReflectiveAppRoot("").get(DrlSessionIdFactory.class)).get(modelLocalUriId.basePath(), identifier);
        Assertions.assertThat((String)retrieved.model()).isEqualTo("drl");
        String expected = basePath + "/" + identifier;
        Assertions.assertThat((String)retrieved.basePath()).isEqualTo(expected);
    }
}

