/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.kiesession.local.utils;

import java.util.Optional;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.utils.EfestoKieSessionUtil;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlRuntimeHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)DrlRuntimeHelper.class.getName());

    private DrlRuntimeHelper() {
    }

    public static boolean canManage(EfestoInput toEvaluate) {
        return toEvaluate instanceof EfestoInputDrlKieSessionLocal && GeneratedResourceUtils.getGeneratedExecutableResource((FRI)toEvaluate.getFRI(), (String)"drl").isPresent();
    }

    public static Optional<EfestoOutputDrlKieSessionLocal> execute(EfestoInputDrlKieSessionLocal toEvaluate, EfestoRuntimeContext context) {
        KieSession kieSession;
        try {
            kieSession = EfestoKieSessionUtil.loadKieSession((FRI)toEvaluate.getFRI(), (EfestoRuntimeContext)context);
        }
        catch (Exception e) {
            logger.warn("{} can not execute {}", new Object[]{DrlRuntimeHelper.class.getName(), toEvaluate.getFRI(), e});
            return Optional.empty();
        }
        if (kieSession == null) {
            return Optional.empty();
        }
        try {
            String sessionPath = toEvaluate.getFRI().getBasePath() + "/" + kieSession.getIdentifier();
            FRI sessionFRI = new FRI(sessionPath, "drl");
            return Optional.of(new EfestoOutputDrlKieSessionLocal(sessionFRI, kieSession));
        }
        catch (Exception e) {
            throw new KieRuntimeServiceException(String.format("%s failed to execute %s", DrlRuntimeHelper.class.getName(), toEvaluate.getFRI()));
        }
    }
}

