/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.mapinput.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.drl.engine.mapinput.compilation.model.test.Applicant;
import org.kie.drl.engine.mapinput.compilation.model.test.LoanApplication;
import org.kie.drl.engine.runtime.mapinput.model.EfestoInputDrlMap;
import org.kie.drl.engine.runtime.mapinput.utils.DrlRuntimeHelper;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.runtimemanager.api.model.AbstractEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.memorycompiler.KieMemoryCompiler;

class DrlRuntimeHelperTest {
    private static final String basePath = "LoanApplication";
    private static KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;

    DrlRuntimeHelperTest() {
    }

    @BeforeAll
    static void setUp() {
        memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
    }

    @Test
    void canManage() {
        FRI fri = new FRI(basePath, "drl");
        Object darInputDrlMap = new EfestoInputDrlMap(fri, new EfestoMapInputDTO(null, null, null, null, null, null));
        Assertions.assertThat((boolean)DrlRuntimeHelper.canManage((EfestoInput)darInputDrlMap)).isTrue();
        darInputDrlMap = new AbstractEfestoInput(fri, ""){};
        Assertions.assertThat((boolean)DrlRuntimeHelper.canManage((EfestoInput)darInputDrlMap)).isFalse();
        fri = new FRI("notexisting", "drl");
        darInputDrlMap = new EfestoInputDrlMap(fri, null);
        Assertions.assertThat((boolean)DrlRuntimeHelper.canManage((EfestoInput)darInputDrlMap)).isFalse();
    }

    @Test
    void execute() {
        ArrayList<LoanApplication> inserts = new ArrayList<LoanApplication>();
        inserts.add(new LoanApplication("ABC10001", new Applicant("John", 45), 2000, 1000));
        inserts.add(new LoanApplication("ABC10002", new Applicant("Paul", 25), 5000, 100));
        inserts.add(new LoanApplication("ABC10015", new Applicant("George", 12), 1000, 100));
        ArrayList approvedApplications = new ArrayList();
        HashMap<String, Serializable> globals = new HashMap<String, Serializable>();
        globals.put("approvedApplications", approvedApplications);
        globals.put("maxAmount", Integer.valueOf(5000));
        EfestoMapInputDTO darMapInputDTO = new EfestoMapInputDTO(inserts, globals, Collections.emptyMap(), Collections.emptyMap(), "modelname", "packageName");
        EfestoInputDrlMap darInputDrlMap = new EfestoInputDrlMap(new FRI(basePath, "drl"), darMapInputDTO);
        Optional retrieved = DrlRuntimeHelper.execute((AbstractEfestoInput)darInputDrlMap, (KieMemoryCompiler.MemoryCompilerClassLoader)memoryCompilerClassLoader);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        Assertions.assertThat(approvedApplications).hasSize(1);
        LoanApplication approvedApplication = (LoanApplication)approvedApplications.get(0);
        Assertions.assertThat((Object)approvedApplication).isEqualTo(inserts.get(0));
    }
}

