/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.mapinput.utils;

import java.util.Map;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.efesto.runtimemanager.api.model.EfestoOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapInputSessionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MapInputSessionUtils.class.getName());
    final KieSession kieSession;
    final String modelName;
    final String packageName;

    private MapInputSessionUtils(KieSession kieSession, EfestoMapInputDTO darMapInputDTO) {
        this.modelName = darMapInputDTO.getModelName();
        this.packageName = darMapInputDTO.getPackageName();
        this.kieSession = kieSession;
        darMapInputDTO.getInserts().forEach(arg_0 -> ((KieSession)kieSession).insert(arg_0));
        darMapInputDTO.getGlobals().forEach((key, value) -> this.insertObjectInSession(value, (String)key));
        this.addObjectsToSession(darMapInputDTO.getUnwrappedInputParams(), darMapInputDTO.getFieldTypeMap());
    }

    public static Builder builder(KieSession kieSession, EfestoMapInputDTO darMapInputDTO) {
        return new Builder(kieSession, darMapInputDTO);
    }

    public void fireAllRules() {
        this.kieSession.fireAllRules();
        this.kieSession.dispose();
    }

    void insertObjectInSession(Object toInsert, String globalName) {
        this.kieSession.insert(toInsert);
        this.kieSession.setGlobal(globalName, toInsert);
    }

    private void addObjectsToSession(Map<String, Object> unwrappedInputParams, Map<String, EfestoOriginalTypeGeneratedType> fieldTypeMap) {
        for (Map.Entry<String, Object> entry : unwrappedInputParams.entrySet()) {
            if (!fieldTypeMap.containsKey(entry.getKey())) {
                throw new KieRuntimeServiceException(String.format("Field %s not mapped to generated type", entry.getKey()));
            }
            try {
                String generatedTypeName = fieldTypeMap.get(entry.getKey()).getGeneratedType();
                FactType factType = this.kieSession.getKieBase().getFactType(this.packageName, generatedTypeName);
                if (factType == null) {
                    String name = String.format("%s.%s", this.packageName, generatedTypeName);
                    String error = String.format("Failed to retrieve FactType %s for input value %s", name, entry.getKey());
                    throw new KieRuntimeServiceException(error);
                }
                Object toAdd = factType.newInstance();
                factType.set(toAdd, "value", entry.getValue());
                this.kieSession.insert(toAdd);
            }
            catch (Exception e) {
                throw new KieRuntimeServiceException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class Builder {
        MapInputSessionUtils toBuild;

        private Builder(KieSession kieSession, EfestoMapInputDTO darMapInputDTO) {
            this.toBuild = new MapInputSessionUtils(kieSession, darMapInputDTO);
        }

        public Builder withAgendaEventListener(AgendaEventListener agendaEventListener) {
            this.toBuild.kieSession.addEventListener(agendaEventListener);
            return this;
        }

        public Builder withOutputFieldsMap(Map<String, Object> outputFieldsMap) {
            this.toBuild.insertObjectInSession(outputFieldsMap, "$outputFieldsMap");
            return this;
        }

        public MapInputSessionUtils build() {
            return this.toBuild;
        }
    }
}

