/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client.home;

import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.utils.ShortcutHelper;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.kie.workbench.common.screens.home.model.HomeShortcutLink;
import org.kie.workbench.drools.client.home.HomeProducer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;

@RunWith(value=MockitoJUnitRunner.class)
public class HomeProducerTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private TranslationService translationService;
    @Mock
    private ShortcutHelper shortcutHelper;
    private HomeProducer producer;

    @Before
    public void setup() {
        this.producer = new HomeProducer(this.placeManager, this.translationService, this.shortcutHelper);
        ((TranslationService)Mockito.doAnswer(invocation -> invocation.getArguments()[0]).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
    }

    @Test
    public void checkSetupWithProvisioningGranted() {
        Mockito.when((Object)this.shortcutHelper.authorize("ProvisioningManagementPerspective")).thenReturn((Object)true);
        HomeModel model = this.producer.get();
        this.assertHomeModel(model, "DeployDescription2");
        this.assertDesign(model);
        Assert.assertEquals((long)2L, (long)((HomeShortcut)model.getShortcuts().get(1)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Provisioning", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"ProvisioningManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.Servers", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(1)).getLabel());
        Assert.assertEquals((Object)"ServerManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(1)).getPerspectiveIdentifier());
    }

    @Test
    public void checkSetupWithProvisioningDenied() {
        Mockito.when((Object)this.shortcutHelper.authorize("ProvisioningManagementPerspective")).thenReturn((Object)false);
        HomeModel model = this.producer.get();
        this.assertHomeModel(model, "DeployDescription1");
        this.assertDesign(model);
        Assert.assertEquals((long)1L, (long)((HomeShortcut)model.getShortcuts().get(1)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Servers", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"ServerManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getPerspectiveIdentifier());
    }

    private void assertHomeModel(HomeModel model, String deployDescription) {
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"Heading", (Object)model.getWelcome());
        Assert.assertEquals((Object)"SubHeading", (Object)model.getDescription());
        Assert.assertEquals((long)2L, (long)model.getShortcuts().size());
        Assert.assertEquals((Object)"Design", (Object)((HomeShortcut)model.getShortcuts().get(0)).getHeading());
        Assert.assertEquals((Object)"DesignDescription", (Object)((HomeShortcut)model.getShortcuts().get(0)).getSubHeading());
        Assert.assertEquals((Object)"Deploy", (Object)((HomeShortcut)model.getShortcuts().get(1)).getHeading());
        Assert.assertEquals((Object)deployDescription, (Object)((HomeShortcut)model.getShortcuts().get(1)).getSubHeading());
    }

    private void assertDesign(HomeModel model) {
        Assert.assertEquals((long)1L, (long)((HomeShortcut)model.getShortcuts().get(0)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Projects", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"LibraryPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(0)).getPerspectiveIdentifier());
    }
}

