/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManager;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;

public class InMemorySessionFactory
implements SessionFactory {
    private AtomicLong processCounter = new AtomicLong(0L);
    private RuntimeEnvironment environment;
    private KieBase kbase;
    private Map<Long, KieSession> sessions = new ConcurrentHashMap<Long, KieSession>();

    public InMemorySessionFactory(RuntimeEnvironment environment) {
        this.environment = environment;
        this.kbase = environment.getKieBase();
    }

    public KieSession newKieSession() {
        KieSession ksession = this.kbase.newKieSession(this.environment.getConfiguration(), this.environment.getEnvironment());
        this.sessions.put(ksession.getIdentifier(), ksession);
        ProcessInstanceManager piManager = ((ProcessRuntimeImpl)((StatefulKnowledgeSessionImpl)ksession).getProcessRuntime()).getProcessInstanceManager();
        if (piManager instanceof DefaultProcessInstanceManager) {
            ((DefaultProcessInstanceManager)piManager).setProcessCounter(this.processCounter);
        }
        return ksession;
    }

    public KieSession findKieSessionById(Long sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId);
        }
        throw new SessionNotFoundException("Session with id " + sessionId + " was not found");
    }

    public void close() {
        this.sessions.clear();
    }

    public void onDispose(Long sessionId) {
        this.sessions.remove(sessionId);
    }

    protected Map<Long, KieSession> getSessions() {
        return this.sessions;
    }
}

