/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Map;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalTaskData;

public class AddTaskInputsCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private Map<String, Object> values;

    public AddTaskInputsCommand(String userId, long taskId, Map<String, Object> values) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.values = values;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        TaskEventSupport taskEventSupport = context.getTaskEventSupport();
        TaskPersistenceContext persistenceContext = context.getPersistenceContext();
        Task task = persistenceContext.findTask(this.taskId);
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        long inputContentId = task.getTaskData().getDocumentContentId();
        Content outputContent = persistenceContext.findContent(Long.valueOf(inputContentId));
        Map mergedContent = this.values;
        if (outputContent == null) {
            ContentMarshallerContext mcontext = context.getTaskContentService().getMarshallerContext(task);
            ContentData outputContentData = ContentMarshallerHelper.marshal((Task)task, this.values, (Environment)mcontext.getEnvironment());
            Content content = TaskModelProvider.getFactory().newContent();
            ((InternalContent)content).setContent(outputContentData.getContent());
            persistenceContext.persistContent(content);
            ((InternalTaskData)task.getTaskData()).setOutput(content.getId().longValue(), outputContentData);
        } else {
            ContentMarshallerContext mcontext = context.getTaskContentService().getMarshallerContext(task);
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])outputContent.getContent(), (Environment)mcontext.getEnvironment(), (ClassLoader)mcontext.getClassloader());
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                ((Map)unmarshalledObject).putAll(this.values);
                mergedContent = (Map)unmarshalledObject;
            }
            ContentData outputContentData = ContentMarshallerHelper.marshal((Task)task, (Object)unmarshalledObject, (Environment)mcontext.getEnvironment());
            ((InternalContent)outputContent).setContent(outputContentData.getContent());
            persistenceContext.persistContent(outputContent);
        }
        ((InternalTaskData)task.getTaskData()).setTaskInputVariables(mergedContent);
        taskEventSupport.fireAfterTaskInputVariablesChanged(task, (TaskContext)context, mergedContent);
        return null;
    }
}

