/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.persistence;

import java.util.HashMap;
import java.util.List;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.drools.core.command.impl.ExecutableCommand;
import org.jbpm.kie.services.impl.query.persistence.QueryDefinitionEntity;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistDataSetListener
implements DataSetDefRegistryListener {
    private static final Logger logger = LoggerFactory.getLogger(PersistDataSetListener.class);
    private TransactionalCommandService commandService;

    public PersistDataSetListener() {
    }

    public PersistDataSetListener(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void onDataSetDefStale(DataSetDef def) {
    }

    public void onDataSetDefModified(DataSetDef oldDef, DataSetDef newDef) {
        if (this.commandService != null) {
            try {
                final String uniqueQueryName = oldDef.getUUID();
                final QueryDefinitionEntity updated = this.get(newDef);
                if (updated != null) {
                    this.commandService.execute((Command)new ExecutableCommand<Void>(){
                        private static final long serialVersionUID = 6476274660250555118L;

                        public Void execute(Context context) {
                            JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("name", uniqueQueryName);
                            List entities = (List)ctx.queryWithParametersInTransaction("getQueryDefinitionByName", params, List.class);
                            if (entities != null && !entities.isEmpty()) {
                                for (QueryDefinitionEntity entity : entities) {
                                    entity.setExpression(updated.getExpression());
                                    entity.setSource(updated.getSource());
                                    entity.setTarget(updated.getTarget());
                                    ctx.merge((Object)entity);
                                    logger.debug("Updated data set {} to value: {}", (Object)entity.getName(), (Object)entity);
                                }
                            } else {
                                ctx.persist((Object)updated);
                                logger.debug("Inserted data set {} as it did not exist with value: {}", (Object)updated.getName(), (Object)updated);
                            }
                            return null;
                        }
                    });
                    logger.info("Data set {} updated in db storage", (Object)updated.getName());
                }
            }
            catch (Exception e) {
                logger.warn("Unable to persist data set {} in db due to {}", (Object)newDef.getUUID(), (Object)e.getMessage());
            }
        }
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
        if (this.commandService != null) {
            try {
                final QueryDefinitionEntity entity = this.get(newDef);
                if (entity != null) {
                    this.commandService.execute((Command)new ExecutableCommand<Void>(){
                        private static final long serialVersionUID = 6476274660250555128L;

                        public Void execute(Context context) {
                            JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("name", entity.getName());
                            List entities = (List)ctx.queryWithParametersInTransaction("getQueryDefinitionByName", params, List.class);
                            if (entities == null || entities.isEmpty()) {
                                ctx.persist((Object)entity);
                                logger.info("Data set {} saved in db storage", (Object)entity.getName());
                            }
                            return null;
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.warn("Unable to persist data set {} in db due to {}", (Object)newDef.getUUID(), (Object)e.getMessage());
            }
        }
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        if (this.commandService != null) {
            final String uniqueQueryName = oldDef.getUUID();
            try {
                this.commandService.execute((Command)new ExecutableCommand<Void>(){
                    private static final long serialVersionUID = 6476274660250555118L;

                    public Void execute(Context context) {
                        JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("name", uniqueQueryName);
                        List entities = (List)ctx.queryWithParametersInTransaction("getQueryDefinitionByName", params, List.class);
                        if (entities != null) {
                            for (QueryDefinitionEntity entity : entities) {
                                ctx.remove((Object)entity);
                            }
                        }
                        return null;
                    }
                });
                logger.info("Data set {} removed from db storage", (Object)uniqueQueryName);
            }
            catch (Exception e) {
                logger.warn("Unable to persist data set {} in db due to {}", (Object)uniqueQueryName, (Object)e.getMessage());
            }
        }
    }

    protected QueryDefinitionEntity get(DataSetDef def) {
        QueryDefinitionEntity entity = null;
        if (def instanceof SQLDataSetDef && ((SQLDataSetDef)def).getDbSQL() != null) {
            String target = "CUSTOM";
            String nameWithTarget = def.getName();
            if (nameWithTarget.indexOf("::") != -1) {
                try {
                    target = nameWithTarget.split("::")[1];
                    target = QueryDefinition.Target.valueOf((String)target).name();
                }
                catch (Exception e) {
                    target = "CUSTOM";
                }
            }
            entity = new QueryDefinitionEntity();
            entity.setName(def.getUUID());
            entity.setExpression(((SQLDataSetDef)def).getDbSQL());
            entity.setSource(((SQLDataSetDef)def).getDataSource());
            entity.setTarget(target);
        }
        return entity;
    }
}

