/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessAdminTasksPreprocessor
implements DataSetPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessAdminTasksPreprocessor.class);
    private IdentityProvider identityProvider;

    public BusinessAdminTasksPreprocessor(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null) {
            return;
        }
        ArrayList<String> orgEntities = new ArrayList<String>(this.identityProvider.getRoles());
        orgEntities.add(this.identityProvider.getName());
        ColumnFilter columnFilter = FilterFactory.equalsTo((String)"ID", orgEntities);
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
    }
}

