/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.mem;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryExecutorStoreService
implements ExecutorStoreService {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryExecutorStoreService.class);
    private AtomicLong requestIds = new AtomicLong();
    private AtomicLong errorIds = new AtomicLong();
    private static ConcurrentNavigableMap<Long, RequestInfo> requests = new ConcurrentSkipListMap<Long, RequestInfo>();
    private static ConcurrentNavigableMap<Long, RequestInfo> processedRequests = new ConcurrentSkipListMap<Long, RequestInfo>();
    private static ConcurrentNavigableMap<Long, ErrorInfo> errors = new ConcurrentSkipListMap<Long, ErrorInfo>();
    private ExecutorEventSupport eventSupport = new ExecutorEventSupport();

    public InMemoryExecutorStoreService(boolean active) {
    }

    public void setEventSupport(ExecutorEventSupport eventSupport) {
        this.eventSupport = eventSupport;
    }

    public synchronized void persistRequest(RequestInfo request) {
        this.setId(request, this.requestIds.incrementAndGet());
        logger.debug("Storing request {}", (Object)request);
        requests.put(request.getId(), request);
    }

    public synchronized void updateRequest(RequestInfo request) {
        if (request.getStatus() == STATUS.CANCELLED || request.getStatus() == STATUS.DONE || request.getStatus() == STATUS.ERROR || request.getStatus() == STATUS.RUNNING) {
            logger.debug("Updating request by removing it as it was already processed {}", (Object)request);
            requests.remove(request.getId());
            if (processedRequests.size() > 100) {
                processedRequests.pollFirstEntry();
            }
            processedRequests.put(request.getId(), request);
            if (request.getErrorInfo() != null) {
                for (ErrorInfo error : request.getErrorInfo()) {
                    if (error.getId() != null) continue;
                    this.persistError(error);
                }
            }
            return;
        }
        logger.debug("Regular update of request {}", (Object)request);
        requests.put(request.getId(), request);
    }

    public synchronized RequestInfo removeRequest(Long requestId) {
        RequestInfo request = (RequestInfo)requests.remove(requestId);
        if (processedRequests.size() > 100) {
            processedRequests.pollFirstEntry();
        }
        processedRequests.put(request.getId(), request);
        request.setStatus(STATUS.CANCELLED);
        return request;
    }

    public synchronized RequestInfo findRequest(Long id) {
        return (RequestInfo)requests.get(id);
    }

    public synchronized void persistError(ErrorInfo error) {
        this.setId(error, this.errorIds.incrementAndGet());
        errors.put(error.getId(), error);
    }

    public synchronized void updateError(ErrorInfo error) {
        errors.put(error.getId(), error);
    }

    public synchronized ErrorInfo removeError(Long errorId) {
        return (ErrorInfo)errors.remove(errorId);
    }

    public synchronized ErrorInfo findError(Long id) {
        return (ErrorInfo)errors.get(id);
    }

    public Runnable buildExecutorRunnable() {
        return ExecutorServiceFactory.buildRunable(this.eventSupport);
    }

    public synchronized RequestInfo getAndLockFirst() {
        if (requests.isEmpty()) {
            return null;
        }
        Long toProceed = (Long)requests.firstKey();
        return (RequestInfo)requests.remove(toProceed);
    }

    public synchronized Map<Long, RequestInfo> getRequests() {
        return requests;
    }

    public synchronized Map<Long, ErrorInfo> getErrors() {
        return errors;
    }

    public synchronized Map<Long, RequestInfo> getProcessedRequests() {
        return processedRequests;
    }

    protected void setId(Object object, Long id) {
        try {
            Field idField = object.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(object, id);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set id for object" + object);
        }
    }
}

