/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.function.Function;

public class XStreamUtils {
    private static final String[] VOID_TYPES = new String[]{"void.class", "Void.class"};

    public static XStream createXStream() {
        return XStreamUtils.internalCreateXStream(new XStream());
    }

    public static XStream createXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        return XStreamUtils.internalCreateXStream(new XStream(hierarchicalStreamDriver));
    }

    public static XStream createXStream(HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader) {
        return XStreamUtils.internalCreateXStream(new XStream(null, hierarchicalStreamDriver, new ClassLoaderReference(classLoader)));
    }

    public static XStream createXStream(ReflectionProvider reflectionProvider) {
        return XStreamUtils.internalCreateXStream(new XStream(reflectionProvider));
    }

    public static XStream createXStream(ReflectionProvider reflectionProvider, final Function<MapperWrapper, MapperWrapper> mapper) {
        return XStreamUtils.internalCreateXStream(new XStream(reflectionProvider){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return (MapperWrapper)mapper.apply(next);
            }
        });
    }

    private static XStream internalCreateXStream(XStream xstream) {
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"java.**", "javax.**", "org.kie.**", "org.drools.**", "org.jbpm.**", "org.optaplanner.**", "org.appformer.**"}));
        return xstream;
    }
}

