/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.common.ProjectClassLoader;
import org.jbpm.process.core.datatype.DataType;
import org.kie.internal.xstream.XStreamUtils;

public class ObjectDataType
implements DataType {
    private static final long serialVersionUID = 510L;
    private String className;
    private ClassLoader classLoader;

    public ObjectDataType() {
    }

    public ObjectDataType(String className) {
        this.setClassName(className);
    }

    public ObjectDataType(String className, ClassLoader classLoader) {
        this.setClassName(className);
        this.setClassLoader(classLoader);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, value.getClass().getClassLoader());
            if (clazz.isInstance(value)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find data type " + this.className);
        }
        return false;
    }

    @Override
    public Object readValue(String value) {
        return this.getXStream().fromXML(value);
    }

    @Override
    public String writeValue(Object value) {
        return this.getXStream().toXML(value);
    }

    private XStream getXStream() {
        XStream xstream = XStreamUtils.createXStream();
        if (this.classLoader != null) {
            Map store;
            xstream.setClassLoader(this.classLoader);
            if (this.classLoader instanceof ProjectClassLoader && (store = ((ProjectClassLoader)this.classLoader).getStore()) != null) {
                String[] classes = (String[])store.keySet().stream().map(s -> s.replace('/', '.')).map(s -> s.endsWith(".class") ? s.substring(0, s.length() - ".class".length()) : s).toArray(String[]::new);
                xstream.addPermission((TypePermission)new ExplicitTypePermission(classes));
            }
        }
        return xstream;
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }
}

