/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.validation.groups.ElasticSearchDataSetDefValidation;

public class ElasticSearchDataSetDef
extends DataSetDef {
    @NotNull(groups={ElasticSearchDataSetDefValidation.class})
    @Size(min=1, groups={ElasticSearchDataSetDefValidation.class})
    protected String serverURL;
    protected String clusterName;
    @NotNull(groups={ElasticSearchDataSetDefValidation.class})
    @Size(min=1, groups={ElasticSearchDataSetDefValidation.class})
    protected String index;
    protected String type;
    protected String query;
    protected String relevance;
    protected ColumnSort columnSort;

    public ElasticSearchDataSetDef() {
        super.setProvider(DataSetProviderType.ELASTICSEARCH);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getRelevance() {
        return this.relevance;
    }

    public void setRelevance(String relevance) {
        this.relevance = relevance;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    @Override
    public Integer getCacheMaxRows() {
        return this.cacheMaxRows;
    }

    @Override
    public void setCacheMaxRows(Integer cacheMaxRows) {
        this.cacheMaxRows = cacheMaxRows;
    }

    public ColumnSort getColumnSort() {
        return this.columnSort;
    }

    public void setColumnSort(ColumnSort columnSort) {
        this.columnSort = columnSort;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            ElasticSearchDataSetDef other = (ElasticSearchDataSetDef)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.serverURL != null && !this.serverURL.equals(other.serverURL)) {
                return false;
            }
            if (this.clusterName != null && !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            return this.index == null || this.index.equals(other.index);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public DataSetDef clone() {
        ElasticSearchDataSetDef def = new ElasticSearchDataSetDef();
        this.clone(def);
        def.setServerURL(this.getServerURL());
        def.setClusterName(this.getClusterName());
        def.setIndex(this.getIndex());
        def.setType(this.getType());
        return def;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("UUID=").append(this.UUID).append("\n");
        out.append("Provider=").append(this.provider).append("\n");
        out.append("Public=").append(this.isPublic).append("\n");
        out.append("Push enabled=").append(this.pushEnabled).append("\n");
        out.append("Push max size=").append(this.pushMaxSize).append(" Kb\n");
        out.append("Server URL=").append(this.serverURL).append("\n");
        out.append("Index=").append(this.index).append("\n");
        out.append("Type=").append(this.type).append("\n");
        out.append("Query=").append(this.query).append("\n");
        out.append("Get all columns=").append(this.allColumnsEnabled).append("\n");
        out.append("Cache enabled=").append(this.cacheEnabled).append("\n");
        out.append("Cache max rows=").append(this.cacheMaxRows).append(" Kb\n");
        return out.toString();
    }

    public static enum ElasticSearchKeywords {
        ALL;

        private static final String KEYWORD_ALL = "_all";

        public String toString() {
            if (this.equals((Object)ALL)) {
                return KEYWORD_ALL;
            }
            return super.toString();
        }
    }
}

