/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.persistence.api.TransactionManager;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SynchronizedRuntimeImpl;
import org.jbpm.runtime.manager.impl.error.ExecutionErrorManagerImpl;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonRuntimeManager
extends AbstractRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(SingletonRuntimeManager.class);
    private RuntimeEngine singleton;
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;

    public SingletonRuntimeManager() {
        super(null, null);
    }

    public SingletonRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.identifier = identifier;
    }

    @Override
    public void init() {
        String location = this.getLocation();
        Long knownSessionId = this.getPersistedSessionId(location, this.identifier);
        InternalTaskService internalTaskService = (InternalTaskService)this.taskServiceFactory.newTaskService();
        boolean owner = false;
        TransactionManager tm = null;
        if (this.environment.usePersistence()) {
            tm = this.getTransactionManagerInternal(this.environment.getEnvironment());
            owner = tm.begin();
        }
        try {
            if (knownSessionId > 0L) {
                try {
                    this.singleton = new SynchronizedRuntimeImpl(this.factory.findKieSessionById(knownSessionId), internalTaskService);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (this.singleton == null) {
                this.singleton = new SynchronizedRuntimeImpl(this.factory.newKieSession(), internalTaskService);
                this.persistSessionId(location, this.identifier, this.singleton.getKieSession().getIdentifier());
            }
            ((RuntimeEngineImpl)this.singleton).setManager((RuntimeManager)this);
            TaskContentRegistry.get().addMarshallerContext(this.getIdentifier(), new ContentMarshallerContext(this.environment.getEnvironment(), this.environment.getClassLoader()));
            this.configureRuntimeOnTaskService(internalTaskService, this.singleton);
            this.registerItems(this.singleton);
            this.attachManager(this.singleton);
            this.registry.register((RuntimeManager)this);
            if (tm != null) {
                tm.commit(owner);
            }
        }
        catch (Exception e) {
            if (tm != null) {
                tm.rollback(owner);
            }
            throw new RuntimeException("Exception while initializing runtime manager " + this.identifier, e);
        }
    }

    @Override
    public void activate() {
        super.activate();
        this.singleton.getKieSession().execute((Command)new ExecutableCommand<Void>(){
            private static final long serialVersionUID = 4698203316007668876L;

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ksession.getEnvironment().set("Active", (Object)true);
                InternalProcessRuntime processRuntime = ((InternalKnowledgeRuntime)ksession).getProcessRuntime();
                ((ProcessRuntimeImpl)processRuntime).initProcessEventListeners();
                ((ProcessRuntimeImpl)processRuntime).initStartTimers();
                return null;
            }
        });
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.singleton.getKieSession().execute((Command)new ExecutableCommand<Void>(){
            private static final long serialVersionUID = 8099201526203340191L;

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ksession.getEnvironment().set("Active", (Object)false);
                InternalProcessRuntime processRuntime = ((InternalKnowledgeRuntime)ksession).getProcessRuntime();
                ((ProcessRuntimeImpl)processRuntime).removeProcessEventListeners();
                return null;
            }
        });
    }

    public RuntimeEngine getRuntimeEngine(Context context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        ((ExecutionErrorManagerImpl)this.executionErrorManager).createHandler();
        return this.singleton;
    }

    public void signalEvent(String type, Object event) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        this.singleton.getKieSession().signalEvent(type, event);
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (this.singleton != null && this.singleton.getKieSession().getIdentifier() != ksession.getIdentifier()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        ((ExecutionErrorManagerImpl)this.executionErrorManager).closeHandler();
    }

    @Override
    public void close() {
        if (this.singleton == null) {
            return;
        }
        super.close();
        try {
            this.removeRuntimeFromTaskService();
        }
        catch (UnsupportedOperationException e) {
            logger.debug("Exception while closing task service, was it initialized? {}", (Object)e.getMessage());
        }
        if (this.singleton instanceof Disposable) {
            ((Disposable)this.singleton).dispose();
        }
        this.factory.close();
        this.singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getPersistedSessionId(String location, String identifier) {
        File sessionIdStore = new File(location + File.separator + identifier + "-jbpmSessionId.ser");
        if (sessionIdStore.exists()) {
            Long knownSessionId = null;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                fis = new FileInputStream(sessionIdStore);
                in = new ObjectInputStream(fis);
                Object tmp = in.readObject();
                if (tmp instanceof Integer) {
                    tmp = new Long(((Integer)tmp).intValue());
                }
                knownSessionId = (Long)tmp;
                Long l = (long)knownSessionId;
                return l;
            }
            catch (Exception e) {
                Long l = 0L;
                return l;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistSessionId(String location, String identifier, Long ksessionId) {
        if (location == null) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(location + File.separator + identifier + "-jbpmSessionId.ser");
            out = new ObjectOutputStream(fos);
            out.writeObject((long)ksessionId);
            out.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getLocation() {
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        return location;
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }
}

