/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.DefaultTimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TrackableTimeJobFactoryManager;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessInstanceManagerFactory;
import org.jbpm.process.instance.event.SignalManager;
import org.jbpm.process.instance.event.SignalManagerFactory;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.kiebase.AfterProcessAddedEvent;
import org.kie.api.event.kiebase.AfterProcessRemovedEvent;
import org.kie.api.event.kiebase.DefaultKieBaseEventListener;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.CompositeClassLoader;

public class ProcessRuntimeImpl
implements InternalProcessRuntime {
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private TimerManager timerManager;
    private ProcessEventSupport processEventSupport;
    private DefaultKieBaseEventListener knowledgeBaseListener;

    public ProcessRuntimeImpl(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        AcceptsTimerJobFactoryManager jfm = (AcceptsTimerJobFactoryManager)kruntime.getTimerService();
        if (jfm.getTimerJobFactoryManager() instanceof DefaultTimerJobFactoryManager) {
            jfm.setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        }
        ((AcceptsTimerJobFactoryManager)kruntime.getTimerService()).setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(kruntime, kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
        this.initProcessActivationListener();
        this.initStartTimers();
    }

    private void initStartTimers() {
        KieBase kbase = this.kruntime.getKieBase();
        Collection processes = kbase.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new RegisterStartTimerAction(p.getId(), startNodes, this.timerManager));
            this.kruntime.executeQueuedActions();
        }
    }

    public ProcessRuntimeImpl(InternalWorkingMemory workingMemory) {
        AcceptsTimerJobFactoryManager jfm = (AcceptsTimerJobFactoryManager)workingMemory.getTimerService();
        if (jfm.getTimerJobFactoryManager() instanceof DefaultTimerJobFactoryManager) {
            jfm.setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        }
        this.kruntime = workingMemory.getKnowledgeRuntime();
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(this.kruntime, this.kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        this.initProcessEventListeners();
        this.initProcessActivationListener();
        this.initStartTimers();
    }

    private void initProcessInstanceManager() {
        String processInstanceManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getProcessInstanceManagerFactory();
        try {
            this.processInstanceManager = ((ProcessInstanceManagerFactory)this.loadClass(processInstanceManagerClass).newInstance()).createProcessInstanceManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initSignalManager() {
        String signalManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getSignalManagerFactory();
        try {
            this.signalManager = ((SignalManagerFactory)this.loadClass(signalManagerClass).newInstance()).createSignalManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.getRootClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getRootClassLoader() {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.kruntime.getKieBase();
        if (kbase != null) {
            return kbase.getRootClassLoader();
        }
        CompositeClassLoader result = new CompositeClassLoader();
        result.addClassLoader(Thread.currentThread().getContextClassLoader());
        return result;
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.startProcess(processId, parameters, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId(), trigger);
        }
        return null;
    }

    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(long processInstanceId, String trigger) {
        try {
            this.kruntime.startOperation();
            if (!this.kruntime.getActionQueue().isEmpty()) {
                this.kruntime.executeQueuedActions();
            }
            org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            this.getProcessEventSupport().fireBeforeProcessStarted(processInstance, (KnowledgeRuntime)this.kruntime);
            ((ProcessInstance)processInstance).start(trigger);
            this.getProcessEventSupport().fireAfterProcessStarted(processInstance, (KnowledgeRuntime)this.kruntime);
            org.kie.api.runtime.process.ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(long processInstanceId) {
        return this.startProcessInstance(processInstanceId, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            Process process;
            this.kruntime.startOperation();
            if (!this.kruntime.getActionQueue().isEmpty()) {
                this.kruntime.executeQueuedActions();
            }
            if ((process = this.kruntime.getKieBase().getProcess(processId)) == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, correlationKey, parameters);
            return processInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processInstanceManager.getProcessInstance(correlationKey);
    }

    private ProcessInstance startProcess(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, correlationKey, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id) {
        return this.getProcessInstance(id, false);
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    private void initProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.initProcessEventListener(process);
        }
        this.knowledgeBaseListener = new DefaultKieBaseEventListener(){

            public void afterProcessAdded(AfterProcessAddedEvent event) {
                ProcessRuntimeImpl.this.initProcessEventListener(event.getProcess());
            }

            public void afterProcessRemoved(AfterProcessRemovedEvent event) {
                if (event.getProcess() instanceof RuleFlowProcess) {
                    String type = (String)((RuleFlowProcess)event.getProcess()).getRuntimeMetaData().get("StartProcessEventType");
                    StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)event.getProcess()).getRuntimeMetaData().get("StartProcessEventListener");
                    if (type != null && listener != null) {
                        ProcessRuntimeImpl.this.signalManager.removeEventListener(type, listener);
                    }
                }
            }
        };
        this.kruntime.getKieBase().addEventListener((KieBaseEventListener)this.knowledgeBaseListener);
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(process.getId(), filters, trigger.getInMappings());
                    this.signalManager.addEventListener(type, listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener((java.util.EventListener)listener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener((java.util.EventListener)listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlowStateNode-")) {
                        int index = ruleName.indexOf("-", 18);
                        index = ruleName.indexOf("-", index + 1);
                        String eventType = ruleName.substring(0, index);
                        ProcessRuntimeImpl.this.signalManager.signalEvent(eventType, event);
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-")) {
                        ProcessRuntimeImpl.this.signalManager.signalEvent(ruleName, event);
                    }
                }
            }
        });
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (ProcessRuntimeImpl.this.kruntime instanceof StatefulKnowledgeSession) {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)ProcessRuntimeImpl.this.kruntime).getId(), null);
                } else {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    public void abortProcessInstance(long processInstanceId) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.timerManager.dispose();
        if (this.kruntime != null) {
            this.kruntime.getKieBase().removeEventListener((KieBaseEventListener)this.knowledgeBaseListener);
            this.kruntime = null;
        }
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public static class RegisterStartTimerAction
    implements WorkingMemoryAction {
        private List<StartNode> startNodes;
        private String processId;
        private TimerManager timerManager;

        public RegisterStartTimerAction(String processId, List<StartNode> startNodes, TimerManager timerManager) {
            this.processId = processId;
            this.startNodes = startNodes;
            this.timerManager = timerManager;
        }

        public RegisterStartTimerAction(MarshallerReaderContext context) {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.initTimer(workingMemory.getKnowledgeRuntime());
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.initTimer(kruntime);
        }

        public void write(MarshallerWriteContext context) throws IOException {
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }

        private void initTimer(InternalKnowledgeRuntime kruntime) {
            for (StartNode startNode : this.startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                TimerInstance timerInstance = null;
                if (CronExpression.isValidExpression((String)startNode.getTimer().getDelay())) {
                    timerInstance = new TimerInstance();
                    timerInstance.setCronExpression(startNode.getTimer().getDelay());
                } else {
                    timerInstance = this.createTimerInstance(startNode.getTimer(), kruntime);
                }
                this.timerManager.registerTimer(timerInstance, this.processId, null);
            }
        }

        protected TimerInstance createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
            TimerInstance timerInstance = new TimerInstance();
            if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
                BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
                String delay = timer.getDelay();
                timerInstance.setDelay(businessCalendar.calculateBusinessTimeAsDuration(delay));
                if (timer.getPeriod() == null) {
                    timerInstance.setPeriod(0L);
                } else {
                    String period = timer.getPeriod();
                    timerInstance.setPeriod(businessCalendar.calculateBusinessTimeAsDuration(period));
                }
            } else {
                this.configureTimerInstance(timer, timerInstance);
            }
            timerInstance.setTimerId(timer.getId());
            return timerInstance;
        }

        private void configureTimerInstance(Timer timer, TimerInstance timerInstance) {
            Object s = null;
            long duration = -1L;
            switch (timer.getTimeType()) {
                case 2: {
                    long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                    if (repeatValues.length == 3) {
                        int parsedReapedCount = (int)repeatValues[0];
                        if (parsedReapedCount > -1) {
                            timerInstance.setRepeatLimit(parsedReapedCount + 1);
                        }
                        timerInstance.setDelay(repeatValues[1]);
                        timerInstance.setPeriod(repeatValues[2]);
                        break;
                    }
                    timerInstance.setDelay(repeatValues[0]);
                    timerInstance.setPeriod(repeatValues[0]);
                    break;
                }
                case 1: {
                    duration = DateTimeUtils.parseDuration(timer.getDelay());
                    timerInstance.setDelay(duration);
                    timerInstance.setPeriod(0L);
                    break;
                }
                case 3: {
                    duration = DateTimeUtils.parseDateAsDuration(timer.getDate());
                    timerInstance.setDelay(duration);
                    timerInstance.setPeriod(0L);
                    break;
                }
            }
        }

        private long resolveValue(String s) {
            return TimeUtils.parseTimeString((String)s);
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                    if ("event".equals(entry.getValue())) {
                        params.put(entry.getKey(), event);
                        continue;
                    }
                    params.put(entry.getKey(), entry.getValue());
                }
            }
            ProcessRuntimeImpl.this.startProcess(this.processId, params, type);
        }
    }
}

