/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;

public class AfterEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String afterOp = "after";
    public static Operator AFTER;
    public static Operator NOT_AFTER;
    private static String[] SUPPORTED_IDS;
    private Map<String, AfterEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public AfterEvaluatorDefinition() {
        AfterEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(afterOp, false) == null) {
            AFTER = Operator.addOperatorToRegistry(afterOp, false);
            NOT_AFTER = Operator.addOperatorToRegistry(afterOp, true);
            SUPPORTED_IDS = new String[]{afterOp};
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        AfterEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, AfterEvaluator>();
        }
        if ((eval = this.cache.get(key = (Object)((Object)left) + ":" + (Object)((Object)right) + ":" + isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new AfterEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class AfterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long initRange;
        private long finalRange;
        private String paramText;
        private boolean unwrapLeft;
        private boolean unwrapRight;

        public AfterEvaluator() {
            AfterEvaluatorDefinition.init();
        }

        public AfterEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? NOT_AFTER : AFTER);
            AfterEvaluatorDefinition.init();
            this.paramText = paramText;
            this.unwrapLeft = unwrapLeft;
            this.unwrapRight = unwrapRight;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initRange = in.readLong();
            this.finalRange = in.readLong();
            this.unwrapLeft = in.readBoolean();
            this.unwrapRight = in.readBoolean();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.initRange);
            out.writeLong(this.finalRange);
            out.writeBoolean(this.unwrapLeft);
            out.writeBoolean(this.unwrapRight);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            long init = this.initRange;
            long end = this.finalRange;
            if (this.getOperator().isNegated()) {
                if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                    init = this.finalRange + 1L;
                    end = Long.MAX_VALUE;
                } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = Long.MIN_VALUE;
                    end = this.initRange - 1L;
                } else if (init == Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = 0L;
                    end = -1L;
                } else {
                    init = Long.MIN_VALUE;
                    end = Long.MAX_VALUE;
                }
            }
            return new Interval(init, end);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'after' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long rightTS = ((VariableRestriction.LeftEndRightStartContextEntry)context).timestamp;
            long leftTS = context.declaration.getExtractor().isSelfReference() ? ((EventFactHandle)left).getEndTimestamp() : context.declaration.getExtractor().getLongValue(workingMemory, left.getObject());
            long dist = rightTS - leftTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long leftTS = ((VariableRestriction.LeftEndRightStartContextEntry)context).timestamp;
            long rightTS = context.getFieldExtractor().isSelfReference() ? ((EventFactHandle)right).getStartTimestamp() : context.getFieldExtractor().getLongValue(workingMemory, right.getObject());
            long dist = rightTS - leftTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long rightTS = extractor1.isSelfReference() ? ((EventFactHandle)handle1).getStartTimestamp() : extractor1.getLongValue(workingMemory, handle1.getObject());
            long leftTS = extractor2.isSelfReference() ? ((EventFactHandle)handle2).getEndTimestamp() : extractor2.getLongValue(workingMemory, handle2.getObject());
            long dist = rightTS - leftTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        @Override
        public String toString() {
            return this.getOperator().toString() + this.paramText != null ? "[" + this.paramText + "]" : "";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
            result = 31 * result + (int)(this.initRange ^ this.initRange >>> 32);
            result = 31 * result + (this.paramText == null ? 0 : this.paramText.hashCode());
            result = 31 * result + (this.unwrapLeft ? 1231 : 1237);
            result = 31 * result + (this.unwrapRight ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AfterEvaluator other = (AfterEvaluator)obj;
            if (this.finalRange != other.finalRange) {
                return false;
            }
            if (this.initRange != other.initRange) {
                return false;
            }
            if (this.paramText == null ? other.paramText != null : !this.paramText.equals(other.paramText)) {
                return false;
            }
            if (this.unwrapLeft != other.unwrapLeft) {
                return false;
            }
            return this.unwrapRight == other.unwrapRight;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.initRange = 1L;
                this.finalRange = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.initRange = parameters[0];
                this.finalRange = Long.MAX_VALUE;
            } else if (parameters.length == 2) {
                if (parameters[0] <= parameters[1]) {
                    this.initRange = parameters[0];
                    this.finalRange = parameters[1];
                } else {
                    this.initRange = parameters[1];
                    this.finalRange = parameters[0];
                }
            } else {
                throw new RuntimeException("[After Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

