/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.SynchronizedLeftTupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.phreak.LeftTupleEntry;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleComponent;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.BitMaskUtil;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode,
MemoryFactory {
    protected static final transient Logger log = LoggerFactory.getLogger(LeftInputAdapterNode.class);
    private static final long serialVersionUID = 510L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;
    protected boolean rootQueryNode;
    private int segmentMemoryIndex;
    private long sinkMask;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation());
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
        ObjectSource current = source;
        while (current.getType() != 30) {
            current = current.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)current;
        this.rootQueryNode = ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(otn.getObjectType());
        this.streamMode = context.isStreamMode() && context.getRootObjectTypeNode().getObjectType().isEvent();
        this.sinkMask = this.calculateSinkMask(context);
    }

    private long calculateSinkMask(BuildContext context) {
        Pattern pattern;
        Pattern pattern2 = pattern = context.getLastBuiltPatterns() != null ? context.getLastBuiltPatterns()[0] : null;
        if (pattern == null) {
            return -1L;
        }
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            return -1L;
        }
        Class<?> objectClass = ((ClassWireable)((Object)objectType)).getClassType();
        return PropertySpecificUtil.isPropertyReactive(context, objectClass) ? PropertySpecificUtil.calculatePositiveMask(pattern.getListenedProperties(), PropertySpecificUtil.getSettableProperties(context.getKnowledgeBase(), objectClass)) : -1L;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectSource = (ObjectSource)in.readObject();
        this.leftTupleMemoryEnabled = in.readBoolean();
        this.rootQueryNode = in.readBoolean();
        this.sinkMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectSource);
        out.writeBoolean(this.leftTupleMemoryEnabled);
        out.writeBoolean(this.rootQueryNode);
        out.writeLong(this.sinkMask);
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public int getSegmentMemoryIndex() {
        return this.segmentMemoryIndex;
    }

    public void setSegmentMemoryIndex(int segmentMemoryIndex) {
        this.segmentMemoryIndex = segmentMemoryIndex;
    }

    @Override
    public short getType() {
        return 120;
    }

    public boolean isRootQueryNode() {
        return this.rootQueryNode;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.leftTupleMemoryEnabled;
    }

    public ObjectSource getParentObjectSource() {
        return this.objectSource;
    }

    @Override
    public void attach(BuildContext context) {
        this.objectSource.addObjectSink(this);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.objectSource.networkUpdated(updateContext);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean useLeftMemory = true;
        LiaNodeMemory lm = (LiaNodeMemory)workingMemory.getNodeMemory(this);
        if (lm.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory(this, workingMemory);
        }
        LeftInputAdapterNode.doInsertObject(factHandle, context, this, workingMemory, lm, true, useLeftMemory);
    }

    public static void doInsertObject(InternalFactHandle factHandle, PropagationContext context, LeftInputAdapterNode liaNode, InternalWorkingMemory wm, LiaNodeMemory lm, boolean linkOrNotify, boolean useLeftMemory) {
        SegmentMemory sm = lm.getSegmentMemory();
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        boolean notifySegment = linkOrNotify;
        int counter = lm.getAndIncreaseCounter();
        if (counter == 0) {
            notifySegment = false;
        }
        LeftTupleSink sink = liaNode.getSinkPropagator().getFirstLeftTupleSink();
        LeftTuple leftTuple = sink.createLeftTuple(factHandle, sink, useLeftMemory);
        leftTuple.setPropagationContext(context);
        LeftInputAdapterNode.doInsertSegmentMemory(context, wm, notifySegment, lm, sm, leftTuple, liaNode);
        if (sm.getRootNode() != liaNode) {
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                sink = sm.getSinkFactory();
                leftTuple = sink.createPeer(leftTuple);
                LeftInputAdapterNode.doInsertSegmentMemory(context, wm, notifySegment, lm, sm, leftTuple, liaNode);
            }
        }
        if (counter == 0) {
            if (linkOrNotify) {
                lm.linkNode(wm);
            } else {
                lm.linkNodeWithoutRuleNotify();
            }
        }
        if (context.getReaderContext() != null) {
            MarshallerReaderContext mrc = context.getReaderContext();
            mrc.filter.fireRNEAs(wm);
        }
    }

    private static void doInsertSegmentMemory(PropagationContext pctx, InternalWorkingMemory wm, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm, LeftTuple leftTuple, LeftInputAdapterNode liaNode) {
        boolean stagedInsertWasEmpty = false;
        if (liaNode.isStreamMode() && sm.getStreamQueue() != null) {
            int propagationType = pctx.getType() == 2 ? 0 : pctx.getType();
            stagedInsertWasEmpty = sm.getStreamQueue().addInsert(new LeftTupleEntry(leftTuple, pctx, sm.getNodeMemories().getFirst(), propagationType));
            if (log.isTraceEnabled()) {
                log.trace("LeftInputAdapterNode insert size={}  queue={} pctx={} lt={}", new Object[]{System.identityHashCode(sm.getStreamQueue()), sm.getStreamQueue().size(), PhreakPropagationContext.intEnumToString(pctx), leftTuple});
            }
        } else {
            stagedInsertWasEmpty = sm.getStagedLeftTuples().addInsert(leftTuple);
        }
        if (stagedInsertWasEmpty && linkOrNotify) {
            lm.setNodeDirty(wm);
        }
    }

    public static void doDeleteObject(LeftTuple leftTuple, PropagationContext context, SegmentMemory sm, InternalWorkingMemory wm, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, wm, linkOrNotify);
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null && (leftTuple = leftTuple.getPeer()) != null; sm = sm.getNext()) {
                LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, wm, linkOrNotify);
            }
        }
        if (lm.getAndDecreaseCounter() == 1) {
            if (linkOrNotify) {
                lm.unlinkNode(wm);
            } else {
                lm.unlinkNodeWithoutRuleNotify();
            }
        }
    }

    private static void doDeleteSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, LiaNodeMemory lm, SegmentMemory sm, InternalWorkingMemory wm, boolean linkOrNotify) {
        LeftTupleSets leftTuples = sm.getStagedLeftTuples();
        leftTuple.setPropagationContext(pctx);
        boolean stagedDeleteWasEmpty = false;
        if (((BaseNode)sm.getRootNode()).isStreamMode() && sm.getStreamQueue() != null) {
            int propagationType = pctx.getType() == 2 ? 1 : pctx.getType();
            stagedDeleteWasEmpty = sm.getStreamQueue().addDelete(new LeftTupleEntry(leftTuple, pctx, sm.getNodeMemories().getFirst(), propagationType));
            if (log.isTraceEnabled()) {
                log.trace("LeftInputAdapterNode delete size={}  queue={} pctx={} lt={}", new Object[]{System.identityHashCode(sm.getStreamQueue()), sm.getStreamQueue().size(), PhreakPropagationContext.intEnumToString(pctx), leftTuple});
            }
            LeftInputAdapterNode.registerUnlinkedPaths(wm, sm, stagedDeleteWasEmpty);
        } else {
            stagedDeleteWasEmpty = leftTuples.addDelete(leftTuple);
        }
        if (stagedDeleteWasEmpty && linkOrNotify) {
            lm.setNodeDirty(wm);
        }
    }

    public static void doUpdateObject(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory wm, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        LeftTupleSets leftTuples = sm.getStagedLeftTuples();
        LeftTupleSinkNode sink = liaNode.getSinkPropagator().getFirstLeftTupleSink();
        LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, wm, linkOrNotify, lm, sm, leftTuples, sink);
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                leftTuple = leftTuple.getPeer();
                leftTuples = sm.getStagedLeftTuples();
                LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, wm, linkOrNotify, lm, sm, leftTuples, (LeftTupleSink)sm.getRootNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doUpdateSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, InternalWorkingMemory wm, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm, LeftTupleSets leftTuples, LeftTupleSink sink) {
        Object object = ((SynchronizedLeftTupleSets)leftTuples).getLock();
        synchronized (object) {
            if (leftTuple.getStagedType() == 0) {
                leftTuple.setPropagationContext(pctx);
                boolean stagedUpdateWasEmpty = false;
                stagedUpdateWasEmpty = ((BaseNode)sm.getRootNode()).isStreamMode() && sm.getStreamQueue() != null ? sm.getStreamQueue().addUpdate(new LeftTupleEntry(leftTuple, pctx, sm.getNodeMemories().getFirst(), pctx.getType())) : leftTuples.addUpdate(leftTuple);
                if (stagedUpdateWasEmpty && linkOrNotify) {
                    lm.setNodeDirty(wm);
                }
            }
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LiaNodeMemory lm = (LiaNodeMemory)workingMemory.getNodeMemory(this);
        SegmentMemory smem = lm.getSegmentMemory();
        if (smem.getTipNode() == this) {
            smem = (SegmentMemory)smem.getFirst();
        }
        LeftInputAdapterNode.doDeleteObject(leftTuple, context, smem, workingMemory, this, true, lm);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode.Id otnId = this.sink.getFirstLeftTupleSink().getLeftInputOtnId();
        LeftTuple leftTuple = LeftInputAdapterNode.processDeletesFromModify(modifyPreviousTuples, context, workingMemory, otnId);
        LiaNodeMemory lm = (LiaNodeMemory)workingMemory.getNodeMemory(this);
        if (lm.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory(this, workingMemory);
        }
        if (leftTuple != null && leftTuple.getLeftTupleSink().getLeftInputOtnId().equals(otnId)) {
            modifyPreviousTuples.removeLeftTuple();
            leftTuple.reAdd();
            LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
            long mask = sink.getLeftInferredMask();
            if (BitMaskUtil.intersect(context.getModificationMask(), mask)) {
                LeftInputAdapterNode.doUpdateObject(leftTuple, context, workingMemory, (LeftInputAdapterNode)leftTuple.getLeftTupleSink().getLeftTupleSource(), true, lm, lm.getSegmentMemory());
                if (leftTuple instanceof Activation) {
                    ((Activation)((Object)leftTuple)).setActive(true);
                }
            }
        } else {
            LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
            long mask = sink.getLeftInferredMask();
            if (BitMaskUtil.intersect(context.getModificationMask(), mask)) {
                LeftInputAdapterNode.doInsertObject(factHandle, context, this, workingMemory, lm, true, true);
            }
        }
    }

    private static LeftTuple processDeletesFromModify(ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectTypeNode.Id otnId) {
        LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple();
        while (leftTuple != null && leftTuple.getLeftTupleSink().getLeftInputOtnId().before(otnId)) {
            modifyPreviousTuples.removeLeftTuple();
            LeftInputAdapterNode prevLiaNode = (LeftInputAdapterNode)leftTuple.getLeftTupleSink().getLeftTupleSource();
            LiaNodeMemory prevLm = (LiaNodeMemory)workingMemory.getNodeMemory(prevLiaNode);
            SegmentMemory prevSm = prevLm.getSegmentMemory();
            LeftInputAdapterNode.doDeleteObject(leftTuple, context, prevSm, workingMemory, prevLiaNode, true, prevLm);
            leftTuple = modifyPreviousTuples.peekLeftTuple();
        }
        return leftTuple;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.objectSource.removeObjectSink(this);
        }
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    @Override
    public int hashCode() {
        return this.objectSource.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode)) {
            return false;
        }
        LeftInputAdapterNode other = (LeftInputAdapterNode)object;
        return this.sinkMask == other.sinkMask && this.objectSource.equals(other.objectSource);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.objectSource;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new LiaNodeMemory();
    }

    public static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private boolean leftTupleMemoryEnabled;
        private LeftInputAdapterNode liaNode;

        public RightTupleSinkAdapter(LeftInputAdapterNode liaNode) {
            this.liaNode = liaNode;
        }

        public RightTupleSinkAdapter(LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            this.sink = sink;
            this.leftTupleMemoryEnabled = leftTupleMemoryEnabled;
        }

        @Override
        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
            if (this.liaNode != null) {
                this.liaNode.assertObject(factHandle, context, workingMemory);
            } else {
                LeftTuple tuple = this.sink.createLeftTuple(factHandle, this.sink, this.leftTupleMemoryEnabled);
                this.sink.assertLeftTuple(tuple, context, workingMemory);
            }
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getType() {
            return 120;
        }

        @Override
        public Map<Rule, RuleComponent> getAssociations() {
            return this.sink.getAssociations();
        }
    }

    public static class LiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private int counter;
        private SegmentMemory segmentMemory;
        private long nodePosMaskBit;

        public int getCounter() {
            return this.counter;
        }

        public int getAndIncreaseCounter() {
            return this.counter++;
        }

        public int getAndDecreaseCounter() {
            return this.counter--;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.segmentMemory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentNodes) {
            this.segmentMemory = segmentNodes;
        }

        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        public void setNodePosMaskBit(long nodePosMask) {
            this.nodePosMaskBit = nodePosMask;
        }

        public void linkNodeWithoutRuleNotify() {
            this.segmentMemory.linkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        public void linkNode(InternalWorkingMemory wm) {
            this.segmentMemory.linkNode(this.nodePosMaskBit, wm);
        }

        public void unlinkNode(InternalWorkingMemory wm) {
            this.segmentMemory.unlinkNode(this.nodePosMaskBit, wm);
        }

        public void unlinkNodeWithoutRuleNotify() {
            this.segmentMemory.unlinkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        @Override
        public short getNodeType() {
            return 120;
        }

        public void setNodeDirty(InternalWorkingMemory wm) {
            this.segmentMemory.notifyRuleLinkSegment(wm, this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.counter = 0;
        }
    }
}

