/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQJMSConnectionFactory;
import org.kie.services.client.api.RemoteJmsRuntimeEngineBuilderImpl;
import org.kie.services.client.api.RemoteJmsRuntimeEngineFactory;
import org.kie.services.client.api.RemoteRestRuntimeEngineBuilderImpl;
import org.kie.services.client.api.builder.RemoteJmsRuntimeEngineBuilder;
import org.kie.services.client.api.builder.RemoteRestRuntimeEngineBuilder;
import org.kie.services.client.api.builder.RemoteRuntimeEngineBuilder;
import org.kie.services.client.api.builder.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeEngine;

public abstract class RemoteRuntimeEngineFactory {
    protected RemoteConfiguration config;

    public abstract RemoteRuntimeEngine newRuntimeEngine();

    public static RemoteJmsRuntimeEngineBuilder newJmsBuilder() {
        return new RemoteJmsRuntimeEngineBuilderImpl();
    }

    public static RemoteRestRuntimeEngineBuilder newRestBuilder() {
        return new RemoteRestRuntimeEngineBuilderImpl();
    }

    static void checkAndFinalizeConfig(RemoteConfiguration config, RemoteRuntimeEngineBuilder builder) {
        if (builder instanceof RemoteJmsRuntimeEngineBuilderImpl) {
            RemoteJmsRuntimeEngineBuilderImpl jmsBuilder = (RemoteJmsRuntimeEngineBuilderImpl)builder;
            if (config.getUserName() == null) {
                throw new InsufficientInfoToBuildException("A user name is required to access the JMS queues!");
            }
            if (config.getPassword() == null) {
                throw new InsufficientInfoToBuildException("A password is required to access the JMS queues!");
            }
            if (jmsBuilder.createOwnFactory) {
                HashMap<String, Object> connParams;
                HornetQJMSConnectionFactory createdConnectionFactory = null;
                if (jmsBuilder.hostName == null) {
                    throw new InsufficientInfoToBuildException("A host name or IP address is required to create a JMS ConnectionFactory!");
                }
                if (jmsBuilder.jmsConnectorPort == null) {
                    throw new InsufficientInfoToBuildException("A connector port is required to create a JMS ConnectionFactory!");
                }
                if (config.getUseUssl()) {
                    connParams = new HashMap<String, Object>(7);
                    connParams.put("port", jmsBuilder.jmsConnectorPort);
                    connParams.put("host", jmsBuilder.hostName);
                    jmsBuilder.checkKeyAndTruststoreInfo();
                    connParams.put("ssl-enabled", true);
                    connParams.put("key-store-password", jmsBuilder.keystorePassword);
                    connParams.put("key-store-path", jmsBuilder.keystoreLocation);
                    connParams.put("trust-store-password", jmsBuilder.truststorePassword);
                    connParams.put("trust-store-path", jmsBuilder.truststoreLocation);
                } else {
                    connParams = new HashMap(3);
                    connParams.put("port", jmsBuilder.jmsConnectorPort);
                    connParams.put("host", jmsBuilder.hostName);
                    connParams.put("ssl-enabled", false);
                }
                createdConnectionFactory = new HornetQJMSConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connParams)});
                config.setConnectionFactory((ConnectionFactory)createdConnectionFactory);
            }
            if (jmsBuilder.jbossServerHostName != null && jmsBuilder.remoteInitialContext == null) {
                jmsBuilder.remoteInitialContext = RemoteJmsRuntimeEngineFactory.getRemoteJbossInitialContext(jmsBuilder.jbossServerHostName, config.getUserName(), config.getPassword());
            }
            if (jmsBuilder.remoteInitialContext != null) {
                config.setRemoteInitialContext(jmsBuilder.remoteInitialContext);
            } else {
                config.checkValidJmsValues();
            }
        } else if (builder instanceof RemoteRestRuntimeEngineBuilderImpl) {
            if (config.getServerBaseRestUrl() == null) {
                throw new InsufficientInfoToBuildException("A URL is required to build the factory.");
            }
            if (config.getUserName() == null) {
                throw new InsufficientInfoToBuildException("A user name is required to build the factory.");
            }
            if (config.getPassword() == null) {
                throw new InsufficientInfoToBuildException("A password is required to build the factory.");
            }
        }
        if (config.getExtraJaxbClasses() != null && !config.getExtraJaxbClasses().isEmpty() && config.getDeploymentId() == null) {
            throw new InsufficientInfoToBuildException("A deployment id is required if user-defined class instances are being sent.");
        }
    }
}

