/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.remote.client.jaxb.AcceptedClientCommands;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.client.rest.KieRemoteHttpRequest;
import org.kie.remote.client.rest.KieRemoteHttpResponse;
import org.kie.remote.jaxb.gen.AddTaskCommand;
import org.kie.remote.jaxb.gen.AuditCommand;
import org.kie.remote.jaxb.gen.CompleteTaskCommand;
import org.kie.remote.jaxb.gen.CompleteWorkItemCommand;
import org.kie.remote.jaxb.gen.FailTaskCommand;
import org.kie.remote.jaxb.gen.InsertObjectCommand;
import org.kie.remote.jaxb.gen.JaxbStringObjectPair;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.SetGlobalCommand;
import org.kie.remote.jaxb.gen.SignalEventCommand;
import org.kie.remote.jaxb.gen.StartCorrelatedProcessCommand;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.remote.jaxb.gen.TaskCommand;
import org.kie.remote.jaxb.gen.UpdateCommand;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.exception.MissingRequiredInfoException;
import org.kie.services.client.api.command.exception.RemoteApiException;
import org.kie.services.client.api.command.exception.RemoteCommunicationException;
import org.kie.services.client.api.command.exception.RemoteTaskException;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteCommandObject {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteCommandObject.class);
    protected final RemoteConfiguration config;
    protected boolean isTaskService = false;

    AbstractRemoteCommandObject(RemoteConfiguration config) {
        this.config = config;
        if (config.isJms() && config.getResponseQueue() == null) {
            throw new MissingRequiredInfoException("A Response queue is necessary in order to create a Remote JMS Client instance.");
        }
        this.config.initializeJaxbSerializationProvider();
    }

    protected void dispose() {
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    protected Object executeCommand(Command cmd) {
        if (AcceptedClientCommands.isSendObjectParameterCommandClass(cmd.getClass())) {
            ArrayList<Object> extraClassInstanceList = new ArrayList<Object>();
            this.preprocessCommand(cmd, extraClassInstanceList);
            if (!extraClassInstanceList.isEmpty()) {
                HashSet extraJaxbClasses = new HashSet();
                for (Object e : extraClassInstanceList) {
                    Class<?> jaxbClass = e.getClass();
                    if (jaxbClass.isLocalClass() || jaxbClass.isAnonymousClass()) {
                        throw new SerializationException("Only proper classes are allowed as parameters for the remote API: neither local nor anonymous classes are accepted: " + jaxbClass.getName());
                    }
                    extraJaxbClasses.add(jaxbClass);
                }
                if (this.config.addJaxbClasses(extraJaxbClasses)) {
                    for (Class clazz : extraJaxbClasses) {
                        logger.debug("Adding {} to the JAXBContext instance in this client instance.", (Object)clazz.getName());
                    }
                    this.config.initializeJaxbSerializationProvider();
                }
            }
        }
        if (this.config.isRest()) {
            return this.executeRestCommand(cmd);
        }
        return this.executeJmsCommand(cmd);
    }

    void preprocessCommand(Object cmdObj, List<Object> extraClassInstanceList) {
        if (cmdObj instanceof CompleteWorkItemCommand) {
            this.addPossiblyNullObject(((CompleteWorkItemCommand)cmdObj).getResult(), extraClassInstanceList);
        } else if (cmdObj instanceof SignalEventCommand) {
            this.addPossiblyNullObject(((SignalEventCommand)cmdObj).getEvent(), extraClassInstanceList);
        } else if (cmdObj instanceof StartCorrelatedProcessCommand) {
            StartCorrelatedProcessCommand cmd = (StartCorrelatedProcessCommand)cmdObj;
            if (cmd.getData() != null) {
                this.addPossiblyNullObject(cmd.getData().getDatas(), extraClassInstanceList);
            }
            this.addPossiblyNullObject(cmd.getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof StartProcessCommand) {
            StartProcessCommand startProcCmd = (StartProcessCommand)cmdObj;
            if (startProcCmd.getData() != null) {
                this.addPossiblyNullObject(startProcCmd.getData().getDatas(), extraClassInstanceList);
            }
            this.addPossiblyNullObject(((StartProcessCommand)cmdObj).getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof SetGlobalCommand) {
            this.addPossiblyNullObject(((SetGlobalCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof InsertObjectCommand) {
            this.addPossiblyNullObject(((InsertObjectCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof UpdateCommand) {
            this.addPossiblyNullObject(((UpdateCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof AddTaskCommand) {
            this.addPossiblyNullObject(((AddTaskCommand)cmdObj).getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof CompleteTaskCommand) {
            this.addPossiblyNullObject(((CompleteTaskCommand)cmdObj).getData(), extraClassInstanceList);
        } else if (cmdObj instanceof FailTaskCommand) {
            this.addPossiblyNullObject(((FailTaskCommand)cmdObj).getData(), extraClassInstanceList);
        }
    }

    void addPossiblyNullObject(Object inputObject, List<Object> objectList) {
        if (inputObject != null) {
            if (inputObject instanceof List) {
                objectList.addAll((List)inputObject);
            } else if (inputObject instanceof JaxbStringObjectPairArray) {
                for (JaxbStringObjectPair stringObjectPair : ((JaxbStringObjectPairArray)inputObject).getItems()) {
                    objectList.add(stringObjectPair.getValue());
                }
            } else {
                objectList.add(inputObject);
            }
        }
    }

    private JaxbCommandsRequest prepareCommandRequest(Command command) {
        if (this.config.getDeploymentId() == null && !(command instanceof TaskCommand) && !(command instanceof AuditCommand)) {
            throw new MissingRequiredInfoException("A deployment id is required when sending commands involving the KieSession.");
        }
        JaxbCommandsRequest req = command instanceof AuditCommand ? new JaxbCommandsRequest(command) : new JaxbCommandsRequest(this.config.getDeploymentId(), command);
        Long processInstanceId = this.findProcessInstanceId(command);
        if (processInstanceId == null) {
            processInstanceId = this.config.getProcessInstanceId();
        }
        req.setProcessInstanceId(processInstanceId);
        req.setUser(this.config.getUserName());
        req.setVersion("6.2.0.1");
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeJmsCommand(Command command) {
        List<JaxbCommandResponse<?>> responses;
        Queue sendQueue;
        JaxbCommandsRequest req = this.prepareCommandRequest(command);
        String deploymentId = this.config.getDeploymentId();
        ConnectionFactory factory = this.config.getConnectionFactory();
        boolean isTaskCommand = command instanceof TaskCommand;
        if (isTaskCommand) {
            sendQueue = this.config.getTaskQueue();
            if (!this.config.getUseUssl() && !this.config.getDoNotUseSsl()) {
                throw new SecurityException("Task operation requests can only be sent via JMS if SSL is used.");
            }
        } else {
            sendQueue = this.config.getKsessionQueue();
        }
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            JaxbSerializationProvider serializationProvider;
            BytesMessage msg;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUserName(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to setup a JMS connection.", jmse);
            }
            try {
                msg = session.createBytesMessage();
                serializationProvider = this.config.getJaxbSerializationProvider();
                String xmlStr = serializationProvider.serialize((Object)req);
                msg.writeUTF(xmlStr);
                msg.setJMSCorrelationID(corrId);
                msg.setIntProperty("serialization", this.config.getSerializationType());
                Set<Class<?>> extraJaxbClasses = this.config.getExtraJaxbClasses();
                if (!extraJaxbClasses.isEmpty()) {
                    if (deploymentId == null) {
                        throw new MissingRequiredInfoException("Deserialization of parameter classes requires a deployment id, which has not been configured.");
                    }
                    msg.setStringProperty("deploymentId", deploymentId);
                }
                String userName = this.config.getUserName();
                String password = this.config.getPassword();
                if (isTaskCommand) {
                    if (userName == null) {
                        throw new RemoteCommunicationException("A user name is required when sending task operation requests via JMS");
                    }
                    if (password == null) {
                        throw new RemoteCommunicationException("A password is required when sending task operation requests via JMS");
                    }
                    msg.setStringProperty("username", userName);
                    msg.setStringProperty("password", password);
                }
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to create and fill a JMS message.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to deserialze JMS message.", se.getCause());
            }
            try {
                producer.send((Message)msg);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive(this.config.getTimeout() * 1000L);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to receive or retrieve the JMS response.", jmse);
            }
            if (response == null) {
                logger.warn("Response is empty");
                Object jmse = null;
                return jmse;
            }
            assert (response != null) : "Response is empty.";
            try {
                String xmlStr = ((BytesMessage)response).readUTF();
                cmdResponse = (JaxbCommandsResponse)serializationProvider.deserialize(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", se.getCause());
            }
            assert (cmdResponse != null) : "Jaxb Cmd Response was null!";
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
        String version = cmdResponse.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.2.0.1")) {
            logger.info("Response received from server version [{}] while client is version [{}]! This may cause problems.", (Object)version, (Object)"6.2.0.1");
        }
        if ((responses = cmdResponse.getResponses()).size() > 0) {
            JaxbCommandResponse<?> response = responses.get(0);
            if (response instanceof JaxbExceptionResponse) {
                JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)response;
                throw new RemoteApiException(exceptionResponse.getMessage());
            }
            return response.getResult();
        }
        assert (responses.size() == 0) : "There should only be 1 response, not " + responses.size() + ", returned by a command!";
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T executeRestCommand(Command command) {
        JaxbCommandsRequest jaxbRequest = this.prepareCommandRequest(command);
        String deploymentId = this.config.getDeploymentId();
        KieRemoteHttpRequest httpRequest = this.config.createHttpRequest();
        httpRequest = this.config.getExtraJaxbClasses().isEmpty() && (this.isTaskService || command instanceof AuditCommand) ? httpRequest.relativeRequest("/task/execute") : httpRequest.relativeRequest("/runtime/" + deploymentId + "/execute");
        String jaxbRequestString = this.config.getJaxbSerializationProvider().serialize((Object)jaxbRequest);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("Sending {} via POST to {}", (Object)command.getClass().getSimpleName(), (Object)httpRequest.getUri());
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.trace("Serialized JaxbCommandsRequest:\n {}", (Object)jaxbRequestString);
        }
        KieRemoteHttpResponse httpResponse = null;
        try {
            logger.debug("Sending POST request with " + command.getClass().getSimpleName() + " to " + httpRequest.getUri());
            httpRequest.contentType("application/xml").body(jaxbRequestString);
            httpRequest.post();
            httpResponse = httpRequest.response();
        }
        catch (Exception e) {
            httpRequest.disconnect();
            throw new RemoteCommunicationException("Unable to post request: " + e.getMessage(), e);
        }
        JaxbExceptionResponse exceptionResponse = null;
        JaxbCommandsResponse commandResponse = null;
        int responseStatus = httpResponse.code();
        try {
            String content = httpResponse.body();
            if (responseStatus < 300) {
                commandResponse = this.deserializeResponseContent(content, JaxbCommandsResponse.class);
            } else {
                exceptionResponse = this.deserializeResponseContent(content, JaxbExceptionResponse.class);
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve response content from request with status {}: {}", (Object)e.getMessage(), (Object)e);
            throw new RemoteCommunicationException("Unable to retrieve content from response!", e);
        }
        finally {
            httpRequest.disconnect();
        }
        if (commandResponse != null) {
            List<JaxbCommandResponse<?>> responses = commandResponse.getResponses();
            if (responses.size() == 0) {
                return null;
            }
            if (responses.size() != 1) throw new RemoteCommunicationException("Unexpected number of results from " + command.getClass().getSimpleName() + ":" + responses.size() + " results instead of only 1");
            JaxbCommandResponse<?> responseObject = responses.get(0);
            if (!(responseObject instanceof JaxbExceptionResponse)) return (T)responseObject.getResult();
            exceptionResponse = (JaxbExceptionResponse)responseObject;
        }
        logger.error("Response with status {} returned.", (Object)responseStatus);
        switch (responseStatus) {
            case 409: {
                throw new RemoteTaskException(exceptionResponse.getMessage() + ":\n" + exceptionResponse.getStackTrace());
            }
        }
        if (exceptionResponse == null) throw new RemoteCommunicationException("Unable to communicate with remote API via URL '" + httpRequest.getUri().toString() + "'");
        throw new RemoteApiException(exceptionResponse.getMessage() + ":\n" + exceptionResponse.getStackTrace());
    }

    private <T> T deserializeResponseContent(String responseBody, Class<T> entityClass) {
        JaxbSerializationProvider jaxbSerializationProvider = this.config.getJaxbSerializationProvider();
        Object responseEntity = null;
        try {
            responseEntity = jaxbSerializationProvider.deserialize(responseBody);
        }
        catch (ClassCastException cce) {
            throw new RemoteApiException("Unexpected entity in response body, expected " + entityClass.getName() + " instance.", cce);
        }
        return (T)responseEntity;
    }

    private Long findProcessInstanceId(Object command) {
        if (command instanceof AuditCommand) {
            return null;
        }
        try {
            Field[] fields;
            for (Field field : fields = command.getClass().getDeclaredFields()) {
                String elementName;
                String attributeName;
                field.setAccessible(true);
                if (!(field.isAnnotationPresent(XmlAttribute.class) ? "process-instance-id".equalsIgnoreCase(attributeName = field.getAnnotation(XmlAttribute.class).name()) : (field.isAnnotationPresent(XmlElement.class) ? "process-instance-id".equalsIgnoreCase(elementName = field.getAnnotation(XmlElement.class).name()) : field.getName().equals("processInstanceId")))) continue;
                return (Long)field.get(command);
            }
        }
        catch (Exception e) {
            logger.debug("Unable to find process instance id on command {} due to {}", command, (Object)e.getMessage());
        }
        return null;
    }

    protected static <T> T getField(String fieldName, Class objClass, Object obj, Class<T> fieldClass) throws Exception {
        Field field = objClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public static <T> T unsupported(Class<?> realClass, Class<T> returnClass) {
        String methodName = new Throwable().getStackTrace()[1].getMethodName();
        throw new UnsupportedOperationException("The " + realClass.getSimpleName() + "." + methodName + "(..) method is not supported on the Remote Client instance.");
    }
}

