/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.jaxb;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.remote.client.jaxb.ConversionUtil;
import org.kie.remote.jaxb.gen.Content;
import org.kie.remote.jaxb.gen.I18NText;
import org.kie.remote.jaxb.gen.OrganizationalEntity;
import org.kie.remote.jaxb.gen.Task;
import org.kie.remote.jaxb.gen.Type;
import org.kie.services.client.api.command.AbstractRemoteCommandObject;

abstract class JaxbWrapper {
    private final Class representingClass;

    public JaxbWrapper(Class repClass) {
        this.representingClass = repClass;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractRemoteCommandObject.unsupported(this.representingClass, Void.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractRemoteCommandObject.unsupported(this.representingClass, Void.class);
    }

    protected static List<org.kie.api.task.model.OrganizationalEntity> convertGenOrgEngListToOrgEntList(List<OrganizationalEntity> genOrgEntList) {
        ArrayList<org.kie.api.task.model.OrganizationalEntity> orgEntList = new ArrayList<org.kie.api.task.model.OrganizationalEntity>();
        if (genOrgEntList == null || genOrgEntList.isEmpty()) {
            return orgEntList;
        }
        for (OrganizationalEntity genOrgEnt : genOrgEntList) {
            if (Type.USER.equals((Object)genOrgEnt.getType())) {
                orgEntList.add((org.kie.api.task.model.OrganizationalEntity)new GroupWrapper(genOrgEnt.getId()));
                continue;
            }
            if (Type.GROUP.equals((Object)genOrgEnt.getType())) {
                orgEntList.add((org.kie.api.task.model.OrganizationalEntity)new UserWrapper(genOrgEnt.getId()));
                continue;
            }
            throw new IllegalStateException("Unknown organizational entity type: " + genOrgEnt.getType().toString());
        }
        return orgEntList;
    }

    protected static List<org.kie.api.task.model.I18NText> convertGenI18NTextToI18NText(List<I18NText> jaxbTextList) {
        ArrayList<org.kie.api.task.model.I18NText> textList = new ArrayList<org.kie.api.task.model.I18NText>();
        if (jaxbTextList == null || jaxbTextList.isEmpty()) {
            return textList;
        }
        for (I18NText jaxbText : jaxbTextList) {
            textList.add(new JaxbI18NTextWrapper(jaxbText));
        }
        return textList;
    }

    protected static User convertStringIdToUser(String userId) {
        if (userId == null) {
            return null;
        }
        return new UserWrapper(userId);
    }

    static class UserWrapper
    extends JaxbWrapper
    implements User {
        private final String id;

        public UserWrapper(String id) {
            super(User.class);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    static class GroupWrapper
    extends JaxbWrapper
    implements Group {
        private final String id;

        public GroupWrapper(String id) {
            super(Group.class);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    static class JaxbPeopleAssignmentsWrapper
    extends JaxbWrapper
    implements PeopleAssignments {
        private final org.kie.remote.jaxb.gen.PeopleAssignments peopleAssignments;

        public JaxbPeopleAssignmentsWrapper(org.kie.remote.jaxb.gen.PeopleAssignments peopAssign) {
            super(PeopleAssignments.class);
            this.peopleAssignments = peopAssign;
        }

        public User getTaskInitiator() {
            return JaxbPeopleAssignmentsWrapper.convertStringIdToUser(this.peopleAssignments.getTaskInitiatorId());
        }

        public List<org.kie.api.task.model.OrganizationalEntity> getPotentialOwners() {
            return JaxbPeopleAssignmentsWrapper.convertGenOrgEngListToOrgEntList(this.peopleAssignments.getPotentialOwners());
        }

        public List<org.kie.api.task.model.OrganizationalEntity> getBusinessAdministrators() {
            return JaxbPeopleAssignmentsWrapper.convertGenOrgEngListToOrgEntList(this.peopleAssignments.getBusinessAdministrators());
        }

        public org.kie.remote.jaxb.gen.PeopleAssignments getInternalPeopleAssignments() {
            return this.peopleAssignments;
        }
    }

    static class JaxbI18NTextWrapper
    extends JaxbWrapper
    implements org.kie.api.task.model.I18NText {
        private final I18NText i18nText;

        public JaxbI18NTextWrapper(I18NText text) {
            super(org.kie.api.task.model.I18NText.class);
            this.i18nText = text;
        }

        public Long getId() {
            return this.i18nText.getId();
        }

        public String getLanguage() {
            return this.i18nText.getLanguage();
        }

        public String getText() {
            return this.i18nText.getText();
        }

        public I18NText getInternalI18nText() {
            return this.i18nText;
        }
    }

    static class JaxbContentWrapper
    extends JaxbWrapper
    implements org.kie.api.task.model.Content {
        private final Content content;

        public JaxbContentWrapper(Content content) {
            super(org.kie.api.task.model.Content.class);
            this.content = content;
        }

        public long getId() {
            return this.content.getId();
        }

        public byte[] getContent() {
            return this.content.getContent();
        }

        public Content getInternalContent() {
            return this.content;
        }
    }

    static class JaxbCommentWrapper
    extends JaxbWrapper
    implements Comment {
        private final org.kie.remote.jaxb.gen.Comment comment;

        public JaxbCommentWrapper(org.kie.remote.jaxb.gen.Comment jaxbComment) {
            super(Comment.class);
            this.comment = jaxbComment;
        }

        public Long getId() {
            return this.comment.getId();
        }

        public String getText() {
            return this.comment.getText();
        }

        public Date getAddedAt() {
            return ConversionUtil.convertXmlGregCalToDate(this.comment.getAddedAt());
        }

        public User getAddedBy() {
            return JaxbCommentWrapper.convertStringIdToUser(this.comment.getAddedBy());
        }

        public org.kie.remote.jaxb.gen.Comment getInternalComment() {
            return this.comment;
        }
    }

    static class JaxbAttachmentWrapper
    extends JaxbWrapper
    implements Attachment {
        private final org.kie.remote.jaxb.gen.Attachment attachment;

        public JaxbAttachmentWrapper(org.kie.remote.jaxb.gen.Attachment jaxbAttachment) {
            super(Attachment.class);
            this.attachment = jaxbAttachment;
        }

        public Long getId() {
            return this.attachment.getId();
        }

        public String getName() {
            return this.attachment.getName();
        }

        public String getContentType() {
            return this.attachment.getContentType();
        }

        public Date getAttachedAt() {
            return ConversionUtil.convertXmlGregCalToDate(this.attachment.getAttachedAt());
        }

        public User getAttachedBy() {
            return JaxbAttachmentWrapper.convertStringIdToUser(this.attachment.getAttachedBy());
        }

        public int getSize() {
            return this.attachment.getSize();
        }

        public long getAttachmentContentId() {
            return this.attachment.getAttachmentContentId();
        }

        public org.kie.remote.jaxb.gen.Attachment getInternalAttachment() {
            return this.attachment;
        }
    }

    static class JaxbTaskDataWrapper
    extends JaxbWrapper
    implements TaskData {
        private final org.kie.remote.jaxb.gen.TaskData taskData;

        JaxbTaskDataWrapper(org.kie.remote.jaxb.gen.TaskData genTaskData) {
            super(TaskData.class);
            this.taskData = genTaskData;
        }

        public Status getStatus() {
            return this.taskData.getStatus();
        }

        public Status getPreviousStatus() {
            return this.taskData.getPreviousStatus();
        }

        public User getActualOwner() {
            return JaxbTaskDataWrapper.convertStringIdToUser(this.taskData.getActualOwner());
        }

        public User getCreatedBy() {
            return JaxbTaskDataWrapper.convertStringIdToUser(this.taskData.getCreatedBy());
        }

        public Date getCreatedOn() {
            return ConversionUtil.convertXmlGregCalToDate(this.taskData.getCreatedOn());
        }

        public Date getActivationTime() {
            return ConversionUtil.convertXmlGregCalToDate(this.taskData.getActivationTime());
        }

        public Date getExpirationTime() {
            return ConversionUtil.convertXmlGregCalToDate(this.taskData.getExpirationTime());
        }

        public boolean isSkipable() {
            return this.taskData.isSkipable();
        }

        public long getWorkItemId() {
            return this.taskData.getWorkItemId();
        }

        public long getProcessInstanceId() {
            return this.taskData.getProcessInstanceId();
        }

        public String getProcessId() {
            return this.taskData.getProcessId();
        }

        public String getDeploymentId() {
            return this.taskData.getDeploymentId();
        }

        public int getProcessSessionId() {
            return this.taskData.getProcessSessionId();
        }

        public String getDocumentType() {
            return this.taskData.getDocumentType();
        }

        public long getDocumentContentId() {
            return this.taskData.getDocumentContentId();
        }

        public String getOutputType() {
            return this.taskData.getOutputType();
        }

        public long getOutputContentId() {
            return this.taskData.getOutputContentId();
        }

        public String getFaultName() {
            return this.taskData.getFaultName();
        }

        public String getFaultType() {
            return this.taskData.getFaultType();
        }

        public long getFaultContentId() {
            return this.taskData.getFaultContentId();
        }

        public List<Comment> getComments() {
            ArrayList<Comment> commentList = new ArrayList<Comment>();
            if (this.taskData.getComments() == null || this.taskData.getComments().isEmpty()) {
                return commentList;
            }
            for (org.kie.remote.jaxb.gen.Comment jaxbComment : this.taskData.getComments()) {
                commentList.add(new JaxbCommentWrapper(jaxbComment));
            }
            return commentList;
        }

        public List<Attachment> getAttachments() {
            ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
            if (this.taskData.getAttachments() == null || this.taskData.getAttachments().isEmpty()) {
                return attachmentList;
            }
            for (org.kie.remote.jaxb.gen.Attachment jaxbAttachment : this.taskData.getAttachments()) {
                attachmentList.add(new JaxbAttachmentWrapper(jaxbAttachment));
            }
            return attachmentList;
        }

        public long getParentId() {
            return this.taskData.getParentId();
        }

        public org.kie.remote.jaxb.gen.TaskData getInternalTaskData() {
            return this.taskData;
        }
    }

    static class JaxbTaskWrapper
    extends JaxbWrapper
    implements org.kie.api.task.model.Task {
        private final Task task;

        public JaxbTaskWrapper(Task task) {
            super(org.kie.api.task.model.Task.class);
            this.task = task;
        }

        public Long getId() {
            return this.task.getId();
        }

        public int getPriority() {
            return this.task.getPriority();
        }

        public List<org.kie.api.task.model.I18NText> getNames() {
            return JaxbTaskWrapper.convertGenI18NTextToI18NText(this.task.getNames());
        }

        public List<org.kie.api.task.model.I18NText> getSubjects() {
            return JaxbTaskWrapper.convertGenI18NTextToI18NText(this.task.getSubjects());
        }

        public List<org.kie.api.task.model.I18NText> getDescriptions() {
            return JaxbTaskWrapper.convertGenI18NTextToI18NText(this.task.getDescriptions());
        }

        public String getName() {
            return this.task.getName();
        }

        public String getSubject() {
            return this.task.getSubject();
        }

        public String getDescription() {
            return this.task.getDescription();
        }

        public PeopleAssignments getPeopleAssignments() {
            return new JaxbPeopleAssignmentsWrapper(this.task.getPeopleAssignments());
        }

        public TaskData getTaskData() {
            return new JaxbTaskDataWrapper(this.task.getTaskData());
        }

        public String getTaskType() {
            return this.task.getTaskType();
        }

        public Task getInternalTask() {
            return this.task;
        }
    }
}

