/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.entities.RequestInfo;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.Executor;
import org.kie.internal.executor.api.ExecutorStoreService;
import org.kie.internal.executor.api.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorImpl
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorImpl.class);
    private ExecutorStoreService executorStoreService;
    private List<ScheduledFuture<?>> handle = new ArrayList();
    private int threadPoolSize = Integer.parseInt(System.getProperty("org.kie.executor.pool.size", "1"));
    private int retries = Integer.parseInt(System.getProperty("org.kie.executor.retry.count", "3"));
    private int interval = Integer.parseInt(System.getProperty("org.kie.executor.interval", "3"));
    private TimeUnit timeunit = TimeUnit.valueOf(System.getProperty("org.kie.executor.timeunit", "SECONDS"));
    private ScheduledExecutorService scheduler;

    public void setExecutorStoreService(ExecutorStoreService executorStoreService) {
        this.executorStoreService = executorStoreService;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public TimeUnit getTimeunit() {
        return this.timeunit;
    }

    public void setTimeunit(TimeUnit timeunit) {
        this.timeunit = timeunit;
    }

    public void init() {
        if (!"true".equalsIgnoreCase(System.getProperty("org.kie.executor.disabled"))) {
            logger.info("Starting Executor Component ...\n \t - Thread Pool Size: {}\n \t - Interval: {} {} \n \t - Retries per Request: {}\n", new Object[]{this.threadPoolSize, this.interval, this.timeunit.toString(), this.retries});
            this.scheduler = Executors.newScheduledThreadPool(this.threadPoolSize);
            for (int i = 0; i < this.threadPoolSize; ++i) {
                this.handle.add(this.scheduler.scheduleAtFixedRate(this.executorStoreService.buildExecutorRunnable(), 2L, this.interval, this.timeunit));
            }
        }
    }

    public void init(ThreadFactory threadFactory) {
        if (!"true".equalsIgnoreCase(System.getProperty("org.kie.executor.disabled"))) {
            logger.info("Starting Executor Component ...\n \t - Thread Pool Size: {}\n \t - Interval: {} Seconds\n \t - Retries per Request: {}\n", new Object[]{this.threadPoolSize, this.interval, this.retries});
            this.scheduler = Executors.newScheduledThreadPool(this.threadPoolSize, threadFactory);
            for (int i = 0; i < this.threadPoolSize; ++i) {
                this.handle.add(this.scheduler.scheduleAtFixedRate(this.executorStoreService.buildExecutorRunnable(), 2L, this.interval, this.timeunit));
            }
        }
    }

    public void destroy() {
        logger.info(" >>>>> Destroying Executor !!!");
        if (this.handle != null) {
            for (ScheduledFuture<?> h : this.handle) {
                h.cancel(true);
            }
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public Long scheduleRequest(String commandId, CommandContext ctx) {
        return this.scheduleRequest(commandId, new Date(), ctx);
    }

    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        if (ctx == null) {
            throw new IllegalStateException("A Context Must Be Provided! ");
        }
        String businessKey = (String)ctx.getData("businessKey");
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setCommandName(commandId);
        requestInfo.setKey(businessKey);
        requestInfo.setStatus(STATUS.QUEUED);
        requestInfo.setTime(date);
        requestInfo.setMessage("Ready to execute");
        requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
        if (ctx.getData("retries") != null) {
            requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
        } else {
            requestInfo.setRetries(this.retries);
        }
        if (ctx != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(ctx);
                requestInfo.setRequestData(bout.toByteArray());
            }
            catch (IOException e) {
                logger.warn("Error serializing context data", (Throwable)e);
                requestInfo.setRequestData(null);
            }
        }
        this.executorStoreService.persistRequest((org.kie.internal.executor.api.RequestInfo)requestInfo);
        logger.debug("Scheduling request for Command: {} - requestId: {} with {} retries", new Object[]{commandId, requestInfo.getId(), requestInfo.getRetries()});
        return requestInfo.getId();
    }

    public void cancelRequest(Long requestId) {
        logger.debug("Before - Cancelling Request with Id: {}", (Object)requestId);
        this.executorStoreService.removeRequest(requestId);
        logger.debug("After - Cancelling Request with Id: {}", (Object)requestId);
    }
}

