/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.eap.config;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Text;
import java.util.Arrays;
import java.util.List;
import org.jboss.fuse.eap.config.ConfigEditor;
import org.jboss.fuse.eap.config.ConfigSupport;
import org.jboss.fuse.eap.config.LayerConfig;
import org.jboss.fuse.eap.config.WildflyCamelConfigEditor;

public class SwitchyardConfigEditor
implements ConfigEditor {
    @Override
    public void applyStandaloneConfigChange(boolean enable, Document doc) {
        WildflyCamelConfigEditor.updateExtension(enable, doc);
        WildflyCamelConfigEditor.updateSubsystem(enable, doc);
        WildflyCamelConfigEditor.updateHawtIOSystemProperties(enable, doc);
        WildflyCamelConfigEditor.updateHawtIOSecurityDomain(enable, doc);
        SwitchyardConfigEditor.updateExtension(enable, doc);
        SwitchyardConfigEditor.updateLogging(enable, doc);
        SwitchyardConfigEditor.updateSecurityDomain(enable, doc);
        SwitchyardConfigEditor.updateSubsystem(enable, doc);
    }

    @Override
    public void applyDomainConfigChange(boolean enable, Document doc) {
        this.applyStandaloneConfigChange(enable, doc);
        SwitchyardConfigEditor.updateInfinispan(enable, doc);
    }

    public static void updateExtension(boolean enable, Document doc) {
        Element extensions = doc.getRootElement().getChild("extensions");
        ConfigSupport.assertExists(extensions, "Did not find the <extensions> element");
        Element element = ConfigSupport.findElementWithAttributeValue(extensions.getChildren("extension"), "module", "org.switchyard");
        if (enable && element == null) {
            extensions.addNodes(new Text("    "), new Element("extension").addAttribute("module", "org.switchyard"), new Text("\n    "));
        }
        if (!enable && element != null) {
            element.remove();
        }
    }

    public static void updateLogging(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element logging = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:logging:");
            ConfigSupport.assertExists(logging, "Did not find the security subsystem");
            Element logger = ConfigSupport.findElementWithAttributeValue(logging.getChildren("logger"), "category", "org.switchyard");
            if (enable && logger == null) {
                logging.addNodes(new Text("    "), ConfigSupport.createElementFromText("            <logger category=\"org.switchyard\">\n                <level name=\"INFO\"/>\n            </logger>\n"), new Text("\n            "));
            }
            if (!enable && logger != null) {
                logger.remove();
            }
            logger = ConfigSupport.findElementWithAttributeValue(logging.getChildren("logger"), "category", "org.apache.deltaspike.core.api.provider.BeanManagerProvider");
            if (enable && logger == null) {
                logging.addNodes(new Text("    "), ConfigSupport.createElementFromText("            <logger category=\"org.apache.deltaspike.core.api.provider.BeanManagerProvider\">\n                <level name=\"ERROR\"/>\n            </logger>\n"), new Text("\n            "));
            }
            if (enable || logger == null) continue;
            logger.remove();
        }
    }

    public static void updateSecurityDomain(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element security = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:security:");
            ConfigSupport.assertExists(security, "Did not find the security subsystem");
            Element domains = security.getChild("security-domains");
            ConfigSupport.assertExists(domains, "Did not find the <security-domains> element");
            Element domain = ConfigSupport.findElementWithAttributeValue(domains.getChildren("security-domain"), "name", "hawtio-domain");
            if (enable && domain == null) {
                domains.addNodes(new Text("    "), ConfigSupport.createElementFromText("                <security-domain name=\"bpel-console\" cache-type=\"default\">\n                   <authentication>\n                      <login-module code=\"UsersRoles\" flag=\"required\"/>\n                   </authentication>\n                </security-domain>"), new Text("\n            "));
            }
            if (enable || domain == null) continue;
            domain.remove();
        }
    }

    public static void updateSubsystem(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element subsystem = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:switchyard");
            if (enable && subsystem == null) {
                profile.addNodes(new Text("    "), ConfigSupport.loadElementFrom(SwitchyardConfigEditor.class.getResource("switchyard-subsystem.xml")), new Text("\n    "));
            }
            if (enable || subsystem == null) continue;
            subsystem.remove();
        }
    }

    public static void updateInfinispan(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element infinispan = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:infinispan:");
            ConfigSupport.assertExists(infinispan, "Did not find the security subsystem");
            Element container = ConfigSupport.findElementWithAttributeValue(infinispan.getChildren("cache-container"), "name", "switchyard");
            if (enable && container == null) {
                infinispan.addNodes(new Text("    "), ConfigSupport.createElementFromText("                <cache-container name=\"switchyard\" default-cache=\"default\" start=\"EAGER\">\n                    <transport lock-timeout=\"60000\"/>\n                    <replicated-cache name=\"default\" mode=\"SYNC\" batching=\"true\" start=\"EAGER\">\n                        <locking isolation=\"REPEATABLE_READ\"/>\n                    </replicated-cache>\n                </cache-container>\n"), new Text("\n            "));
            }
            if (enable || container == null) continue;
            container.remove();
        }
    }

    @Override
    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(new LayerConfig("fuse", LayerConfig.Type.INSTALLING, -10), new LayerConfig("bpms", LayerConfig.Type.OPTIONAL, -9), new LayerConfig("soa", LayerConfig.Type.INSTALLING, -8));
    }
}

