/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.eap.config;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Text;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.fuse.eap.config.ConfigEditor;
import org.jboss.fuse.eap.config.ConfigSupport;
import org.jboss.fuse.eap.config.LayerConfig;

public class WildflyCamelConfigEditor
implements ConfigEditor {
    @Override
    public void applyStandaloneConfigChange(boolean enable, Document doc) {
        WildflyCamelConfigEditor.updateExtension(enable, doc);
        WildflyCamelConfigEditor.updateSubsystem(enable, doc);
        WildflyCamelConfigEditor.updateWeldConfig(enable, doc);
        WildflyCamelConfigEditor.updateHawtIOSystemProperties(enable, doc);
        WildflyCamelConfigEditor.updateHawtIOSecurityDomain(enable, doc);
    }

    @Override
    public void applyDomainConfigChange(boolean enable, Document doc) {
        this.applyStandaloneConfigChange(enable, doc);
    }

    public static void updateExtension(boolean enable, Document doc) {
        Element extensions = doc.getRootElement().getChild("extensions");
        ConfigSupport.assertExists(extensions, "Did not find the <extensions> element");
        Element element = ConfigSupport.findElementWithAttributeValue(extensions.getChildren("extension"), "module", "org.wildfly.extension.camel");
        if (enable && element == null) {
            extensions.addNodes(new Text("    "), new Element("extension").addAttribute("module", "org.wildfly.extension.camel"), new Text("\n    "));
        }
        if (!enable && element != null) {
            element.remove();
        }
    }

    public static void updateWeldConfig(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element weld = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:weld:");
            ConfigSupport.assertExists(weld, "Did not find the weld subsystem");
            if (enable) {
                weld.setAttribute("require-bean-descriptor", "true");
                continue;
            }
            weld.removeAttribute("require-bean-descriptor");
        }
    }

    public static void updateSubsystem(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element camel = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:camel:");
            if (enable && camel == null) {
                profile.addNodes(new Text("    "), ConfigSupport.loadElementFrom(WildflyCamelConfigEditor.class.getResource("camel-subsystem.xml")), new Text("\n    "));
            }
            if (enable || camel == null) continue;
            camel.remove();
        }
    }

    public static void updateHawtIOSystemProperties(boolean enable, Document doc) {
        Element systemProperties = doc.getRootElement().getChild("system-properties");
        if (systemProperties == null) {
            systemProperties = new Element("system-properties");
            systemProperties.addNode(new Text("\n    "));
            int pos = doc.getRootElement().nodeIndexOf(doc.getRootElement().getChild("extensions"));
            doc.getRootElement().addNodes(pos + 1, new Text("    "), systemProperties, new Text("\n"));
        }
        LinkedHashMap<String, Element> propertiesByName = ConfigSupport.mapByAttributeName(systemProperties.getChildren(), "name");
        if (enable) {
            WildflyCamelConfigEditor.addProperty(systemProperties, propertiesByName, "hawtio.authenticationEnabled", "true");
            WildflyCamelConfigEditor.addProperty(systemProperties, propertiesByName, "hawtio.offline", "true");
            WildflyCamelConfigEditor.addProperty(systemProperties, propertiesByName, "hawtio.realm", "hawtio-domain");
            WildflyCamelConfigEditor.addProperty(systemProperties, propertiesByName, "hawtio.role", "admin");
        } else {
            WildflyCamelConfigEditor.rmProperty(propertiesByName, "hawtio.authenticationEnabled");
            WildflyCamelConfigEditor.rmProperty(propertiesByName, "hawtio.offline");
            WildflyCamelConfigEditor.rmProperty(propertiesByName, "hawtio.realm");
            WildflyCamelConfigEditor.rmProperty(propertiesByName, "hawtio.role");
        }
    }

    protected static void addProperty(Element systemProperties, LinkedHashMap<String, Element> propertiesByName, String name, String value) {
        if (!propertiesByName.containsKey(name)) {
            systemProperties.addNodes(new Text("   "), new Element("property").setAttribute("name", name).setAttribute("value", value), new Text("\n    "));
        }
    }

    protected static void rmProperty(LinkedHashMap<String, Element> propertiesByName, String name) {
        Element element = propertiesByName.get(name);
        if (element != null) {
            element.remove();
        }
    }

    public static void updateHawtIOSecurityDomain(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element security = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:security:");
            ConfigSupport.assertExists(security, "Did not find the security subsystem");
            Element domains = security.getChild("security-domains");
            ConfigSupport.assertExists(domains, "Did not find the <security-domains> element");
            Element hawtioDomain = ConfigSupport.findElementWithAttributeValue(domains.getChildren("security-domain"), "name", "hawtio-domain");
            if (enable && hawtioDomain == null) {
                domains.addNodes(new Text("    "), ConfigSupport.loadElementFrom(WildflyCamelConfigEditor.class.getResource("hawtio-security-domain.xml")), new Text("\n            "));
            }
            if (enable || hawtioDomain == null) continue;
            hawtioDomain.remove();
        }
    }

    @Override
    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(new LayerConfig("fuse", LayerConfig.Type.INSTALLING, -10));
    }
}

