/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.blueprint;

import java.io.InputStream;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.kie.karaf.itest.beans.AbstractProcessWithPersistenceBean;
import org.kie.karaf.itest.beans.ProcessWithPersistenceDirectBean;
import org.kie.karaf.itest.beans.ProcessWithPersistenceEnvBean;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.exam.util.Filter;
import org.ops4j.pax.tinybundles.core.TinyBundles;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class KieBlueprintjBPMPersistenceKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String BLUEPRINT_XML_LOCATION = "/org/kie/karaf/itest/blueprint/processpersistence/kie-beans-blueprint-process-persistence.xml";
    private static final String PERSISTENCE_XML_LOCATION = "/org/kie/karaf/itest/blueprint/processpersistence/persistence.xml";
    private static final String DATASOURCE_XML_LOCATION = "/org/kie/karaf/itest/blueprint/processpersistence/datasource.xml";
    private static final String KMODULE_XML_LOCATION = "/org/kie/karaf/itest/blueprint/processpersistence/kmodule.xml";
    private static final String POM_PROPS_LOCATION = "/META-INF/maven/org.kie/kie-osgi/pom.properties";
    private static final String DRL_LOCATION = "/blueprint_process_persistence/sampleRule.drl";
    private static final String BPMN_LOCATION = "/blueprint_process_persistence/sampleProcess.bpmn2";
    private static final String PROCESS_ID = "orderApproval";
    @Inject
    @Filter(value="(osgi.jndi.service.name=kiesession/sessionWithoutEnv)")
    private KieSession processWithPersistenceNoEnv;
    @Inject
    @Filter(value="(osgi.jndi.service.name=kiesession/sessionWithEnv)")
    private KieSession processWithPersistenceEnv;

    @Test
    public void testStartProcessNoEnv() throws Exception {
        Assert.assertNotNull((Object)this.processWithPersistenceNoEnv);
        ProcessInstance processInstance = this.processWithPersistenceNoEnv.startProcess(PROCESS_ID);
        Assert.assertEquals((String)"Unexpected process instance state.", (long)2L, (long)processInstance.getState());
    }

    @Test
    public void testStartProcessEnv() throws Exception {
        Assert.assertNotNull((Object)this.processWithPersistenceEnv);
        ProcessInstance processInstance = this.processWithPersistenceEnv.startProcess(PROCESS_ID);
        Assert.assertEquals((String)"Unexpected process instance state.", (long)2L, (long)processInstance.getState());
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieBlueprintjBPMPersistenceKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), KieBlueprintjBPMPersistenceKarafIntegrationTest.loadKieFeatures("jndi", "transaction", "droolsjbpm-hibernate", "h2", "jbpm", "kie-aries-blueprint"), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().add("OSGI-INF/blueprint/datasource.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(DATASOURCE_XML_LOCATION)).set("Bundle-SymbolicName", "Test-Blueprint-Datasource-Bundle").set("Import-Package", "javax.transaction,javax.sql,org.apache.commons.dbcp.managed,org.h2").build()).start(), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().add("OSGI-INF/blueprint/kie-beans-blueprint-process-persistence.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(BLUEPRINT_XML_LOCATION)).add("META-INF/persistence.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(PERSISTENCE_XML_LOCATION)).add("META-INF/JBPMorm.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource("/META-INF/JBPMorm.xml")).add("META-INF/Taskorm.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource("/META-INF/Taskorm.xml")).add("META-INF/TaskAuditorm.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource("/META-INF/TaskAuditorm.xml")).add("blueprint_process_persistence/sampleRule.drl", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(DRL_LOCATION)).add("blueprint_process_persistence/sampleProcess.bpmn2", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(BPMN_LOCATION)).add("META-INF/kmodule.xml", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(KMODULE_XML_LOCATION)).add("META-INF/maven/kjar/pom.properties", KieBlueprintjBPMPersistenceKarafIntegrationTest.class.getResource(POM_PROPS_LOCATION)).add(ProcessWithPersistenceDirectBean.class).add(ProcessWithPersistenceEnvBean.class).add(AbstractProcessWithPersistenceBean.class).set("Meta-Persistence", "META-INF/persistence.xml").set("Import-Package", "org.kie.aries.blueprint,org.kie.aries.blueprint.factorybeans,org.kie.aries.blueprint.helpers,org.kie.api,org.kie.api.runtime,org.kie.api.runtime.manager,org.kie.api.runtime.process,org.kie.api.task,org.jbpm.persistence.processinstance,org.jbpm.runtime.manager.impl,org.jbpm.process.instance.impl,org.jbpm.services.task.identity,org.jbpm.services.task.impl.model,org.kie.internal.runtime.manager.context,javax.transaction,javax.persistence,*").set("Bundle-SymbolicName", "Test-Blueprint-Bundle").build()).start()};
    }
}

