/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.PMMLCompilerFactory;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.maven.plugin.DiskResourceStore;

public class BuildMojo
extends AbstractMojo {
    private File outputDirectory;
    private File sourceFolder;
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<ZipKieModule> kmoduleDeps = new ArrayList<ZipKieModule>();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
                KieModuleModel kieModuleModel = this.getDependencyKieModel(file);
                if (kieModuleModel == null) continue;
                ReleaseIdImpl releaseId = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                kmoduleDeps.add(new ZipKieModule((ReleaseId)releaseId, kieModuleModel, file));
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
            BPMN2ProcessFactory.loadProvider((ClassLoader)projectClassLoader);
            DecisionTableFactory.loadProvider((ClassLoader)projectClassLoader);
            ProcessBuilderFactory.loadProvider((ClassLoader)projectClassLoader);
            PMMLCompilerFactory.loadProvider((ClassLoader)projectClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        KieServices ks = KieServices.Factory.get();
        try {
            KieRepository kr = ks.getRepository();
            InternalKieModule kModule = (InternalKieModule)kr.addKieModule(ks.getResources().newFileSystemResource(this.sourceFolder), new Resource[0]);
            for (InternalKieModule internalKieModule : kmoduleDeps) {
                kModule.addKieDependency(internalKieModule);
            }
            KieContainerImpl kContainer = (KieContainerImpl)ks.newKieContainer(kModule.getReleaseId());
            KieProject kieProject = kContainer.getKieProject();
            ResultsImpl messages = kieProject.verify();
            List errors = messages.filterMessages(new Message.Level[]{Message.Level.ERROR});
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            new KieMetaInfoBuilder((ResourceStore)new DiskResourceStore(this.outputDirectory), kModule).writeKieModuleMetaInfo();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModuleModel getDependencyKieModel(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry(KieModuleModelImpl.KMODULE_JAR_PATH);
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

