/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.internal.utils.ChainedProperties;
import org.kie.maven.plugin.AbstractKieMojo;

@Mojo(name="validateDMN", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ValidateDMNMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.resources}")
    private List<Resource> resources;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="validateDMN", defaultValue="VALIDATE_SCHEMA,VALIDATE_MODEL")
    private String validateDMN;
    private List<DMNValidator.Validation> actualFlags = new ArrayList<DMNValidator.Validation>();
    private List<Path> resourcesPaths;
    private DMNValidator validator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Path> dmnModelPaths;
        this.actualFlags.addAll(this.computeFlagsFromCSVString(this.validateDMN));
        this.actualFlags.retainAll(Arrays.asList(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL));
        if (this.actualFlags.isEmpty()) {
            this.getLog().info((CharSequence)"No VALIDATE_SCHEMA or VALIDATE_MODEL flags set, skipping.");
            return;
        }
        this.resourcesPaths = this.resources.stream().map(r -> new File(r.getDirectory()).toPath()).collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("resourcesPaths: " + this.resourcesPaths.stream().map(Path::toString).collect(Collectors.joining(",\n"))));
        }
        if ((dmnModelPaths = this.computeDmnModelPaths()).isEmpty()) {
            this.getLog().info((CharSequence)"No DMN Models found.");
            return;
        }
        this.getLog().info((CharSequence)"Initializing DMNValidator...");
        this.initializeDMNValidator();
        this.getLog().info((CharSequence)"DMNValidator initialized.");
        dmnModelPaths.forEach(x -> this.getLog().info((CharSequence)("Will validate DMN model: " + x.toString())));
        List validation = this.validator.validateUsing(this.actualFlags.toArray(new DMNValidator.Validation[0])).theseModels(dmnModelPaths.stream().map(Path::toFile).collect(Collectors.toList()).toArray(new File[0]));
        this.logValidationMessages(validation);
        if (validation.stream().anyMatch(m -> m.getLevel() == Message.Level.ERROR)) {
            throw new MojoFailureException("There are DMN Validation Error(s).");
        }
    }

    private void logValidationMessages(List<DMNMessage> validation) {
        for (DMNMessage msg : validation) {
            Consumer<CharSequence> logFn = null;
            switch (msg.getLevel()) {
                case ERROR: {
                    logFn = arg_0 -> ((Log)this.getLog()).error(arg_0);
                    break;
                }
                case WARNING: {
                    logFn = arg_0 -> ((Log)this.getLog()).warn(arg_0);
                    break;
                }
                default: {
                    logFn = arg_0 -> ((Log)this.getLog()).info(arg_0);
                }
            }
            StringBuilder sb = new StringBuilder();
            if (msg.getSourceReference() instanceof DMNModelInstrumentedBase) {
                DMNModelInstrumentedBase ib = (DMNModelInstrumentedBase)msg.getSourceReference();
                while (ib.getParent() != null) {
                    ib = ib.getParent();
                }
                if (ib instanceof Definitions) {
                    sb.append(((Definitions)ib).getName() + ": ");
                }
            }
            sb.append(msg.getText());
            logFn.accept(sb.toString());
        }
    }

    public List<DMNValidator.Validation> computeFlagsFromCSVString(String csvString) {
        ArrayList<DMNValidator.Validation> flags = new ArrayList<DMNValidator.Validation>();
        boolean resetFlag = false;
        for (String p : csvString.split(",")) {
            try {
                flags.add(DMNValidator.Validation.valueOf((String)p));
            }
            catch (IllegalArgumentException e) {
                this.getLog().info((CharSequence)("validateDMN configured with flag: '" + p + "' determines this Mojo will not be executed (reset all flags)."));
                resetFlag = true;
            }
        }
        if (resetFlag) {
            flags.clear();
        }
        return flags;
    }

    private List<Path> computeDmnModelPaths() throws MojoExecutionException {
        ArrayList<Path> dmnModelPaths = new ArrayList<Path>();
        for (Path p : this.resourcesPaths) {
            this.getLog().info((CharSequence)("Looking for DMN models in path: " + p));
            try {
                Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    walk.filter(f -> f.toString().endsWith(".dmn")).forEach(dmnModelPaths::add);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (walk == null) continue;
                    if (throwable != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    walk.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed executing ValidateDMNMojo", e);
            }
        }
        return dmnModelPaths;
    }

    private void initializeDMNValidator() throws MojoExecutionException {
        ClassLoader classLoader = ClassLoaderUtil.findDefaultClassLoader();
        ChainedProperties chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)classLoader);
        ArrayList<KieModuleModel> kieModules = new ArrayList<KieModuleModel>();
        for (Path p : this.resourcesPaths) {
            try {
                Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    List collect = walk.filter(f -> f.toString().endsWith("kmodule.xml")).collect(Collectors.toList());
                    for (Path k : collect) {
                        kieModules.add(KieModuleModelImpl.fromXML((File)k.toFile()));
                    }
                }
                catch (Throwable collect) {
                    throwable = collect;
                    throw collect;
                }
                finally {
                    if (walk == null) continue;
                    if (throwable != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable collect) {
                            throwable.addSuppressed(collect);
                        }
                        continue;
                    }
                    walk.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed executing ValidateDMNMojo", e);
            }
        }
        for (KieModuleModel kmm : kieModules) {
            Properties ps = new Properties();
            ps.putAll((Map<?, ?>)kmm.getConfigurationProperties());
            chainedProperties.addProperties(ps);
        }
        ArrayList<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
        dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)chainedProperties));
        try {
            HashMap dmnProfileProperties = new HashMap();
            chainedProperties.mapStartsWith(dmnProfileProperties, "org.kie.dmn.profiles.", false);
            for (Map.Entry dmnProfileProperty : dmnProfileProperties.entrySet()) {
                DMNProfile dmnProfile = (DMNProfile)classLoader.loadClass((String)dmnProfileProperty.getValue()).newInstance();
                dmnProfiles.add(dmnProfile);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Failed DMNValidator initialization.", (Exception)e);
        }
        this.validator = DMNValidatorFactory.newValidator(dmnProfiles);
    }
}

