/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.maven.plugin.AbstractDMNValidationAwareMojo;

@Mojo(name="validateDMN", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ValidateDMNMojo
extends AbstractDMNValidationAwareMojo {
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    private List<DMNValidator.Validation> actualFlags = new ArrayList<DMNValidator.Validation>();
    private DMNValidator validator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.actualFlags.addAll(this.computeFlagsFromCSVString(this.getValidateDMN()));
        this.actualFlags.retainAll(Arrays.asList(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL));
        if (this.actualFlags.isEmpty()) {
            this.getLog().info((CharSequence)"No VALIDATE_SCHEMA or VALIDATE_MODEL flags set, skipping.");
            return;
        }
        List<Path> dmnModelPaths = this.computeDmnModelPaths();
        if (dmnModelPaths.isEmpty()) {
            this.getLog().info((CharSequence)"No DMN Models found.");
            return;
        }
        this.getLog().info((CharSequence)"Initializing DMNValidator...");
        this.initializeDMNValidator();
        this.getLog().info((CharSequence)"DMNValidator initialized.");
        dmnModelPaths.forEach(x -> this.getLog().info((CharSequence)("Will validate DMN model: " + x.toString())));
        List validation = this.validator.validateUsing(this.actualFlags.toArray(new DMNValidator.Validation[0])).theseModels(dmnModelPaths.stream().map(Path::toFile).collect(Collectors.toList()).toArray(new File[0]));
        this.logValidationMessages(validation, this::validateMsgPrefixer, Message::getText);
        if (validation.stream().anyMatch(m -> m.getLevel() == Message.Level.ERROR)) {
            throw new MojoFailureException("There are DMN Validation Error(s).");
        }
    }

    private String validateMsgPrefixer(DMNMessage msg) {
        if (msg.getSourceReference() instanceof DMNModelInstrumentedBase) {
            DMNModelInstrumentedBase ib = (DMNModelInstrumentedBase)msg.getSourceReference();
            while (ib.getParent() != null) {
                ib = ib.getParent();
            }
            if (ib instanceof Definitions) {
                return ((Definitions)ib).getName() + ": ";
            }
        }
        return "";
    }

    private List<Path> computeDmnModelPaths() throws MojoExecutionException {
        ArrayList<Path> dmnModelPaths = new ArrayList<Path>();
        for (Path p : this.resourcesPaths()) {
            this.getLog().info((CharSequence)("Looking for DMN models in path: " + p));
            try {
                Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    walk.filter(f -> f.toString().endsWith(".dmn")).forEach(dmnModelPaths::add);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (walk == null) continue;
                    if (throwable != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    walk.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed executing ValidateDMNMojo", e);
            }
        }
        return dmnModelPaths;
    }

    private void initializeDMNValidator() throws MojoExecutionException {
        List<DMNProfile> dmnProfiles = this.computeDMNProfiles();
        this.validator = DMNValidatorFactory.newValidator(dmnProfiles);
    }
}

