/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.kie.api.builder.ReleaseId;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;

public class ProjectPomModel
implements PomModel {
    private final ReleaseId releaseId;
    private final ReleaseId parentReleaseId;
    private final Map<String, Set<ReleaseId>> dependenciesByScope;

    public ProjectPomModel(MavenSession mavenSession) {
        this.releaseId = this.getReleaseIdFromMavenProject(mavenSession.getCurrentProject());
        MavenProject parentProject = mavenSession.getCurrentProject().getParent();
        this.parentReleaseId = parentProject != null ? this.getReleaseIdFromMavenProject(parentProject) : null;
        this.dependenciesByScope = this.getDirectDependenciesFromMavenSession(mavenSession);
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public ReleaseId getParentReleaseId() {
        return this.parentReleaseId;
    }

    public Collection<ReleaseId> getDependencies() {
        return this.dependenciesByScope.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<ReleaseId> getDependencies(DependencyFilter filter) {
        HashSet<ReleaseId> filteredDependencies = new HashSet<ReleaseId>();
        for (Map.Entry<String, Set<ReleaseId>> entry : this.dependenciesByScope.entrySet()) {
            for (ReleaseId dependencyReleaseId : entry.getValue()) {
                if (!filter.accept(dependencyReleaseId, entry.getKey())) continue;
                filteredDependencies.add(dependencyReleaseId);
            }
        }
        return filteredDependencies;
    }

    private ReleaseId getReleaseIdFromMavenProject(MavenProject mavenProject) {
        return new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion(), mavenProject.getPackaging());
    }

    private ReleaseId getReleaseIdFromDependency(Dependency dependency) {
        return new ReleaseIdImpl(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType());
    }

    private Map<String, Set<ReleaseId>> getDirectDependenciesFromMavenSession(MavenSession mavenSession) {
        List dependencies = mavenSession.getCurrentProject().getDependencies();
        HashMap<String, Set<ReleaseId>> result = new HashMap<String, Set<ReleaseId>>();
        for (Dependency dependency : dependencies) {
            Set scopeDependencies = result.computeIfAbsent(dependency.getScope(), s -> new HashSet());
            scopeDependencies.add(this.getReleaseIdFromDependency(dependency));
        }
        return result;
    }
}

