/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.drools.ancompiler.CompiledNetworkSources;
import org.drools.ancompiler.ObjectTypeNodeCompiler;
import org.drools.core.reteoo.Rete;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.CanonicalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.helpers.ExecutorHelper;
import org.kie.maven.plugin.helpers.GenerateCodeHelper;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.util.maven.support.ReleaseIdImpl;

public class GenerateANCExecutor {
    private GenerateANCExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateANC(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException {
        MavenProject project = kieMavenPluginContext.getProject();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        Map<String, String> properties = kieMavenPluginContext.getProperties();
        File targetDirectory = kieMavenPluginContext.getTargetDirectory();
        String dumpKieSourcesFolder = kieMavenPluginContext.getDumpKieSourcesFolder();
        JavaConfiguration.CompilerType compilerType = kieMavenPluginContext.getCompilerType();
        Log log = kieMavenPluginContext.getLog();
        JavaCompilerSettings javaCompilerSettings = GenerateCodeHelper.createJavaCompilerSettings(project);
        URLClassLoader projectClassLoader = GenerateCodeHelper.getProjectClassLoader(project, outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            ExecutorHelper.setSystemProperties(properties, log);
            KieServices ks = KieServices.Factory.get();
            KieContainer kieContainer = ks.newKieContainer((ReleaseId)new ReleaseIdImpl(project.getGroupId(), project.getArtifactId(), project.getVersion()));
            HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
            for (String kbase : kieContainer.getKieBaseNames()) {
                InternalKnowledgeBase kieBase = (InternalKnowledgeBase)kieContainer.getKieBase(kbase);
                List ancSourceFiles = ObjectTypeNodeCompiler.compiledNetworkSources((Rete)kieBase.getRete());
                log.info((CharSequence)String.format("Found %d generated files in Knowledge Base %s", ancSourceFiles.size(), kbase));
                for (CompiledNetworkSources generatedFile : ancSourceFiles) {
                    String className = GenerateCodeHelper.toClassName(generatedFile.getSourceName());
                    classNameSourceMap.put(className, generatedFile.getSource());
                    log.info((CharSequence)("Generated Alpha Network class: " + className));
                }
            }
            GenerateCodeHelper.compileAndWriteClasses(targetDirectory, projectClassLoader, javaCompilerSettings, compilerType, classNameSourceMap, dumpKieSourcesFolder);
            String ancFile = CanonicalKieModule.getANCFile((ReleaseId)new ReleaseIdImpl(project.getGroupId(), project.getArtifactId(), project.getVersion()));
            Path ancFilePath = Paths.get(targetDirectory.getPath(), "classes", ancFile);
            try {
                Files.deleteIfExists(ancFilePath);
                Files.createDirectories(ancFilePath.getParent(), new FileAttribute[0]);
                Files.createFile(ancFilePath, new FileAttribute[0]);
                log.info((CharSequence)("Written ANC File: " + ancFilePath.toAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write file: ", (Exception)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                }
            }
        }
        log.info((CharSequence)"Compiled Alpha Network successfully generated");
    }
}

