/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Collections;
import java.util.Map;
import javax.tools.ToolProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ToolProvider.class})
@PowerMockIgnore(value={"jdk.internal.reflect.*"})
public class SystemJavaCompilerFailureTest {
    private static final String EXAMPLE_CLASS = "package org.kie.memorycompiler;\n\npublic class ExampleClass {\n\n    public int sum(Integer a, Integer b){\n        return a + b;\n    }\n}";

    @Test(expected=KieMemoryCompilerException.class)
    public void simulateJRE() throws Exception {
        PowerMockito.mockStatic(ToolProvider.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ToolProvider.getSystemJavaCompiler()).thenReturn(null);
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.ExampleClass", EXAMPLE_CLASS);
        KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
    }
}

