/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class KieMemoryCompilerTest {
    private static final String EXAMPLE_CLASS = "package org.kie.memorycompiler;\n\npublic class ExampleClass {\n\n    public int sum(Integer a, Integer b){\n        return a + b;\n    }\n}";
    private static final String WARNING_CLASS = "package org.kie.memorycompiler;\n\nimport java.util.List;\n\npublic class WarningClass {\n\n    private List<String> warningField;\n\n    public void setWarningField(Object warningField) {\n        this.warningField = (List<String>) warningField;\n    }\n\n    public int minus(Integer a, Integer b) {\n        return a - b;\n    }\n\n};\n";
    private static final String EXAMPLE_INNER_CLASS = "package org.kie.memorycompiler;\n\npublic class ExampleClass {\n\n    public int sum(Integer a, Integer b){\n        return a + b;\n    }\n\n    public static class InnerClass { }\n}";

    @Test
    public void compileAndLoadClass() throws Exception {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.ExampleClass", EXAMPLE_CLASS);
        Map compiled = KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
        Class exampleClazz = (Class)compiled.get("org.kie.memorycompiler.ExampleClass");
        Assertions.assertThat((Class)exampleClazz).isNotNull();
        Object instance = exampleClazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
        Method sumMethod = exampleClazz.getMethod("sum", Integer.class, Integer.class);
        Object result = sumMethod.invoke(instance, 2, 3);
        Assertions.assertThat((Object)result).isEqualTo((Object)5);
    }

    @Test(expected=KieMemoryCompilerException.class)
    public void invalidClass() {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.InvalidJavaClass", "Invalid Java Code");
        KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
    }

    @Test
    public void doNotFailOnWarning() throws Exception {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.WarningClass", WARNING_CLASS);
        Map compiled = KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
        Class exampleClazz = (Class)compiled.get("org.kie.memorycompiler.WarningClass");
        Assertions.assertThat((Class)exampleClazz).isNotNull();
        Object instance = exampleClazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
        Method minusMethod = exampleClazz.getMethod("minus", Integer.class, Integer.class);
        Object result = minusMethod.invoke(instance, 8, 4);
        Assertions.assertThat((Object)result).isEqualTo((Object)4);
    }

    @Test
    public void compileInnerClass() throws Exception {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.ExampleClass", EXAMPLE_INNER_CLASS);
        Map compiled = KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)2L, (long)compiled.size());
        Assert.assertNotNull(compiled.get("org.kie.memorycompiler.ExampleClass"));
        Assert.assertNotNull(compiled.get("org.kie.memorycompiler.ExampleClass$InnerClass"));
    }
}

