/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenRuntime;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;

public class BuildPMMLTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String PROJECT_NAME = "kjar-6-with-pmml";
    private static final String GAV_GROUP_ID = "org.kie";
    private static final String GAV_ARTIFACT_ID = "kie-maven-plugin-test-kjar-6";
    private static final String GAV_VERSION = "1.0.0.Final";
    private static final String KIE_SESSION_NAME = "PMML.session";
    private static final String KIE_PACKAGE_WITH_PMML = "org.kie.scorecards.example.SampleScore";
    private static final String PMML_FILE_NAME = "PMMLResources/simple-pmml.pmml";
    private static final String EXAMPLE_PMML_CLASS = "org/kie/scorecards/example/SampleScore/OverallScore.class";

    public BuildPMMLTest(MavenRuntime.MavenRuntimeBuilder builder) throws Exception {
        super(builder);
    }

    @Test
    public void testCleanInstallWithPMML() throws Exception {
        File basedir = this.resources.getBasedir(PROJECT_NAME);
        MavenExecutionResult result = this.mavenRuntime.forProject(basedir).execute(new String[]{"clean", "install"});
        result.assertErrorFreeLog();
    }

    @Test
    public void testUseBuildKjarWithPMML() throws Exception {
        File basedir = this.resources.getBasedir(PROJECT_NAME);
        MavenExecutionResult result = this.mavenRuntime.forProject(basedir).execute(new String[]{"clean", "install"});
        result.assertErrorFreeLog();
        KieServices kieServices = KieServices.Factory.get();
        ReleaseId releaseId = kieServices.newReleaseId(GAV_GROUP_ID, GAV_ARTIFACT_ID, GAV_VERSION);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        Assertions.assertThat((Object)kieContainer).isNotNull();
        KieSession kieSession = kieContainer.newKieSession(KIE_SESSION_NAME);
        Assertions.assertThat((Object)kieSession).isNotNull();
        KieBase kieBase = kieSession.getKieBase();
        Assertions.assertThat((Object)kieBase).isNotNull();
        KiePackage kiePackageWithPMML = kieBase.getKiePackage(KIE_PACKAGE_WITH_PMML);
        Assertions.assertThat((Object)kiePackageWithPMML).isNotNull();
        Assertions.assertThat((Iterable)kiePackageWithPMML.getRules()).isNotEmpty();
        kieSession.dispose();
    }

    @Test
    public void testContentKjarWithPMML() throws Exception {
        File basedir = this.resources.getBasedir(PROJECT_NAME);
        MavenExecutionResult result = this.mavenRuntime.forProject(basedir).execute(new String[]{"clean", "install"});
        result.assertErrorFreeLog();
        File kjarFile = new File(basedir, "target/kie-maven-plugin-test-kjar-6-1.0.0.Final.jar");
        Assertions.assertThat((boolean)kjarFile.exists()).isTrue();
        JarFile jarFile = new JarFile(kjarFile);
        HashSet<String> jarContent = new HashSet<String>();
        Enumeration<JarEntry> kjarEntries = jarFile.entries();
        while (kjarEntries.hasMoreElements()) {
            String entryName = kjarEntries.nextElement().getName();
            jarContent.add(entryName);
        }
        Assertions.assertThat(jarContent).isNotEmpty();
        Assertions.assertThat(jarContent).contains((Object[])new String[]{PMML_FILE_NAME});
        Assertions.assertThat(jarContent).contains((Object[])new String[]{EXAMPLE_PMML_CLASS});
    }
}

