/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.TestResources;
import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenJUnitTestRunner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.junit.Rule;
import org.junit.runner.RunWith;

@RunWith(value=MavenJUnitTestRunner.class)
@MavenVersions(value={"3.3.9", "3.5.0"})
public abstract class KieMavenPluginBaseIntegrationTest {
    @Rule
    public final TestResources resources = new TestResources();
    public final MavenRuntime.MavenRuntimeBuilder mavenRuntimeBuilder;

    public KieMavenPluginBaseIntegrationTest(MavenRuntime.MavenRuntimeBuilder builder) {
        this.mavenRuntimeBuilder = builder;
    }

    protected void prepareTakariPom(String projectName) throws Exception {
        File basedir = this.getBasedir(projectName);
        File pomTakari = new File(basedir, "pom-takari.xml");
        Files.move(pomTakari.toPath(), new File(basedir, "pom.xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected void restoreKiePom(String projectName) throws Exception {
        File basedir = this.getBasedir(projectName);
        File pomKie = new File(basedir, "pom-kie.xml");
        Files.move(pomKie.toPath(), new File(basedir, "pom.xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected MavenExecutionResult buildKJarProject(String kjarName, String[] options, String ... mavenGoals) throws Exception {
        MavenRuntime mavenRuntime = this.mavenRuntimeBuilder.forkedBuilder().withEnvironment(System.getenv()).withCliOptions(options).build();
        File basedir = this.resources.getBasedir(kjarName);
        MavenExecutionResult result = mavenRuntime.forProject(basedir).execute(mavenGoals);
        result.assertErrorFreeLog();
        return result;
    }

    private File getBasedir(String projectName) throws Exception {
        return this.resources.getBasedir(projectName);
    }
}

