/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.TestResources;
import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenJUnitTestRunner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MavenJUnitTestRunner.class)
@MavenVersions(value={"3.3.9", "3.5.0"})
public abstract class KieMavenPluginBaseIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(KieMavenPluginBaseIntegrationTest.class);
    private static final ConcurrentHashMap<String, MavenExecutionResult> BUILT_MAP = new ConcurrentHashMap();
    @Rule
    public final TestResources resources = new TestResources();
    public final MavenRuntime.MavenRuntimeBuilder mavenRuntimeBuilder;

    public KieMavenPluginBaseIntegrationTest(MavenRuntime.MavenRuntimeBuilder builder) {
        this.mavenRuntimeBuilder = builder;
    }

    protected void prepareTakariPom(String projectName) throws Exception {
        File basedir = this.getBasedir(projectName);
        File pomTakari = new File(basedir, "pom-takari.xml");
        Files.move(pomTakari.toPath(), new File(basedir, "pom.xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected void restoreKiePom(String projectName) throws Exception {
        File basedir = this.getBasedir(projectName);
        File pomKie = new File(basedir, "pom-kie.xml");
        Files.move(pomKie.toPath(), new File(basedir, "pom.xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected MavenExecutionResult buildKJarProject(String kjarName, String[] options, String ... mavenGoals) throws Exception {
        logger.info("Asking for kjar {} {} {}", new Object[]{kjarName, options, mavenGoals});
        MavenRuntime mavenRuntime = this.mavenRuntimeBuilder.forkedBuilder().withEnvironment(System.getenv()).withCliOptions(options).build();
        StringBuilder builder = new StringBuilder();
        builder.append(kjarName).append("_");
        builder.append(mavenRuntime.getMavenVersion()).append("_");
        for (String option : options) {
            builder.append(option).append("_");
        }
        for (String mavenGoal : mavenGoals) {
            builder.append(mavenGoal).append("_");
        }
        String key = builder.toString();
        return BUILT_MAP.computeIfAbsent(key, v -> this.getMavenExecutionResult(kjarName, mavenRuntime, mavenGoals));
    }

    private MavenExecutionResult getMavenExecutionResult(String kjarName, MavenRuntime mavenRuntime, String ... mavenGoals) {
        try {
            logger.info("Compiling kjar {} {} {}", new Object[]{kjarName, mavenRuntime.getMavenVersion(), mavenGoals});
            File basedir = this.resources.getBasedir(kjarName);
            MavenExecutionResult toReturn = mavenRuntime.forProject(basedir).execute(mavenGoals);
            toReturn.assertErrorFreeLog();
            return toReturn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File getBasedir(String projectName) throws Exception {
        return this.resources.getBasedir(projectName);
    }
}

