/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.benchmarks.regression;

import java.util.concurrent.TimeUnit;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.benchmarks.regression.AbstractRegressionBenchmark;
import org.kie.pmml.evaluator.core.PMMLContextImpl;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Thread)
@Warmup(iterations=2)
@Measurement(iterations=5, time=30)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
public class CategoricalBatchBenchmark
extends AbstractRegressionBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(CategoricalBatchBenchmark.class);
    private static final String MODEL_NAME = "Sample for logistic regression";
    private static final String[] LINES = new String[]{"38,Private,College,Unmarried,Service,81838,Female,FALSE,72,0", "30,Consultant,HSgrad,Divorced,Repair,9608.48,Male,FALSE,40,0", "65,SelfEmp,College,Married,Sales,32963.39,Male,FALSE,40,0", "40,PSLocal,Vocational,Divorced,Executive,182165.08,Female,FALSE,40,0", "41,PSState,Bachelor,Divorced,Executive,70603.7,Male,FALSE,40,0", "49,PSFederal,College,Married,Support,15345.33,Male,FALSE,40,1", "62,Volunteer,Associate,Married,Farming,51230.5,Male,FALSE,50,0}"};
    @Param(value={"0", "1", "2", "3", "4", "5", "6"})
    int index;

    private static PMMLContext readCSV(String line) {
        if (line.startsWith("Age")) {
            return null;
        }
        String[] split = line.split(",");
        PMMLRequestData pmmlRequestData = new PMMLRequestData("123", MODEL_NAME);
        pmmlRequestData.addRequestParam("Age", (Object)Integer.valueOf(split[0]));
        pmmlRequestData.addRequestParam("Employment", (Object)split[1]);
        pmmlRequestData.addRequestParam("Education", (Object)split[2]);
        pmmlRequestData.addRequestParam("Marital", (Object)split[3]);
        pmmlRequestData.addRequestParam("Occupation", (Object)split[4]);
        pmmlRequestData.addRequestParam("Income", (Object)Double.valueOf(split[5]));
        pmmlRequestData.addRequestParam("Gender", (Object)split[6]);
        pmmlRequestData.addRequestParam("Hours", (Object)Integer.valueOf(split[8]));
        return new PMMLContextImpl(pmmlRequestData);
    }

    @Override
    @Setup
    public void setupModel() throws Exception {
        logger.debug("setup model...");
        this.modelName = MODEL_NAME;
        this.fileName = "CategoricalRegressionSample.pmml";
        super.setupModel();
        logger.debug("setup pmmlContext...");
        this.pmmlContext = CategoricalBatchBenchmark.readCSV(LINES[this.index]);
    }

    @Override
    @Benchmark
    public PMML4Result evaluate() {
        return super.evaluate();
    }
}

