/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.enums.ARRAY_TYPE;
import org.kie.pmml.commons.model.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;

public class KiePMMLSimpleSetPredicateTest {
    private final String SIMPLE_SET_PREDICATE_NAME = "SIMPLESETPREDICATENAME";

    @Test
    public void evaluateStringIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateStringNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "NOT");
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateIntIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "234");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "432");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateIntNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "234");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "432");
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateRealIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "23.4");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "4.32");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateRealNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "23.4");
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATENAME", "4.32");
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData));
    }

    @Test
    public void evaluationStringIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"NOT"));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
    }

    @Test
    public void evaluationStringNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"NOT"));
    }

    @Test
    public void evaluationIntIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"234"));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
    }

    @Test
    public void evaluationIntNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"234"));
    }

    @Test
    public void evaluationRealIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"23.4"));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
    }

    @Test
    public void evaluationRealNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assert.assertFalse((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0)));
        Assert.assertTrue((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"23.4"));
    }

    private KiePMMLSimpleSetPredicate getKiePMMLSimpleSetPredicate(List<Object> values, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        return (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATENAME", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }
}

