/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelFactoryUtilsTest {
    private static final String SOURCE = "TransformationsSample.pmml";
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static PMML pmmlModel;
    private static TreeModel model;
    private ConstructorDeclaration constructorDeclaration;
    private ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setup() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
    }

    @Before
    public void init() {
        CompilationUnit compilationUnit = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration Template  from Template.tmpl"))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from Template.tmpl"));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertTrue((boolean)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).isPresent());
        this.classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void addKiePMMLOutputFieldsPopulation() {
        BlockStmt blockStmt = new BlockStmt();
        List outputFields = IntStream.range(0, 3).mapToObj(index -> (KiePMMLOutputField)KiePMMLOutputField.builder((String)("OUTPUTFIELD-" + index), Collections.emptyList()).withRank(Integer.valueOf(new Random().nextInt(3))).withValue((Object)("VALUE-" + index)).withTargetField("TARGETFIELD-" + index).build()).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.addKiePMMLOutputFieldsPopulation((BlockStmt)blockStmt, outputFields);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(blockStmt, outputFields.size(), "kiePMMLOutputFields", "add");
        for (KiePMMLOutputField outputField : outputFields) {
            Assert.assertTrue((boolean)retrieved.stream().filter(methodCallExpr -> methodCallExpr.getArguments().size() == 1).map(methodCallExpr -> methodCallExpr.getArgument(0)).filter(Expression::isMethodCallExpr).map(expressionArgument -> (MethodCallExpr)expressionArgument).anyMatch(methodCallExpr -> this.evaluateOutputFieldPopulation((MethodCallExpr)methodCallExpr, outputField)));
        }
    }

    @Test
    public void addTransformationsInClassOrInterfaceDeclaration() {
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
        pmmlModel.getTransformationDictionary().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, null, "commonTransformationsMap"));
        model.getLocalTransformations().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, null, "localTransformationsMap"));
        this.commonVerifyConstructorClass("commonTransformationsMap");
        this.commonVerifyConstructorClass("localTransformationsMap");
    }

    @Test
    public void populateTransformationsInConstructor() {
        AtomicInteger arityCounter = new AtomicInteger(0);
        Map commonDerivedFieldsMethodMap = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap((List)pmmlModel.getTransformationDictionary().getDerivedFields(), (AtomicInteger)arityCounter);
        Map localDerivedFieldsMethodMap = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap((List)model.getLocalTransformations().getDerivedFields(), (AtomicInteger)arityCounter);
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor((ConstructorDeclaration)this.constructorDeclaration, (Map)commonDerivedFieldsMethodMap, (Map)localDerivedFieldsMethodMap);
        pmmlModel.getTransformationDictionary().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, commonDerivedFieldsMethodMap, "commonTransformationsMap"));
        model.getLocalTransformations().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, localDerivedFieldsMethodMap, "localTransformationsMap"));
    }

    private void commonVerifyConstructorClass(String mapName) {
        List methodDeclarations = this.classOrInterfaceDeclaration.getMembers().stream().filter(bodyDeclaration -> bodyDeclaration instanceof MethodDeclaration).map(bodyDeclaration -> (MethodDeclaration)bodyDeclaration).collect(Collectors.toList());
        NodeList statements = this.constructorDeclaration.getBody().getStatements();
        statements.stream().filter(statement -> {
            if (!(statement instanceof ExpressionStmt)) {
                return false;
            }
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            if (!(expressionStmt.getExpression() instanceof MethodCallExpr)) {
                return false;
            }
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            if (!methodCallExpr.getScope().isPresent() || !(methodCallExpr.getScope().get() instanceof NameExpr)) {
                return false;
            }
            NameExpr nameExpr = (NameExpr)methodCallExpr.getScope().get();
            return mapName.equals(nameExpr.getNameAsString());
        }).map(statement -> {
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            return (MethodReferenceExpr)methodCallExpr.getArgument(1);
        }).forEach(methodReferenceExpr -> Assert.assertTrue((boolean)methodDeclarations.stream().anyMatch(methodDeclaration -> methodDeclaration.getName().asString().equals(methodReferenceExpr.getIdentifier()))));
    }

    private void commonVerifyDerivedFieldTransformation(DerivedField toVerify, Map<String, MethodDeclaration> derivedFieldsMethodMap, String mapToVerify) {
        NodeList statements = this.constructorDeclaration.getBody().getStatements();
        String fieldName = toVerify.getName().getValue();
        if (derivedFieldsMethodMap != null) {
            this.commonVerifyDerivedFieldMethodMap(toVerify, derivedFieldsMethodMap);
        }
        Assert.assertTrue((boolean)statements.stream().anyMatch(statement -> {
            if (!(statement instanceof ExpressionStmt)) {
                return false;
            }
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            if (!(expressionStmt.getExpression() instanceof MethodCallExpr)) {
                return false;
            }
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            if (!methodCallExpr.getScope().isPresent() || !(methodCallExpr.getScope().get() instanceof NameExpr)) {
                return false;
            }
            NameExpr nameExpr = (NameExpr)methodCallExpr.getScope().get();
            if (!mapToVerify.equals(nameExpr.getNameAsString())) {
                return false;
            }
            Assert.assertEquals((Object)"put", (Object)methodCallExpr.getName().asString());
            Assert.assertEquals((long)2L, (long)methodCallExpr.getArguments().size());
            Assert.assertTrue((boolean)(methodCallExpr.getArgument(0) instanceof StringLiteralExpr));
            Assert.assertTrue((boolean)(methodCallExpr.getArgument(1) instanceof MethodReferenceExpr));
            if (!fieldName.equals(((StringLiteralExpr)methodCallExpr.getArgument(0)).getValue())) {
                return false;
            }
            Assert.assertTrue((boolean)(((MethodReferenceExpr)methodCallExpr.getArgument(1)).getScope() instanceof ThisExpr));
            if (derivedFieldsMethodMap != null) {
                Assert.assertEquals((Object)((MethodDeclaration)derivedFieldsMethodMap.get(fieldName)).getName().asString(), (Object)((MethodReferenceExpr)methodCallExpr.getArgument(1)).getIdentifier());
            }
            return true;
        }));
    }

    private boolean evaluateOutputFieldPopulation(MethodCallExpr methodCallExpr, KiePMMLOutputField outputField) {
        boolean toReturn = this.commonEvaluateMethodCallExpr(methodCallExpr, "build", (NodeList<Expression>)new NodeList(), MethodCallExpr.class);
        MethodCallExpr resultFeatureScopeExpr = (MethodCallExpr)methodCallExpr.getScope().get();
        NodeList expectedArguments = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(resultFeatureScopeExpr, "withResultFeature", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr targetFieldScopeExpr = (MethodCallExpr)resultFeatureScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
        toReturn &= this.commonEvaluateMethodCallExpr(targetFieldScopeExpr, "withTargetField", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr valueScopeExpr = (MethodCallExpr)targetFieldScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(valueScopeExpr, "withValue", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr rankScopeExpr = (MethodCallExpr)valueScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
        toReturn &= this.commonEvaluateMethodCallExpr(rankScopeExpr, "withRank", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr builderScopeExpr = (MethodCallExpr)rankScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
        toReturn &= this.commonEvaluateMethodCallExpr(builderScopeExpr, "builder", (NodeList<Expression>)expectedArguments, NameExpr.class);
        toReturn &= builderScopeExpr.getName().equals((Object)new SimpleName("builder"));
        return toReturn &= ((Expression)builderScopeExpr.getScope().get()).equals((Object)new NameExpr("KiePMMLOutputField"));
    }

    private boolean commonEvaluateMethodCallExpr(MethodCallExpr toEvaluate, String name, NodeList<Expression> expectedArguments, Class<? extends Expression> expectedScopeType) {
        boolean toReturn = Objects.equals(new SimpleName(name), toEvaluate.getName());
        toReturn &= expectedArguments.size() == toEvaluate.getArguments().size();
        for (int i = 0; i < expectedArguments.size(); ++i) {
            toReturn &= ((Expression)expectedArguments.get(i)).equals((Object)toEvaluate.getArgument(i));
        }
        if (expectedScopeType != null) {
            toReturn &= toEvaluate.getScope().isPresent() && ((Expression)toEvaluate.getScope().get()).getClass().equals(expectedScopeType);
        }
        return toReturn;
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt, expectedSize);
        return statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt, int expectedSize) {
        NodeList statements = blockStmt.getStatements();
        Assert.assertEquals((long)expectedSize, (long)statements.size());
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }

    private void commonVerifyDerivedFieldMethodMap(DerivedField toVerify, Map<String, MethodDeclaration> derivedFieldsMethodMap) {
        Assert.assertNotNull(derivedFieldsMethodMap);
        Assert.assertTrue((boolean)derivedFieldsMethodMap.containsKey(toVerify.getName().getValue()));
    }
}

