/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLPredicateFactoryTest {
    private static Map<String, DataType> simplePredicateNameType;
    private static List<SimplePredicate> simplePredicates;
    private static Map<String, Array.Type> simpleSetPredicateNameType;
    private static List<SimpleSetPredicate> simpleSetPredicates;
    private static DataDictionary dataDictionary;
    private ConstructorDeclaration constructorDeclaration;
    private ExplicitConstructorInvocationStmt superInvocation;
    private List<AssignExpr> assignExprs;

    @BeforeClass
    public static void setup() {
        simplePredicateNameType = new HashMap<String, DataType>();
        simplePredicateNameType.put("age", DataType.INTEGER);
        simplePredicateNameType.put("weight", DataType.DOUBLE);
        simplePredicateNameType.put("name", DataType.STRING);
        simplePredicateNameType.put("runner", DataType.BOOLEAN);
        simplePredicates = simplePredicateNameType.entrySet().stream().map(entry -> PMMLModelTestUtils.getSimplePredicate((String)entry.getKey(), PMMLModelTestUtils.getRandomValue((DataType)entry.getValue()), PMMLModelTestUtils.getRandomSimplePredicateOperator())).collect(Collectors.toList());
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        simplePredicateNameType.forEach((name, dataType) -> {
            DataField toAdd = new DataField();
            toAdd.setName(FieldName.create((String)name));
            toAdd.setDataType(dataType);
            dataFields.add(toAdd);
        });
        dataDictionary = PMMLModelTestUtils.getDataDictionary(dataFields);
        simpleSetPredicateNameType = new HashMap<String, Array.Type>();
        simpleSetPredicateNameType.put("age", Array.Type.INT);
        simpleSetPredicateNameType.put("weight", Array.Type.REAL);
        simpleSetPredicateNameType.put("name", Array.Type.STRING);
        simpleSetPredicates = simpleSetPredicateNameType.entrySet().stream().map(entry -> {
            List<String> values = PMMLModelTestUtils.getStringObjects((Array.Type)entry.getValue(), 4);
            return PMMLModelTestUtils.getSimpleSetPredicate((String)entry.getKey(), (Array.Type)entry.getValue(), values, PMMLModelTestUtils.getRandomSimpleSetPredicateOperator());
        }).collect(Collectors.toList());
    }

    @Test
    public void getPredicates() {
        ArrayList<SimplePredicate> predicates = new ArrayList<SimplePredicate>(simplePredicates);
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        predicates.add((SimplePredicate)compoundPredicate);
        True truePredicate = new True();
        predicates.add((SimplePredicate)truePredicate);
        False falsePredicate = new False();
        predicates.add((SimplePredicate)falsePredicate);
        List retrieved = KiePMMLPredicateFactory.getPredicates(predicates, (DataDictionary)dataDictionary);
        Assert.assertEquals((long)predicates.size(), (long)retrieved.size());
    }

    @Test
    public void getPredicateSimple() {
        simplePredicates.forEach(simplePredicate -> {
            KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)simplePredicate, (DataDictionary)dataDictionary);
            Assert.assertTrue((boolean)(retrieved instanceof KiePMMLSimplePredicate));
        });
    }

    @Test
    public void getPredicateSimpleSet() {
        simpleSetPredicates.forEach(simpleSetPredicate -> {
            KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)simpleSetPredicate, (DataDictionary)dataDictionary);
            Assert.assertTrue((boolean)(retrieved instanceof KiePMMLSimpleSetPredicate));
        });
    }

    @Test
    public void getPredicateCompound() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        compoundPredicate.getPredicates().addAll(simpleSetPredicates);
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)compoundPredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLCompoundPredicate));
    }

    @Test
    public void getPredicateTrue() {
        True truePredicate = new True();
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)truePredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLTruePredicate));
    }

    @Test
    public void getPredicateFalse() {
        False falsePredicate = new False();
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)falsePredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLFalsePredicate));
    }

    @Test(expected=KiePMMLException.class)
    public void getPredicateUnknown() {
        Predicate unknownPredicate = new Predicate(){

            public VisitorAction accept(Visitor visitor) {
                return null;
            }
        };
        KiePMMLPredicateFactory.getPredicate((Predicate)unknownPredicate, (DataDictionary)dataDictionary);
    }

    @Test
    public void getKiePMMLSimplePredicate() {
        simplePredicates.forEach(simplePredicate -> {
            KiePMMLSimplePredicate retrieved = KiePMMLPredicateFactory.getKiePMMLSimplePredicate((SimplePredicate)simplePredicate, (DataType)simplePredicateNameType.get(simplePredicate.getField().getValue()));
            this.commonVerifySimplePredicate(retrieved, null);
        });
    }

    @Test
    public void getKiePMMLSimpleSetPredicate() {
        simpleSetPredicates.forEach(simpleSetPredicate -> {
            KiePMMLSimpleSetPredicate retrieved = KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicate((SimpleSetPredicate)simpleSetPredicate);
            this.commonVerifySimpleSetPredicate(retrieved, null);
        });
    }

    @Test
    public void getKiePMMLCompoundPredicate() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        KiePMMLCompoundPredicate retrieved = KiePMMLPredicateFactory.getKiePMMLCompoundPredicate((CompoundPredicate)compoundPredicate, (DataDictionary)dataDictionary);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.XOR, (Object)retrieved.getBooleanOperator());
        Assert.assertEquals((long)simplePredicates.size(), (long)retrieved.getKiePMMLPredicates().size());
        retrieved.getKiePMMLPredicates().forEach(simplePredicate -> this.commonVerifySimplePredicate((KiePMMLSimplePredicate)simplePredicate, retrieved.getId()));
    }

    @Test
    public void getKiePMMLTruePredicate() {
        KiePMMLTruePredicate retrieved = KiePMMLPredicateFactory.getKiePMMLTruePredicate();
        Assert.assertNotNull((Object)retrieved);
        KiePMMLTruePredicate expected = (KiePMMLTruePredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        Assert.assertEquals((Object)expected.getName(), (Object)retrieved.getName());
        Assert.assertNotEquals((Object)expected.getId(), (Object)retrieved.getId());
    }

    @Test
    public void getKiePMMLFalsePredicate() {
        KiePMMLFalsePredicate retrieved = KiePMMLPredicateFactory.getKiePMMLFalsePredicate();
        Assert.assertNotNull((Object)retrieved);
        KiePMMLFalsePredicate expected = (KiePMMLFalsePredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        Assert.assertEquals((Object)expected.getName(), (Object)retrieved.getName());
        Assert.assertNotEquals((Object)expected.getId(), (Object)retrieved.getId());
    }

    @Test
    public void getPredicateSourcesMap() {
        String packageName = "PACKAGENAME";
        String predicateName = "PREDICATENAME";
        KiePMMLPredicate kiePMMLPredicate = (KiePMMLPredicate)KiePMMLSimplePredicate.builder((String)predicateName, Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        Map retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.OR).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLSimplePredicateSourcesMap() {
        String predicateName = "PREDICATENAME";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)predicateName, Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLSimplePredicateSourcesMap((KiePMMLSimplePredicate)kiePMMLSimplePredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLSimplePredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLSimpleSetPredicateSourcesMap() {
        String predicateName = "PREDICATENAME";
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)predicateName, Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicateSourcesMap((KiePMMLSimpleSetPredicate)kiePMMLSimpleSetPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLSimpleSetPredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLCompoundPredicateSourcesMap() {
        KiePMMLSimplePredicate kiePMMLSimplePredicateInt = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATEINTNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        KiePMMLSimplePredicate kiePMMLSimplePredicateString = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATESTRINGNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)"FOR").build();
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATE", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        List<KiePMMLPredicate> kiePMMLPredicates = Arrays.asList(kiePMMLSimplePredicateInt, kiePMMLSimplePredicateString, kiePMMLSimpleSetPredicate);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.OR).withKiePMMLPredicates(kiePMMLPredicates).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLCompoundPredicateSourcesMap((KiePMMLCompoundPredicate)kiePMMLCompoundPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLCompoundPredicate.getId()), 4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getKiePMMLCompoundPredicateUnsupportedSourcesMap() {
        KiePMMLSimplePredicate kiePMMLSimplePredicateInt = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATEINTNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        KiePMMLSimplePredicate kiePMMLSimplePredicateString = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATESTRINGNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)"FOR").build();
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATE", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        List<KiePMMLPredicate> kiePMMLPredicates = Arrays.asList(kiePMMLSimplePredicateInt, kiePMMLSimplePredicateString, kiePMMLSimpleSetPredicate);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.SURROGATE).withKiePMMLPredicates(kiePMMLPredicates).build();
        KiePMMLPredicateFactory.getKiePMMLCompoundPredicateSourcesMap((KiePMMLCompoundPredicate)kiePMMLCompoundPredicate, (String)"PACKAGENAME");
    }

    @Test
    public void getKiePMMLTruePredicateSourcesMap() {
        KiePMMLTruePredicate kiePMMLTruePredicate = (KiePMMLTruePredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLTruePredicateSourcesMap((KiePMMLTruePredicate)kiePMMLTruePredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLTruePredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLFalsePredicateSourcesMap() {
        KiePMMLFalsePredicate kiePMMLFalsePredicate = (KiePMMLFalsePredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLFalsePredicateSourcesMap((KiePMMLFalsePredicate)kiePMMLFalsePredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLFalsePredicate.getId()), 1);
    }

    @Test
    public void setSimplePredicateConstructorGreaterOrEqual() {
        this.init("KiePMMLSimplePredicateTemplate.tmpl", "KiePMMLSimplePredicateTemplate");
        AssignExpr valueAssignExpr = this.assignExprs.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().getNameAsString().equals("value")).findFirst().orElseThrow(() -> new RuntimeException("Missing \"value\" assign variable"));
        Assert.assertTrue((boolean)(valueAssignExpr.getValue() instanceof NullLiteralExpr));
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        OPERATOR operator = OPERATOR.GREATER_OR_EQUAL;
        Integer value = 24;
        KiePMMLPredicateFactory.setSimplePredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (OPERATOR)operator, (Object)value);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(operator.getClass().getCanonicalName() + "." + operator.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        assignExpressionMap.put("value", (Expression)valueAssignExpr.getValue().asNameExpr());
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
        Assert.assertEquals((Object)"24", (Object)valueAssignExpr.getValue().asNameExpr().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setSimplePredicateConstructorIsMissing() {
        this.init("KiePMMLSimplePredicateTemplate.tmpl", "KiePMMLSimplePredicateTemplate");
        AssignExpr valueAssignExpr = this.assignExprs.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().getNameAsString().equals("value")).findFirst().orElseThrow(() -> new RuntimeException("Missing \"value\" assign variable"));
        Assert.assertTrue((boolean)(valueAssignExpr.getValue() instanceof NullLiteralExpr));
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        OPERATOR operator = OPERATOR.IS_MISSING;
        String value = "VALUE";
        KiePMMLPredicateFactory.setSimplePredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (OPERATOR)operator, (Object)value);
    }

    @Test
    public void setSimpleSetPredicateConstructor() {
        this.init("KiePMMLSimpleSetPredicateTemplate.tmpl", "KiePMMLSimpleSetPredicateTemplate");
        AssignExpr valueAssignExpr = this.assignExprs.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().getNameAsString().equals("values")).findFirst().orElseThrow(() -> new RuntimeException("Missing \"values\" assign variable"));
        Assert.assertTrue((boolean)(valueAssignExpr.getValue() instanceof NullLiteralExpr));
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLPredicateFactory.setSimpleSetPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn, values);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(arrayType.getClass().getCanonicalName() + "." + arrayType.name()));
        superInvocationExpressionsMap.put(3, (Expression)new NameExpr(inNotIn.getClass().getCanonicalName() + "." + inNotIn.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("values", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
        List methodCallExprs = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExpressionStmt).map(statement -> (ExpressionStmt)statement).filter(expressionStmt -> expressionStmt.getExpression() instanceof MethodCallExpr).map(expressionStmt -> (MethodCallExpr)expressionStmt.getExpression()).filter(methodCallExpr -> methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).asNameExpr().getName().asString().equals("values") && methodCallExpr.getName().asString().equals("add")).collect(Collectors.toList());
        Assert.assertNotNull(methodCallExprs);
        Assert.assertEquals((long)values.size(), (long)methodCallExprs.size());
        values.forEach(o -> {
            NameExpr expected = new NameExpr(o.toString());
            Assert.assertTrue((boolean)methodCallExprs.stream().anyMatch(arg_0 -> KiePMMLPredicateFactoryTest.lambda$null$19((Expression)expected, arg_0)));
        });
    }

    @Test
    public void setCompoundPredicateConstructorOr() {
        this.init("KiePMMLCompoundPredicateTemplate.tmpl", "KiePMMLCompoundPredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.OR;
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(booleanOperator.getClass().getCanonicalName() + "." + booleanOperator.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Expression expression = StaticJavaParser.parseExpression((String)"(aBoolean, aBoolean2) -> aBoolean != null ? aBoolean || aBoolean2 : aBoolean2");
        assignExpressionMap.put("operatorFunction", expression);
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("kiePMMLPredicates", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
        List methodCallExprs = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExpressionStmt).map(statement -> (ExpressionStmt)statement).filter(expressionStmt -> expressionStmt.getExpression() instanceof MethodCallExpr).map(expressionStmt -> (MethodCallExpr)expressionStmt.getExpression()).filter(methodCallExpr -> methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).asNameExpr().getName().asString().equals("kiePMMLPredicates") && methodCallExpr.getName().asString().equals("add")).collect(Collectors.toList());
        Assert.assertNotNull(methodCallExprs);
        Assert.assertEquals((long)predicatesClasses.size(), (long)methodCallExprs.size());
        predicatesClasses.forEach(predicateClass -> {
            ClassOrInterfaceType kiePMMLPredicateClass = StaticJavaParser.parseClassOrInterfaceType((String)predicateClass);
            ObjectCreationExpr expected = new ObjectCreationExpr();
            expected.setType(kiePMMLPredicateClass);
            Assert.assertTrue((boolean)methodCallExprs.stream().anyMatch(methodCallExpr -> methodCallExpr.getArguments().size() == 1 && ((Expression)methodCallExpr.getArguments().get(0)).equals((Object)expected)));
        });
    }

    @Test
    public void setCompoundPredicateConstructorAnd() {
        this.init("KiePMMLCompoundPredicateTemplate.tmpl", "KiePMMLCompoundPredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.AND;
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(booleanOperator.getClass().getCanonicalName() + "." + booleanOperator.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Expression expression = StaticJavaParser.parseExpression((String)"(aBoolean, aBoolean2) -> aBoolean != null ? aBoolean && aBoolean2 : aBoolean2");
        assignExpressionMap.put("operatorFunction", expression);
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("kiePMMLPredicates", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setCompoundPredicateUnsupportedConstructor() {
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.SURROGATE;
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
    }

    @Test
    public void setTrueFalsePredicateConstructor() {
        this.init("KiePMMLTruePredicateTemplate.tmpl", "KiePMMLTruePredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        KiePMMLPredicateFactory.setTrueFalsePredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
    }

    @Test
    public void getObjectsFromArray() {
        Number expected;
        Object obj;
        int i;
        List<String> values = Arrays.asList("32", "11", "43");
        Array array = PMMLModelTestUtils.getArray(Array.Type.INT, values);
        List retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Integer));
            expected = Integer.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
        values = Arrays.asList("just", "11", "fun");
        array = PMMLModelTestUtils.getArray(Array.Type.STRING, values);
        retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof String));
            Assert.assertEquals((Object)values.get(i), obj);
        }
        values = Arrays.asList("23.11", "11", "123.123");
        array = PMMLModelTestUtils.getArray(Array.Type.REAL, values);
        retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Double));
            expected = Double.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
    }

    private void init(String templateSource, String templateClassName) {
        CompilationUnit compilationUnit = JavaParserUtils.getFromFileName((String)templateSource);
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(templateClassName).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration " + templateClassName + "  from " + templateSource))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from " + templateSource));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertEquals((Object)templateClassName, (Object)this.constructorDeclaration.getName().asString());
        Assert.assertTrue((boolean)compilationUnit.getClassByName(templateClassName).isPresent());
        this.superInvocation = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExplicitConstructorInvocationStmt).map(statement -> (ExplicitConstructorInvocationStmt)statement).findFirst().orElseThrow(() -> new RuntimeException("Failed to retrieve super invocation from " + templateSource));
        Assert.assertEquals((Object)"name", (Object)this.superInvocation.getArgument(0).asNameExpr().getNameAsString());
        this.assignExprs = this.constructorDeclaration.getBody().findAll(AssignExpr.class);
        Assert.assertNotNull(this.assignExprs);
    }

    private void commonVerifySimplePredicate(KiePMMLSimplePredicate toVerify, String parentId) {
        Optional<SimplePredicate> simplePredicate = simplePredicates.stream().filter(predicate -> predicate.getField().getValue().equals(toVerify.getName())).findFirst();
        if (!simplePredicate.isPresent()) {
            Assert.fail();
        } else {
            simplePredicate.ifPresent(predicate -> {
                OPERATOR expected = OPERATOR.byName((String)predicate.getOperator().value());
                Assert.assertEquals((Object)expected, (Object)toVerify.getOperator());
                Assert.assertEquals((Object)parentId, (Object)toVerify.getParentId());
            });
        }
    }

    private void commonVerifySimpleSetPredicate(KiePMMLSimpleSetPredicate toVerify, String parentId) {
        Optional<SimpleSetPredicate> simpleSetPredicate = simpleSetPredicates.stream().filter(predicate -> predicate.getField().getValue().equals(toVerify.getName())).findFirst();
        if (!simpleSetPredicate.isPresent()) {
            Assert.fail();
        } else {
            simpleSetPredicate.ifPresent(predicate -> {
                ARRAY_TYPE arrayTypeExpected = ARRAY_TYPE.byName((String)predicate.getArray().getType().value());
                Assert.assertEquals((Object)arrayTypeExpected, (Object)toVerify.getArrayType());
                IN_NOTIN inNotInExpected = IN_NOTIN.byName((String)predicate.getBooleanOperator().value());
                Assert.assertEquals((Object)inNotInExpected, (Object)toVerify.getInNotIn());
                Assert.assertEquals((Object)parentId, (Object)toVerify.getParentId());
            });
        }
    }

    private void commonVerifySourceMap(Map<String, String> toVerify, String packageName, String predicateName, int expectedSize) {
        Assert.assertNotNull(toVerify);
        Assert.assertEquals((long)expectedSize, (long)toVerify.size());
        String expectedKey = String.format("%s.%s", packageName, predicateName);
        Assert.assertTrue((boolean)toVerify.containsKey(expectedKey));
        CodegenTestUtils.commonValidateCompilation(toVerify);
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$null$19(Expression expected, MethodCallExpr methodCallExpr) {
        return methodCallExpr.getArguments().size() == 1 && ((Expression)methodCallExpr.getArguments().get(0)).equals((Object)expected);
    }
}

