/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.io.InputStream;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.mocks.KiePMMLTestModel;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelRetrieverTest {
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String PACKAGE_NAME = "packagename";
    private PMML pmmlModel;

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesWithProvider() {
        this.pmmlModel = PMMLModelTestUtils.getPMMLWithRandomTestModel();
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromDataDictionaryAndModelWithSourcesWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getPopulatedWithPMMLModelFields() {
        KiePMMLTestModel toPopulate = new KiePMMLTestModel();
        Assert.assertTrue((boolean)toPopulate.getMiningFields().isEmpty());
        Assert.assertTrue((boolean)toPopulate.getOutputFields().isEmpty());
        MiningSchema miningSchema = PMMLModelTestUtils.getRandomMiningSchema();
        Output output = PMMLModelTestUtils.getRandomOutput();
        KiePMMLTestModel populated = (KiePMMLTestModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (MiningSchema)miningSchema, (Output)output);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)populated.getMiningFields().size());
        Assert.assertEquals((long)output.getOutputFields().size(), (long)populated.getOutputFields().size());
        toPopulate = new KiePMMLTestModel();
        populated = (KiePMMLTestModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (MiningSchema)miningSchema, null);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)populated.getMiningFields().size());
        Assert.assertTrue((boolean)populated.getOutputFields().isEmpty());
        toPopulate = new KiePMMLTestModel();
        populated = (KiePMMLTestModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, null, (Output)output);
        Assert.assertTrue((boolean)populated.getMiningFields().isEmpty());
        Assert.assertEquals((long)output.getOutputFields().size(), (long)populated.getOutputFields().size());
        toPopulate = new KiePMMLTestModel();
        populated = (KiePMMLTestModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, null, null);
        Assert.assertTrue((boolean)populated.getMiningFields().isEmpty());
        Assert.assertTrue((boolean)populated.getOutputFields().isEmpty());
    }
}

