/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtilsTest;

public class DerivedFieldFunctionUtilsTest {
    private static final Function<Supplier<Expression>, DerivedField> derivedFieldCreator = supplier -> {
        Expression expression = (Expression)supplier.get();
        DerivedField defineFunction = new DerivedField();
        defineFunction.setName(FieldName.create((String)("DERIVED_FIELD_" + expression.getClass().getSimpleName())));
        defineFunction.setExpression(expression);
        return defineFunction;
    };

    @Test(expected=KiePMMLException.class)
    public void getDerivedFieldsMethodMapUnsupportedExpression() {
        List derivedFields = ExpressionFunctionUtilsTest.unsupportedExpressionSupplier.stream().map(derivedFieldCreator).collect(Collectors.toList());
        AtomicInteger arityCounter = new AtomicInteger();
        DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(derivedFields, (AtomicInteger)arityCounter);
    }

    @Test
    public void getDerivedFieldsMethodMapSupportedExpression() {
        List derivedFields = ExpressionFunctionUtilsTest.supportedExpressionSupplier.stream().map(derivedFieldCreator).collect(Collectors.toList());
        AtomicInteger arityCounter = new AtomicInteger();
        Map retrieved = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(derivedFields, (AtomicInteger)arityCounter);
        Assert.assertEquals((long)derivedFields.size(), (long)retrieved.size());
    }

    @Test
    public void getDerivedFieldMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            DerivedField derivedField = derivedFieldCreator.apply(supplier);
            try {
                DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)derivedField, (AtomicInteger)new AtomicInteger());
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", derivedField));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getDerivedFieldMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            DerivedField derivedField = derivedFieldCreator.apply(supplier);
            try {
                DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)derivedField, (AtomicInteger)new AtomicInteger());
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, derivedField.getExpression().getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getDerivedFieldMethodDeclarationWithoutExpression() {
        DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)new DerivedField(), (AtomicInteger)new AtomicInteger());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getExpressionMethodDeclarationUnknownExpression() {
        Expression expression = new Expression(){

            public VisitorAction accept(Visitor visitor) {
                return null;
            }
        };
        DerivedFieldFunctionUtils.getExpressionMethodDeclaration((Expression)expression, (DataType)DataType.STRING, (AtomicInteger)new AtomicInteger());
    }

    @Test
    public void getExpressionMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                DerivedFieldFunctionUtils.getExpressionMethodDeclaration((Expression)expression, (DataType)DataType.STRING, (AtomicInteger)new AtomicInteger());
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", expression.getClass()));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getExpressionMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                DerivedFieldFunctionUtils.getExpressionMethodDeclaration((Expression)expression, (DataType)DataType.STRING, (AtomicInteger)new AtomicInteger());
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, expression.getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getAggregatedMethodDeclaration() {
        DerivedFieldFunctionUtils.getAggregatedMethodDeclaration((Aggregate)new Aggregate(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getApplyMethodDeclaration() {
        MethodDeclaration retrieved = DerivedFieldFunctionUtils.getApplyMethodDeclaration((Apply)ExpressionFunctionUtilsTest.applySupplier.get(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = "java.lang.Object Apply3(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {\n    java.lang.Object variableapplyVariableConstant1 = 34.6;\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object variableapplyVariableFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);\n    return applyVariable;\n}";
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getConstantMethodDeclaration() {
        Constant constant = ExpressionFunctionUtilsTest.constantSupplier.get();
        int methodArity = new Random().nextInt(20);
        MethodDeclaration retrieved = DerivedFieldFunctionUtils.getConstantMethodDeclaration((Constant)constant, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.DOUBLE_CLASS, (int)methodArity, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expectedVariable = String.format("%s constantVariable = %s;", Double.class.getName(), constant.getValue());
        this.commonValidateConstant(retrieved, constant, methodArity, Double.class.getName(), expectedVariable);
        constant = new Constant();
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"EXPECTED");
        methodArity = new Random().nextInt(20);
        expectedVariable = String.format("%s constantVariable = \"%s\";", String.class.getName(), constant.getValue());
        retrieved = DerivedFieldFunctionUtils.getConstantMethodDeclaration((Constant)constant, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.STRING_CLASS, (int)methodArity, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        this.commonValidateConstant(retrieved, constant, methodArity, String.class.getName(), expectedVariable);
    }

    @Test(expected=KiePMMLException.class)
    public void getDiscretizeMethodDeclaration() {
        DerivedFieldFunctionUtils.getDiscretizeMethodDeclaration((Discretize)new Discretize(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getFieldRefMethodDeclaration() {
        int methodArity = new Random().nextInt(20);
        FieldRef fieldRef = ExpressionFunctionUtilsTest.fieldRefSupplier.get();
        MethodDeclaration retrieved = DerivedFieldFunctionUtils.getFieldRefMethodDeclaration((FieldRef)fieldRef, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.STRING_CLASS, (int)methodArity, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expectedVariable = String.format("%1$s fieldRefVariable = (%1$s) kiePMMLNameValue.map(%2$s::getValue).orElse(%3$s);", String.class.getName(), KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRef(retrieved, fieldRef, methodArity, expectedVariable, String.class.getName());
        fieldRef.setMapMissingTo("MAP_MISSING_TO");
        retrieved = DerivedFieldFunctionUtils.getFieldRefMethodDeclaration((FieldRef)fieldRef, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.STRING_CLASS, (int)methodArity, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expectedVariable = String.format("%1$s fieldRefVariable = (%1$s) kiePMMLNameValue.map(%2$s::getValue).orElse(\"%3$s\");", String.class.getName(), KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRef(retrieved, fieldRef, methodArity, expectedVariable, String.class.getName());
    }

    @Test(expected=KiePMMLException.class)
    public void getLagMethodDeclaration() {
        DerivedFieldFunctionUtils.getLagMethodDeclaration((Lag)new Lag(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getMapValuesMethodDeclaration() {
        DerivedFieldFunctionUtils.getMapValuesMethodDeclaration((MapValues)new MapValues(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormContinuousMethodDeclaration() {
        DerivedFieldFunctionUtils.getNormContinuousMethodDeclaration((NormContinuous)new NormContinuous(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (Map)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormDiscreteMethodDeclaration() {
        DerivedFieldFunctionUtils.getNormDiscreteMethodDeclaration((NormDiscrete)new NormDiscrete(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getTextIndexMethodDeclaration() {
        DerivedFieldFunctionUtils.getTextIndexMethodDeclaration((TextIndex)new TextIndex(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (int)3, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    private void commonValidateConstant(MethodDeclaration retrieved, Constant constant, int methodArity, String expectedClass, String expectedVariableDeclaration) {
        this.commonValidateMethodDeclaration(retrieved, (Expression)constant, methodArity);
        Assert.assertEquals((Object)expectedClass, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)2L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(0) instanceof ExpressionStmt));
        Assert.assertEquals((Object)expectedVariableDeclaration, (Object)((Statement)statements.get(0)).toString());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(1);
        Assert.assertEquals((Object)"return constantVariable;", (Object)returnStmt.toString());
    }

    private void commonValidateFieldRef(MethodDeclaration retrieved, FieldRef fieldRef, int methodArity, String expectedVariableDeclaration, String expectedReturnType) {
        this.commonValidateMethodDeclaration(retrieved, (Expression)fieldRef, methodArity);
        Assert.assertEquals((Object)expectedReturnType, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ExpressionStmt));
        Assert.assertEquals((Object)expectedVariableDeclaration, (Object)((Statement)statements.get(1)).toString());
        Assert.assertTrue((boolean)(statements.get(2) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(2);
        Assert.assertEquals((Object)"return fieldRefVariable;", (Object)returnStmt.toString());
    }

    private void commonValidateMethodDeclaration(MethodDeclaration toValidate, Expression expression, int methodArity) {
        Assert.assertNotNull((Object)toValidate);
        String expectedMethodName = String.format("%s%s", expression.getClass().getSimpleName(), methodArity);
        Assert.assertEquals((Object)toValidate.getName().asString(), (Object)expectedMethodName);
    }
}

