/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class ModelUtilsTest {
    private static Map<String, String> expectedBoxedClassName = new HashMap<String, String>();

    @Test
    public void convertToKieMiningField() {
        String fieldName = "fieldName";
        MiningField.UsageType usageType = MiningField.UsageType.ACTIVE;
        org.dmg.pmml.MiningField toConvert = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        MiningField retrieved = ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)toConvert);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"fieldName", (Object)retrieved.getName());
        Assert.assertEquals((Object)FIELD_USAGE_TYPE.ACTIVE, (Object)retrieved.getUsageType());
        Assert.assertNull((Object)retrieved.getOpType());
        toConvert.setOpType(OpType.CATEGORICAL);
        retrieved = ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)toConvert);
        Assert.assertEquals((Object)OP_TYPE.CATEGORICAL, (Object)retrieved.getOpType());
    }

    @Test
    public void convertToKieOutputField() {
        org.dmg.pmml.OutputField toConvert = PMMLModelTestUtils.getRandomOutputField();
        OutputField retrieved = ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)toConvert);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)toConvert.getName().getValue(), (Object)retrieved.getName());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)toConvert.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)retrieved.getOpType());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)toConvert.getDataType().value());
        Assert.assertEquals((Object)expectedDataType, (Object)retrieved.getDataType());
        Assert.assertEquals((Object)toConvert.getTargetField().getValue(), (Object)retrieved.getTargetField());
        RESULT_FEATURE expectedResultFeature = RESULT_FEATURE.byName((String)toConvert.getResultFeature().value());
        Assert.assertEquals((Object)expectedResultFeature, (Object)retrieved.getResultFeature());
        toConvert.setOpType(null);
        toConvert.setTargetField(null);
        retrieved = ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)toConvert);
        Assert.assertNull((Object)retrieved.getOpType());
        Assert.assertNull((Object)retrieved.getTargetField());
    }

    @Test
    public void getBoxedClassNameByParameterFields() {
        List<ParameterField> parameterFields = PMMLModelTestUtils.getParameterFields();
        parameterFields.forEach(parameterField -> {
            String retrieved = ModelUtils.getBoxedClassName((ParameterField)parameterField);
            this.commonVerifyEventuallyBoxedClassName(retrieved, parameterField.getDataType());
        });
    }

    @Test
    public void getBoxedClassNameByDataTypes() {
        List<DataType> dataTypes = PMMLModelTestUtils.getDataTypes();
        dataTypes.forEach(dataType -> {
            String retrieved = ModelUtils.getBoxedClassName((DataType)dataType);
            this.commonVerifyEventuallyBoxedClassName(retrieved, (DataType)dataType);
        });
    }

    private void commonVerifyEventuallyBoxedClassName(String toVerify, DataType dataType) {
        Assert.assertEquals((Object)expectedBoxedClassName.get(dataType.value()), (Object)toVerify);
    }

    static {
        expectedBoxedClassName.put("string", String.class.getName());
        expectedBoxedClassName.put("integer", Integer.class.getName());
        expectedBoxedClassName.put("float", Float.class.getName());
        expectedBoxedClassName.put("double", Double.class.getName());
        expectedBoxedClassName.put("boolean", Boolean.class.getName());
        expectedBoxedClassName.put("date", Date.class.getName());
        expectedBoxedClassName.put("time", Date.class.getName());
        expectedBoxedClassName.put("dateTime", Date.class.getName());
        expectedBoxedClassName.put("dateDaysSince[0]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1960]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1970]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1980]", Long.class.getName());
        expectedBoxedClassName.put("timeSeconds", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[0]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1960]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1970]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1980]", Long.class.getName());
    }
}

