/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.RandomStringUtils;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;
import org.xml.sax.SAXException;

public class KiePMMLUtilTest {
    private static final String NO_MODELNAME_SAMPLE_NAME = "NoModelNameSample.pmml";
    private static final String NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME = "NoModelNameNoSegmentIdSample.pmml";

    @Test
    public void loadString() throws IOException, JAXBException, SAXException {
        this.commonLoadString(NO_MODELNAME_SAMPLE_NAME);
        this.commonLoadString(NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME);
    }

    @Test
    public void loadFile() throws JAXBException, IOException, SAXException {
        this.commonLoadFile(NO_MODELNAME_SAMPLE_NAME);
        this.commonLoadFile(NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME);
    }

    @Test
    public void populateMissingOutputFieldDataType() {
        Random random = new Random();
        List fieldNames = IntStream.range(0, 6).mapToObj(i -> RandomStringUtils.random((int)6, (boolean)true, (boolean)false)).collect(Collectors.toList());
        List dataFields = fieldNames.stream().map(fieldName -> {
            DataField toReturn = new DataField();
            toReturn.setName(FieldName.create((String)fieldName));
            DataType dataType = DataType.values()[random.nextInt(DataType.values().length)];
            toReturn.setDataType(dataType);
            return toReturn;
        }).collect(Collectors.toList());
        List miningFields = IntStream.range(0, dataFields.size() - 1).mapToObj(dataFields::get).map(dataField -> {
            MiningField toReturn = new MiningField();
            toReturn.setName(FieldName.create((String)dataField.getName().getValue()));
            toReturn.setUsageType(MiningField.UsageType.ACTIVE);
            return toReturn;
        }).collect(Collectors.toList());
        DataField lastDataField = (DataField)dataFields.get(dataFields.size() - 1);
        MiningField targetMiningField = new MiningField();
        targetMiningField.setName(FieldName.create((String)lastDataField.getName().getValue()));
        targetMiningField.setUsageType(MiningField.UsageType.TARGET);
        miningFields.add(targetMiningField);
        List<OutputField> outputFields = IntStream.range(0, 3).mapToObj(i -> {
            OutputField toReturn = new OutputField();
            toReturn.setName(FieldName.create((String)RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
            toReturn.setResultFeature(ResultFeature.PROBABILITY);
            return toReturn;
        }).collect(Collectors.toList());
        OutputField targetOutputField = new OutputField();
        targetOutputField.setName(FieldName.create((String)RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        targetOutputField.setResultFeature(ResultFeature.PREDICTED_VALUE);
        outputFields.add(targetOutputField);
        OutputField targetingOutputField = new OutputField();
        targetingOutputField.setName(FieldName.create((String)RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        targetingOutputField.setTargetField(FieldName.create((String)targetMiningField.getName().getValue()));
        outputFields.add(targetingOutputField);
        outputFields.forEach(outputField -> Assert.assertNull((Object)outputField.getDataType()));
        IntStream.range(0, 2).forEach(i -> {
            OutputField toAdd = new OutputField();
            toAdd.setName(FieldName.create((String)RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
            DataType dataType = DataType.values()[random.nextInt(DataType.values().length)];
            toAdd.setDataType(dataType);
            outputFields.add(toAdd);
        });
        KiePMMLUtil.populateMissingOutputFieldDataType(outputFields, miningFields, dataFields);
        outputFields.forEach(outputField -> Assert.assertNotNull((Object)outputField.getDataType()));
    }

    @Test
    public void getSanitizedId() {
        String modelName = "MODEL_NAME";
        String id = "2";
        String expected = String.format("%sSegment%s", "MODEL_NAME", id);
        String retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
        id = "34.5";
        expected = String.format("%sSegment%s", "MODEL_NAME", id);
        retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
        id = "3,45";
        expected = String.format("%sSegment%s", "MODEL_NAME", id);
        retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private void commonLoadString(String fileName) throws IOException, JAXBException, SAXException {
        FileInputStream inputStream = FileUtils.getFileInputStream((String)fileName);
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        PMML retrieved = KiePMMLUtil.load((String)textBuilder.toString());
        this.commonValidatePMML(retrieved);
    }

    private void commonLoadFile(String fileName) throws IOException, JAXBException, SAXException {
        PMML retrieved = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)fileName), (String)fileName);
        this.commonValidatePMML(retrieved);
    }

    private void commonValidatePMML(PMML toValidate) {
        Assert.assertNotNull((Object)toValidate);
        for (Model model : toValidate.getModels()) {
            Assert.assertNotNull((Object)model.getModelName());
            if (!(model instanceof MiningModel)) continue;
            this.commonValidateMiningModel((MiningModel)model);
        }
    }

    private void commonValidateMiningModel(MiningModel toValidate) {
        Assert.assertNotNull((Object)toValidate);
        for (Segment segment : toValidate.getSegmentation().getSegments()) {
            Assert.assertNotNull((Object)segment.getId());
            Model segmentModel = segment.getModel();
            Assert.assertNotNull((Object)segmentModel.getModelName());
            if (!(segmentModel instanceof MiningModel)) continue;
            this.commonValidateMiningModel((MiningModel)segmentModel);
        }
    }
}

