/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.testutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.compiler.commons.mocks.TestModel;

public class PMMLModelTestUtils {
    private PMMLModelTestUtils() {
    }

    public static PMML getPMMLWithRandomTestModel() {
        PMML toReturn = new PMML();
        DataDictionary dataDictionary = PMMLModelTestUtils.getRandomDataDictionary();
        toReturn.setDataDictionary(dataDictionary);
        toReturn.addModels(new Model[]{PMMLModelTestUtils.getRandomTestModel(dataDictionary)});
        return toReturn;
    }

    public static DataDictionary getDataDictionary(List<DataField> dataFields) {
        DataDictionary toReturn = new DataDictionary();
        toReturn.addDataFields(dataFields.toArray(new DataField[0]));
        return toReturn;
    }

    public static TransformationDictionary getTransformationDictionary() {
        TransformationDictionary toReturn = new TransformationDictionary();
        return toReturn;
    }

    public static MiningSchema getMiningSchema(List<MiningField> miningFields) {
        MiningSchema toReturn = new MiningSchema();
        toReturn.addMiningFields(miningFields.toArray(new MiningField[0]));
        return toReturn;
    }

    public static DataDictionary getRandomDataDictionary() {
        DataDictionary toReturn = new DataDictionary();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addDataFields(new DataField[]{PMMLModelTestUtils.getRandomDataField()}));
        return toReturn;
    }

    public static MiningSchema getRandomMiningSchema() {
        MiningSchema toReturn = new MiningSchema();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addMiningFields(new MiningField[]{PMMLModelTestUtils.getRandomMiningField()}));
        return toReturn;
    }

    public static Output getRandomOutput() {
        Output toReturn = new Output();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addOutputFields(new OutputField[]{PMMLModelTestUtils.getRandomOutputField()}));
        return toReturn;
    }

    public static TestModel getRandomTestModel() {
        TestModel toReturn = new TestModel();
        toReturn.setModelName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMiningSchema(PMMLModelTestUtils.getRandomMiningSchema());
        toReturn.setOutput(PMMLModelTestUtils.getRandomOutput());
        return toReturn;
    }

    public static TestModel getRandomTestModel(DataDictionary dataDictionary) {
        TestModel toReturn = new TestModel();
        List dataFields = dataDictionary.getDataFields();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, dataFields.size() - 1).forEach(i -> {
            DataField dataField = (DataField)dataFields.get(i);
            MiningField miningField = new MiningField();
            miningField.setName(dataField.getName());
            miningField.setUsageType(MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        });
        DataField lastDataField = (DataField)dataFields.get(dataFields.size() - 1);
        MiningField predictedMiningField = new MiningField();
        predictedMiningField.setName(lastDataField.getName());
        predictedMiningField.setUsageType(MiningField.UsageType.PREDICTED);
        miningSchema.addMiningFields(new MiningField[]{predictedMiningField});
        Output output = new Output();
        OutputField outputField = new OutputField();
        outputField.setName(FieldName.create((String)("OUTPUT_" + lastDataField.getName().getValue())));
        outputField.setDataType(lastDataField.getDataType());
        outputField.setOpType(OpType.values()[new Random().nextInt(OpType.values().length)]);
        toReturn.setModelName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMiningSchema(miningSchema);
        toReturn.setOutput(output);
        return toReturn;
    }

    public static RegressionModel getRegressionModel(String modelName, MiningFunction miningFunction, MiningSchema miningSchema, List<RegressionTable> regressionTables) {
        RegressionModel toReturn = new RegressionModel();
        toReturn.setModelName(modelName);
        toReturn.setMiningFunction(miningFunction);
        toReturn.setMiningSchema(miningSchema);
        toReturn.addRegressionTables(regressionTables.toArray(new RegressionTable[0]));
        return toReturn;
    }

    public static RegressionTable getRegressionTable(List<CategoricalPredictor> categoricalPredictors, List<NumericPredictor> numericPredictors, List<PredictorTerm> predictorTerms, double intercept, Object targetCategory) {
        RegressionTable toReturn = new RegressionTable();
        toReturn.setIntercept((Number)intercept);
        toReturn.setTargetCategory(targetCategory);
        toReturn.addCategoricalPredictors(categoricalPredictors.toArray(new CategoricalPredictor[0]));
        toReturn.addNumericPredictors(numericPredictors.toArray(new NumericPredictor[0]));
        toReturn.addPredictorTerms(predictorTerms.toArray(new PredictorTerm[0]));
        return toReturn;
    }

    public static CategoricalPredictor getCategoricalPredictor(String name, double value, double coefficient) {
        CategoricalPredictor toReturn = new CategoricalPredictor();
        toReturn.setField(PMMLModelTestUtils.getFieldName(name));
        toReturn.setValue((Object)value);
        toReturn.setCoefficient((Number)coefficient);
        return toReturn;
    }

    public static NumericPredictor getNumericPredictor(String name, int exponent, double coefficient) {
        NumericPredictor toReturn = new NumericPredictor();
        toReturn.setField(PMMLModelTestUtils.getFieldName(name));
        toReturn.setExponent(Integer.valueOf(exponent));
        toReturn.setCoefficient((Number)coefficient);
        return toReturn;
    }

    public static PredictorTerm getPredictorTerm(String name, double coefficient, List<String> fieldRefNames) {
        PredictorTerm toReturn = new PredictorTerm();
        toReturn.setName(PMMLModelTestUtils.getFieldName(name));
        toReturn.setCoefficient((Number)coefficient);
        toReturn.addFieldRefs((FieldRef[])fieldRefNames.stream().map(PMMLModelTestUtils::getFieldRef).toArray(FieldRef[]::new));
        return toReturn;
    }

    public static DataField getDataField(String fieldName, OpType opType) {
        DataField toReturn = new DataField();
        toReturn.setName(PMMLModelTestUtils.getFieldName(fieldName));
        toReturn.setOpType(opType);
        return toReturn;
    }

    public static DataField getDataField(String fieldName, OpType opType, DataType dataType) {
        DataField toReturn = PMMLModelTestUtils.getDataField(fieldName, opType);
        toReturn.setDataType(dataType);
        return toReturn;
    }

    public static MiningField getMiningField(String fieldName, MiningField.UsageType usageType) {
        MiningField toReturn = new MiningField();
        toReturn.setName(PMMLModelTestUtils.getFieldName(fieldName));
        toReturn.setUsageType(usageType);
        return toReturn;
    }

    public static DataField getRandomDataField() {
        DataField toReturn = new DataField();
        toReturn.setName(PMMLModelTestUtils.getFieldName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        return toReturn;
    }

    public static DataType getRandomDataType() {
        List<DataType> dataTypes = PMMLModelTestUtils.getDataTypes();
        return dataTypes.get(new Random().nextInt(dataTypes.size()));
    }

    public static MiningField getRandomMiningField() {
        Random random = new Random();
        MiningField toReturn = new MiningField();
        toReturn.setName(PMMLModelTestUtils.getFieldName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        toReturn.setUsageType(MiningField.UsageType.values()[random.nextInt(MiningField.UsageType.values().length)]);
        return toReturn;
    }

    public static OutputField getRandomOutputField() {
        Random random = new Random();
        OutputField toReturn = new OutputField();
        toReturn.setName(PMMLModelTestUtils.getFieldName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        toReturn.setOpType(OpType.values()[random.nextInt(OpType.values().length)]);
        List<DataType> dataTypes = PMMLModelTestUtils.getDataTypes();
        toReturn.setDataType(dataTypes.get(random.nextInt(dataTypes.size())));
        toReturn.setTargetField(PMMLModelTestUtils.getFieldName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false)));
        List<ResultFeature> resultFeatures = PMMLModelTestUtils.getResultFeature();
        toReturn.setResultFeature(resultFeatures.get(random.nextInt(resultFeatures.size())));
        return toReturn;
    }

    public static ParameterField getParameterField(String fieldName, DataType dataType) {
        ParameterField toReturn = new ParameterField();
        toReturn.setDataType(dataType);
        toReturn.setName(PMMLModelTestUtils.getFieldName(fieldName));
        return toReturn;
    }

    public static List<ParameterField> getParameterFields() {
        DATA_TYPE[] dataTypes = DATA_TYPE.values();
        ArrayList<ParameterField> toReturn = new ArrayList<ParameterField>();
        for (int i = 0; i < dataTypes.length; ++i) {
            DataType dataType = DataType.fromValue((String)dataTypes[i].getName());
            ParameterField toAdd = PMMLModelTestUtils.getParameterField(dataType.value().toUpperCase(), dataType);
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public static List<DataType> getDataTypes() {
        DATA_TYPE[] dataTypes = DATA_TYPE.values();
        ArrayList<DataType> toReturn = new ArrayList<DataType>();
        for (int i = 0; i < dataTypes.length; ++i) {
            toReturn.add(DataType.fromValue((String)dataTypes[i].getName()));
        }
        return toReturn;
    }

    public static List<ResultFeature> getResultFeature() {
        RESULT_FEATURE[] resultFeatures = RESULT_FEATURE.values();
        ArrayList<ResultFeature> toReturn = new ArrayList<ResultFeature>();
        for (int i = 0; i < resultFeatures.length; ++i) {
            toReturn.add(ResultFeature.fromValue((String)resultFeatures[i].getName()));
        }
        return toReturn;
    }

    public static SimplePredicate getSimplePredicate(String predicateName, Object value, SimplePredicate.Operator operator) {
        FieldName fieldName = FieldName.create((String)predicateName);
        SimplePredicate toReturn = new SimplePredicate();
        toReturn.setField(fieldName);
        toReturn.setOperator(operator);
        toReturn.setValue(value);
        return toReturn;
    }

    public static CompoundPredicate getCompoundPredicate(List<SimplePredicate> simplePredicates, int counter) {
        CompoundPredicate toReturn = new CompoundPredicate();
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomCompoundPredicateAndOrOperator(counter));
        toReturn.getPredicates().addAll(PMMLModelTestUtils.getRandomSimplePredicates(simplePredicates));
        return toReturn;
    }

    public static SimpleSetPredicate getSimpleSetPredicate(String predicateName, Array.Type arrayType, List<String> values, SimpleSetPredicate.BooleanOperator booleanOperator) {
        FieldName fieldName = FieldName.create((String)predicateName);
        SimpleSetPredicate toReturn = new SimpleSetPredicate();
        toReturn.setField(fieldName);
        toReturn.setBooleanOperator(booleanOperator);
        Array array = PMMLModelTestUtils.getArray(arrayType, values);
        toReturn.setArray(array);
        return toReturn;
    }

    public static Array getArray(Array.Type arrayType, List<String> values) {
        String arrayString = String.join((CharSequence)" ", values);
        Array toReturn = new Array(arrayType, (Object)arrayString);
        toReturn.setN(Integer.valueOf(values.size()));
        return toReturn;
    }

    public static FieldName getFieldName(String fieldName) {
        return FieldName.create((String)fieldName);
    }

    public static FieldRef getFieldRef(String fieldName) {
        return new FieldRef(PMMLModelTestUtils.getFieldName(fieldName));
    }

    public static Object getRandomValue(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return new Random().nextInt(40);
            }
            case DOUBLE: {
                return new Random().nextDouble();
            }
            case BOOLEAN: {
                return new Random().nextBoolean();
            }
            case STRING: {
                return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
            }
        }
        return null;
    }

    public static SimplePredicate.Operator getRandomSimplePredicateOperator() {
        SimplePredicate.Operator[] values = SimplePredicate.Operator.values();
        int rndIndex = new Random().nextInt(values.length - 3);
        return values[rndIndex];
    }

    public static SimpleSetPredicate.BooleanOperator getRandomSimpleSetPredicateOperator() {
        SimpleSetPredicate.BooleanOperator[] values = SimpleSetPredicate.BooleanOperator.values();
        int rndIndex = new Random().nextInt(values.length);
        return values[rndIndex];
    }

    public static List<String> getStringObjects(Array.Type arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return String.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return String.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
                }
            }
            return null;
        }).collect(Collectors.toList());
    }

    private static List<SimplePredicate> getRandomSimplePredicates(List<SimplePredicate> simplePredicates) {
        int firstIndex = new Random().nextInt(simplePredicates.size());
        int secondIndex = -1;
        while (secondIndex == -1 || secondIndex == firstIndex) {
            secondIndex = new Random().nextInt(simplePredicates.size());
        }
        return Arrays.asList(simplePredicates.get(firstIndex), simplePredicates.get(secondIndex));
    }

    private static CompoundPredicate.BooleanOperator getRandomCompoundPredicateAndOrOperator(int counter) {
        return counter % 2 == 0 ? CompoundPredicate.BooleanOperator.AND : CompoundPredicate.BooleanOperator.OR;
    }
}

