/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.DefineFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtilsTest;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class DefineFunctionUtilsTest {
    private static final Function<Supplier<Expression>, DefineFunction> defineFunctionCreator = supplier -> {
        Expression expression = (Expression)supplier.get();
        DefineFunction defineFunction = new DefineFunction();
        defineFunction.setName("DEFINE_FUNCTION_" + expression.getClass().getSimpleName());
        defineFunction.setExpression(expression);
        return defineFunction;
    };

    @Test(expected=KiePMMLException.class)
    public void getDefineFunctionsMethodMapUnsupportedExpression() {
        List defineFunctions = ExpressionFunctionUtilsTest.unsupportedExpressionSupplier.stream().map(defineFunctionCreator).collect(Collectors.toList());
        DefineFunctionUtils.getDefineFunctionsMethodMap(defineFunctions);
    }

    @Test
    public void getDefineFunctionsMethodMapSupportedExpression() {
        List defineFunctions = ExpressionFunctionUtilsTest.supportedExpressionSupplier.stream().map(defineFunctionCreator).collect(Collectors.toList());
        Map retrieved = DefineFunctionUtils.getDefineFunctionsMethodMap(defineFunctions);
        Assert.assertEquals((long)defineFunctions.size(), (long)retrieved.size());
    }

    @Test
    public void getDefineFunctionMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            DefineFunction defineFunction = defineFunctionCreator.apply(supplier);
            try {
                DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)defineFunction);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", defineFunction));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getDefineFunctionMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            DefineFunction defineFunction = defineFunctionCreator.apply(supplier);
            try {
                DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)defineFunction);
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, defineFunction.getExpression().getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getDefineFunctionMethodDeclarationWithoutExpression() {
        DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)new DefineFunction());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getExpressionMethodDeclarationUnknownExpression() {
        Expression expression = new Expression(){

            public VisitorAction accept(Visitor visitor) {
                return null;
            }
        };
        DefineFunctionUtils.getExpressionMethodDeclaration((String)"", (Expression)expression, (DataType)DataType.STRING, Collections.emptyList());
    }

    @Test
    public void getExpressionMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                DefineFunctionUtils.getExpressionMethodDeclaration((String)"", (Expression)expression, (DataType)DataType.STRING, Collections.emptyList());
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", expression.getClass()));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getExpressionMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                DefineFunctionUtils.getExpressionMethodDeclaration((String)"METHOD_NAME", (Expression)expression, (DataType)DataType.STRING, Collections.emptyList());
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, expression.getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getAggregatedMethodDeclaration() {
        DefineFunctionUtils.getAggregatedMethodDeclaration((String)"", (Aggregate)new Aggregate(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getApplyMethodDeclaration() {
        String methodName = "METHOD_NAME";
        MethodDeclaration retrieved = DefineFunctionUtils.getApplyMethodDeclaration((String)methodName, (Apply)ExpressionFunctionUtilsTest.applySupplier.get(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("java.lang.Object %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {\n    java.lang.Object variableapplyVariableConstant1 = 34.6;\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object variableapplyVariableFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);\n    return applyVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getConstantMethodDeclaration() {
        String methodName = "METHOD_NAME";
        MethodDeclaration retrieved = DefineFunctionUtils.getConstantMethodDeclaration((String)methodName, (Constant)ExpressionFunctionUtilsTest.constantSupplier.get(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.DOUBLE_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("java.lang.Double %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {\n    java.lang.Double constantVariable = 34.6;\n    return constantVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test(expected=KiePMMLException.class)
    public void getDiscretizeMethodDeclaration() {
        DefineFunctionUtils.getDiscretizeMethodDeclaration((String)"", (Discretize)new Discretize(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getFieldRefMethodDeclaration() {
        String methodName = "METHOD_NAME";
        FieldRef fieldRef = ExpressionFunctionUtilsTest.fieldRefSupplier.get();
        ParameterField parameterField = new ParameterField(FieldName.create((String)"FIELD_REF"));
        LinkedHashMap<String, ClassOrInterfaceType> modifiedParametersMap = new LinkedHashMap<String, ClassOrInterfaceType>(ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        modifiedParametersMap.put(parameterField.getName().toString(), StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName((ParameterField)parameterField)));
        MethodDeclaration retrieved = DefineFunctionUtils.getFieldRefMethodDeclaration((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.STRING_CLASS, modifiedParametersMap);
        String expected = String.format("java.lang.String %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1, java.lang.Object FIELD_REF) {\n    java.lang.String fieldRefVariable = FIELD_REF != null ? (java.lang.String) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.String.class, FIELD_REF) : (java.lang.String) null;\n    return fieldRefVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
        String mapMissingTo = "MAP_MISSING_TO";
        fieldRef.setMapMissingTo(mapMissingTo);
        retrieved = DefineFunctionUtils.getFieldRefMethodDeclaration((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)ExpressionFunctionUtilsTest.STRING_CLASS, modifiedParametersMap);
        expected = String.format("java.lang.String %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1, java.lang.Object FIELD_REF) {\n    java.lang.String fieldRefVariable = FIELD_REF != null ? (java.lang.String) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.String.class, FIELD_REF) : (java.lang.String) \"MAP_MISSING_TO\";\n    return fieldRefVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test(expected=KiePMMLException.class)
    public void getLagMethodDeclaration() {
        DefineFunctionUtils.getLagMethodDeclaration((String)"", (Lag)new Lag(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getMapValuesMethodDeclaration() {
        DefineFunctionUtils.getMapValuesMethodDeclaration((String)"", (MapValues)new MapValues(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormContinuousMethodDeclaration() {
        DefineFunctionUtils.getNormContinuousMethodDeclaration((String)"", (NormContinuous)new NormContinuous(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormDiscreteMethodDeclaration() {
        DefineFunctionUtils.getNormDiscreteMethodDeclaration((String)"", (NormDiscrete)new NormDiscrete(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getTextIndexMethodDeclaration() {
        DefineFunctionUtils.getTextIndexMethodDeclaration((String)"", (TextIndex)new TextIndex(), (ClassOrInterfaceType)ExpressionFunctionUtilsTest.OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getClassOrInterfaceTypes() {
        List<ParameterField> parameterFields = PMMLModelTestUtils.getParameterFields();
        LinkedHashMap retrieved = DefineFunctionUtils.getNameClassOrInterfaceTypeMap(parameterFields);
        Assert.assertEquals((long)parameterFields.size(), (long)retrieved.size());
        for (ParameterField parameter : parameterFields) {
            Assert.assertTrue((boolean)retrieved.containsKey(parameter.getName().toString()));
            this.commonVerifyParameterClassOrInterfaceType((ClassOrInterfaceType)retrieved.get(parameter.getName().toString()), parameter);
        }
    }

    private void commonVerifyParameterClassOrInterfaceType(ClassOrInterfaceType toVerify, ParameterField parameterField) {
        String expectedClass = ModelUtils.getBoxedClassName((ParameterField)parameterField);
        Assert.assertEquals((Object)expectedClass, (Object)toVerify.toString());
    }
}

