/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.ConverterTypeUtil;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class ExpressionFunctionUtilsTest {
    static final List<Supplier<Expression>> supportedExpressionSupplier;
    static final List<Supplier<Expression>> unsupportedExpressionSupplier;
    static final Supplier<Constant> constantSupplier;
    static final Supplier<FieldRef> fieldRefSupplier;
    static final Supplier<Apply> applySupplier;
    static final ClassOrInterfaceType OBJECT_CLASS;
    static final ClassOrInterfaceType DOUBLE_CLASS;
    static final ClassOrInterfaceType STRING_CLASS;

    @Test
    public void converterTypeUtilFieldAccessorExpr() {
        Assert.assertEquals((Object)ConverterTypeUtil.class.getName(), (Object)ExpressionFunctionUtils.CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.toString());
    }

    @Test(expected=KiePMMLException.class)
    public void getAggregatedExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getAggregatedExpressionMethodDeclaration((String)"", (Aggregate)new Aggregate(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getApplyExpressionMethodDeclaration() {
        Apply apply = applySupplier.get();
        int methodArity = new Random().nextInt(20);
        String methodName = String.format("%s%s", apply.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getApplyExpressionMethodDeclaration((String)methodName, (Apply)apply, (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("java.lang.Object %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {\n    java.lang.Object variableapplyVariableConstant1 = 34.6;\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object variableapplyVariableFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);\n    return applyVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
        ParameterField parameterField = new ParameterField(FieldName.create((String)"FIELD_REF"));
        LinkedHashMap<String, ClassOrInterfaceType> modifiedParametersMap = new LinkedHashMap<String, ClassOrInterfaceType>(ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        modifiedParametersMap.put(parameterField.getName().toString(), StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName((ParameterField)parameterField)));
        retrieved = ExpressionFunctionUtils.getApplyExpressionMethodDeclaration((String)methodName, (Apply)apply, (ClassOrInterfaceType)OBJECT_CLASS, modifiedParametersMap);
        expected = String.format("java.lang.Object %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1, java.lang.Object FIELD_REF) {\n    java.lang.Object variableapplyVariableConstant1 = 34.6;\n    java.lang.Object variableapplyVariableFieldRef2 = FIELD_REF != null ? (java.lang.Object) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.Object.class, FIELD_REF) : (java.lang.Object) null;\n    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);\n    return applyVariable;\n}", methodName);
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getConstantExpressionMethodDeclaration() {
        Constant constant = constantSupplier.get();
        int methodArity = new Random().nextInt(20);
        String methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getConstantExpressionMethodDeclaration((String)methodName, (Constant)constant, (ClassOrInterfaceType)DOUBLE_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expectedVariableDeclaration = String.format("%1$s constantVariable = %2$s;", Double.class.getName(), constant.getValue());
        this.commonValidateConstant(retrieved, constant, methodName, Double.class.getName(), expectedVariableDeclaration);
        constant = new Constant();
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"EXPECTED");
        methodArity = new Random().nextInt(20);
        methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        retrieved = ExpressionFunctionUtils.getConstantExpressionMethodDeclaration((String)methodName, (Constant)constant, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expectedVariableDeclaration = String.format("%1$s constantVariable = \"%2$s\";", String.class.getName(), constant.getValue());
        this.commonValidateConstant(retrieved, constant, methodName, String.class.getName(), expectedVariableDeclaration);
    }

    @Test(expected=KiePMMLException.class)
    public void getDiscretizeExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getDiscretizeExpressionMethodDeclaration((String)"", (Discretize)new Discretize(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getFieldRefExpressionMethodDeclaration() {
        int methodArity = new Random().nextInt(20);
        FieldRef fieldRef = fieldRefSupplier.get();
        String methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("java.lang.String fieldRefVariable = (java.lang.String) kiePMMLNameValue.map(%1$s::getValue).orElse(%2$s);", KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRefMethod(retrieved, methodName, expected, String.class.getName());
        fieldRef.setMapMissingTo("MAP_MISSING_TO");
        methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expected = String.format("java.lang.String fieldRefVariable = (java.lang.String) kiePMMLNameValue.map(%1$s::getValue).orElse(\"%2$s\");", KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRefMethod(retrieved, methodName, expected, String.class.getName());
    }

    @Test(expected=KiePMMLException.class)
    public void getLagExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getLagExpressionMethodDeclaration((String)"methodName", (Lag)new Lag(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getMapValuesExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getMapValuesExpressionMethodDeclaration((String)"methodName", (MapValues)new MapValues(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormContinuousExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getNormContinuousExpressionMethodDeclaration((String)"methodName", (NormContinuous)new NormContinuous(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormDiscreteExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getNormDiscreteExpressionMethodDeclaration((String)"methodName", (NormDiscrete)new NormDiscrete(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getTextIndexExpressionMethodDeclaration() {
        ExpressionFunctionUtils.getTextIndexExpressionMethodDeclaration((String)"methodName", (TextIndex)new TextIndex(), (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getExpressionBlockStmtUnsupportedExpression() {
        for (Supplier<Expression> supplier : unsupportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                ExpressionFunctionUtils.getExpressionBlockStmt((String)"variableName", (Expression)expression, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", expression.getClass()));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getExpressionBlockStmtSupportedExpression() {
        for (Supplier<Expression> supplier : supportedExpressionSupplier) {
            Expression expression = supplier.get();
            try {
                ExpressionFunctionUtils.getExpressionBlockStmt((String)"variableName", (Expression)expression, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, expression.getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getAggregatedExpressionBlockStmt() {
        ExpressionFunctionUtils.getAggregatedExpressionBlockStmt((String)"variableName", (Aggregate)new Aggregate(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getApplyExpressionBlockStmt() {
        Apply apply = applySupplier.get();
        String variableName = "VARIABLE_NAME";
        BlockStmt retrieved = ExpressionFunctionUtils.getApplyExpressionBlockStmt((String)variableName, (Apply)apply, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = "{\n    java.lang.Object variableVARIABLE_NAMEConstant1 = 34.6;\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object variableVARIABLE_NAMEFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n    java.lang.Object VARIABLE_NAME = this.FUNCTION_NAME(param1, variableVARIABLE_NAMEConstant1, variableVARIABLE_NAMEFieldRef2);\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getApplyExpressionNestedBlockStmt() {
        Apply nestedApply = applySupplier.get();
        Constant constant = new Constant();
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"STRING_VALUE");
        String functionName = "EXTERNAL_FUNCTION_NAME";
        Apply apply = new Apply();
        apply.addExpressions(new Expression[]{constant, nestedApply});
        apply.setFunction(functionName);
        String variableName = "VARIABLE_NAME";
        BlockStmt retrieved = ExpressionFunctionUtils.getApplyExpressionBlockStmt((String)variableName, (Apply)apply, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = "{\n    java.lang.Object variableVARIABLE_NAMEConstant1 = \"STRING_VALUE\";\n    java.lang.Object variablevariableVARIABLE_NAMEApply2Constant1 = 34.6;\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object variablevariableVARIABLE_NAMEApply2FieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n    java.lang.Object variableVARIABLE_NAMEApply2 = this.FUNCTION_NAME(param1, variablevariableVARIABLE_NAMEApply2Constant1, variablevariableVARIABLE_NAMEApply2FieldRef2);\n    java.lang.Object VARIABLE_NAME = this.EXTERNAL_FUNCTION_NAME(param1, variableVARIABLE_NAMEConstant1, variableVARIABLE_NAMEApply2);\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getConstantExpressionBlockStmt() {
        String variableName = "VARIABLE_NAME";
        Constant constant = constantSupplier.get();
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Double.class.getName());
        BlockStmt retrieved = ExpressionFunctionUtils.getConstantExpressionBlockStmt((String)variableName, (Constant)constant, (ClassOrInterfaceType)returnedType, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("{\n    %1$s %2$s = %3$s;\n}", Double.class.getName(), variableName, constant.getValue());
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"STRING_VALUE");
        returnedType = StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName());
        retrieved = ExpressionFunctionUtils.getConstantExpressionBlockStmt((String)variableName, (Constant)constant, (ClassOrInterfaceType)returnedType, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expected = String.format("{\n    %1$s %2$s = \"%3$s\";\n}", String.class.getName(), variableName, constant.getValue());
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test(expected=KiePMMLException.class)
    public void getDiscretizeExpressionBlockStmt() {
        ExpressionFunctionUtils.getDiscretizeExpressionBlockStmt((String)"variableName", (Discretize)new Discretize(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getFieldRefExpressionFromCommonDataBlockStmt() {
        String variableName = "VARIABLE_NAME";
        FieldRef fieldRef = fieldRefSupplier.get();
        BlockStmt retrieved = ExpressionFunctionUtils.getFieldRefExpressionFromCommonDataBlockStmt((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = "{\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object VARIABLE_NAME = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
        String mapMissingTo = "MAP_MISSING_TO";
        fieldRef.setMapMissingTo(mapMissingTo);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionFromCommonDataBlockStmt((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expected = "{\n    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((org.kie.pmml.commons.model.tuples.KiePMMLNameValue lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();\n    java.lang.Object VARIABLE_NAME = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(\"MAP_MISSING_TO\");\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getFieldRefExpressionFromDefineFunctionBlockStmt() {
        String variableName = "VARIABLE_NAME";
        FieldRef fieldRef = fieldRefSupplier.get();
        ParameterField parameterField = new ParameterField(FieldName.create((String)"FIELD_REF"));
        LinkedHashMap<String, ClassOrInterfaceType> modifiedParametersMap = new LinkedHashMap<String, ClassOrInterfaceType>(ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        modifiedParametersMap.put(parameterField.getName().toString(), StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName((ParameterField)parameterField)));
        BlockStmt retrieved = ExpressionFunctionUtils.getFieldRefExpressionFromDefineFunctionBlockStmt((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), modifiedParametersMap);
        String expected = "{\n    java.lang.Object VARIABLE_NAME = FIELD_REF != null ? (java.lang.Object) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.Object.class, FIELD_REF) : (java.lang.Object) null;\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
        String mapMissingTo = "MAP_MISSING_TO";
        fieldRef.setMapMissingTo(mapMissingTo);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionFromDefineFunctionBlockStmt((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), modifiedParametersMap);
        expected = "{\n    java.lang.Object VARIABLE_NAME = FIELD_REF != null ? (java.lang.Object) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.Object.class, FIELD_REF) : (java.lang.Object) \"MAP_MISSING_TO\";\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test(expected=KiePMMLException.class)
    public void getLagExpressionBlockStmt() {
        ExpressionFunctionUtils.getLagExpressionBlockStmt((String)"variableName", (Lag)new Lag(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getMapValuesExpressionBlockStmt() {
        ExpressionFunctionUtils.getMapValuesExpressionBlockStmt((String)"variableName", (MapValues)new MapValues(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormContinuousExpressionBlockStmtn() {
        ExpressionFunctionUtils.getNormContinuousExpressionBlockStmt((String)"variableName", (NormContinuous)new NormContinuous(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getNormDiscreteExpressionBlockStmt() {
        ExpressionFunctionUtils.getNormDiscreteExpressionBlockStmt((String)"variableName", (NormDiscrete)new NormDiscrete(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getTextIndexExpressionBlockStmt() {
        ExpressionFunctionUtils.getTextIndexExpressionBlockStmt((String)"variableName", (TextIndex)new TextIndex(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
    }

    @Test
    public void getExpressionMethodDeclaration() {
        String methodName = "METHOD_NAME";
        String variableName = "VARIABLE_NAME";
        MethodDeclaration retrieved = ExpressionFunctionUtils.getExpressionMethodDeclaration((String)methodName, (String)variableName, (BlockStmt)new BlockStmt(), (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        Assert.assertNotNull((Object)retrieved);
        String expected = "java.lang.Object METHOD_NAME(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {\n    return VARIABLE_NAME;\n}";
        expected = expected.replace("\n", System.lineSeparator());
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    private void commonValidateConstant(MethodDeclaration retrieved, Constant constant, String expectedMethodName, String expectedClass, String variableDeclaration) {
        this.commonValidateMethodDeclaration(retrieved, expectedMethodName);
        Assert.assertEquals((Object)expectedClass, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)2L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(0) instanceof ExpressionStmt));
        Assert.assertEquals((Object)variableDeclaration, (Object)((Statement)statements.get(0)).toString());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(1);
        String retrievedString = returnStmt.toString();
        Assert.assertEquals((Object)"return constantVariable;", (Object)retrievedString);
        CodegenTestUtils.commonValidateCompilation(retrieved);
    }

    private void commonValidateFieldRefMethod(MethodDeclaration retrieved, String expectedMethodName, String expectedVariableAssignment, String expectedType) {
        this.commonValidateMethodDeclaration(retrieved, expectedMethodName);
        Assert.assertEquals((Object)expectedType, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ExpressionStmt));
        Assert.assertEquals((Object)expectedVariableAssignment, (Object)((Statement)statements.get(1)).toString());
        Assert.assertTrue((boolean)(statements.get(2) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(2);
        String retrievedString = returnStmt.toString();
        Assert.assertEquals((Object)"return fieldRefVariable;", (Object)retrievedString);
        CodegenTestUtils.commonValidateCompilation(retrieved);
    }

    private void commonValidateMethodDeclaration(MethodDeclaration toValidate, String expectedMethodName) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertEquals((Object)toValidate.getName().asString(), (Object)expectedMethodName);
    }

    static {
        constantSupplier = () -> {
            Constant toReturn = new Constant();
            toReturn.setDataType(DataType.DOUBLE);
            toReturn.setValue((Object)34.6);
            return toReturn;
        };
        fieldRefSupplier = () -> new FieldRef(FieldName.create((String)"FIELD_REF"));
        applySupplier = () -> {
            Constant constant = constantSupplier.get();
            FieldRef fieldRef = fieldRefSupplier.get();
            String functionName = "FUNCTION_NAME";
            Apply toReturn = new Apply();
            toReturn.addExpressions(new Expression[]{constant, fieldRef});
            toReturn.setFunction(functionName);
            return toReturn;
        };
        OBJECT_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        DOUBLE_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)Double.class.getName());
        STRING_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName());
        supportedExpressionSupplier = new ArrayList<Supplier<Expression>>();
        supportedExpressionSupplier.add(applySupplier::get);
        supportedExpressionSupplier.add(constantSupplier::get);
        supportedExpressionSupplier.add(fieldRefSupplier::get);
        unsupportedExpressionSupplier = new ArrayList<Supplier<Expression>>();
        unsupportedExpressionSupplier.add(Aggregate::new);
        unsupportedExpressionSupplier.add(Discretize::new);
        unsupportedExpressionSupplier.add(Lag::new);
        unsupportedExpressionSupplier.add(MapValues::new);
        unsupportedExpressionSupplier.add(NormContinuous::new);
        unsupportedExpressionSupplier.add(NormDiscrete::new);
        unsupportedExpressionSupplier.add(TextIndex::new);
    }
}

