/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.compiler.commons.factories.KiePMMLCompoundPredicateFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactoryTest;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLCompoundPredicateFactoryTest {
    private static final String SOURCE = "TreeSample.pmml";
    private static PMML pmmlModel;
    private static TreeModel model;
    private static DataDictionary pmmlDataDictionary;
    private static List<DerivedField> derivedFields;

    @Before
    public void setUp() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        pmmlDataDictionary = pmmlModel.getDataDictionary();
        Assert.assertNotNull((Object)pmmlDataDictionary);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
        derivedFields = ModelUtils.getDerivedFields((TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
    }

    @Test
    public void getCompoundSimplePredicateRefPredicatesBody() {
        CompoundPredicate predicate = (CompoundPredicate)KiePMMLPredicateFactoryTest.getNodeById(model, "A_A_A").getPredicate();
        ArrayList<MethodDeclaration> compoundPredicateMethods = new ArrayList<MethodDeclaration>();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLCompoundPredicateFactory.getCompoundPredicateBody((CompoundPredicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Boolean toReturn = null;\n    final List<Function<Map<String, Object>, Boolean>> functions = java.util.Arrays.asList(rootNodeClassName::evaluateNestedPredicatenodeClassName1, rootNodeClassName::evaluateNestedPredicatenodeClassName2);\n    for (Function<Map<String, Object>, Boolean> function : functions) {\n        Boolean evaluation = function.apply(stringObjectMap);\n        // generated\n        toReturn = toReturn != null ? toReturn && evaluation : evaluation;\n    }\n    return toReturn != null && toReturn;\n}");
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        this.commonValidateBlockStmt(retrieved, compoundPredicateMethods, "rootNodeClassName", predicate.getPredicates().size());
    }

    @Test
    public void getCompoundSimplePredicateNoRefPredicatesBody() {
        CompoundPredicate predicate = (CompoundPredicate)KiePMMLPredicateFactoryTest.getNodeById(model, "A_B").getPredicate();
        ArrayList<MethodDeclaration> compoundPredicateMethods = new ArrayList<MethodDeclaration>();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLCompoundPredicateFactory.getCompoundPredicateBody((CompoundPredicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Boolean toReturn = null;\n    final List<Function<Map<String, Object>, Boolean>> functions = java.util.Arrays.asList(rootNodeClassName::evaluateNestedPredicatenodeClassName1, rootNodeClassName::evaluateNestedPredicatenodeClassName2);\n    for (Function<Map<String, Object>, Boolean> function : functions) {\n        Boolean evaluation = function.apply(stringObjectMap);\n        // generated\n        toReturn = toReturn != null ? toReturn || evaluation : evaluation;\n    }\n    return toReturn != null && toReturn;\n}");
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        this.commonValidateBlockStmt(retrieved, compoundPredicateMethods, "rootNodeClassName", predicate.getPredicates().size());
    }

    @Test
    public void getCompoundPredicateMixPredicatesBody() {
        CompoundPredicate predicate = (CompoundPredicate)KiePMMLPredicateFactoryTest.getNodeById(model, "A_B_A").getPredicate();
        ArrayList<MethodDeclaration> compoundPredicateMethods = new ArrayList<MethodDeclaration>();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLCompoundPredicateFactory.getCompoundPredicateBody((CompoundPredicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Boolean toReturn = null;\n    final List<Function<Map<String, Object>, Boolean>> functions = java.util.Arrays.asList(rootNodeClassName::evaluateNestedPredicatenodeClassName1, rootNodeClassName::evaluateNestedPredicatenodeClassName2, rootNodeClassName::evaluateNestedPredicatenodeClassName3, rootNodeClassName::evaluateNestedPredicatenodeClassName4, rootNodeClassName::evaluateNestedPredicatenodeClassName5);\n    for (Function<Map<String, Object>, Boolean> function : functions) {\n        Boolean evaluation = function.apply(stringObjectMap);\n        // generated\n        toReturn = toReturn != null ? toReturn && evaluation : evaluation;\n    }\n    return toReturn != null && toReturn;\n}");
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        this.commonValidateBlockStmt(retrieved, compoundPredicateMethods, "rootNodeClassName", predicate.getPredicates().size());
    }

    private void commonValidateBlockStmt(BlockStmt retrieved, List<MethodDeclaration> compoundPredicateMethods, String rootNodeClassName, int expectedSize) {
        Optional optVar = CommonCodegenUtils.getVariableDeclarator((BlockStmt)retrieved, (String)"functions");
        Assert.assertTrue((boolean)optVar.isPresent());
        VariableDeclarator variableDeclarator = (VariableDeclarator)optVar.get();
        Optional optInit = variableDeclarator.getInitializer();
        Assert.assertTrue((boolean)optInit.isPresent());
        MethodCallExpr methodCallExpr = (MethodCallExpr)optInit.get();
        NodeList arguments = methodCallExpr.getArguments();
        Assert.assertEquals((long)expectedSize, (long)arguments.size());
        Assert.assertEquals((long)arguments.size(), (long)compoundPredicateMethods.size());
        arguments.forEach(expression -> {
            Assert.assertTrue((boolean)(expression instanceof MethodReferenceExpr));
            MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)expression;
            Assert.assertEquals((Object)rootNodeClassName, (Object)methodReferenceExpr.getScope().toString());
            String identifier = methodReferenceExpr.getIdentifier();
            Assert.assertTrue((boolean)compoundPredicateMethods.stream().anyMatch(methodDeclaration -> identifier.equals(methodDeclaration.getName().asString())));
        });
    }
}

