/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLPredicateFactoryTest {
    private static final String SOURCE = "TreeSample.pmml";
    private static PMML pmmlModel;
    private static TreeModel model;
    private static DataDictionary pmmlDataDictionary;
    private static List<DerivedField> derivedFields;
    private static Map<String, DataType> simplePredicateNameType;
    private static List<SimplePredicate> simplePredicates;
    private static Map<String, Array.Type> simpleSetPredicateNameType;
    private static List<SimpleSetPredicate> simpleSetPredicates;
    private static DataDictionary dataDictionary;
    private ConstructorDeclaration constructorDeclaration;
    private ExplicitConstructorInvocationStmt superInvocation;
    private List<AssignExpr> assignExprs;

    @BeforeClass
    public static void setup() throws Exception {
        simplePredicateNameType = new HashMap<String, DataType>();
        simplePredicateNameType.put("age", DataType.INTEGER);
        simplePredicateNameType.put("weight", DataType.DOUBLE);
        simplePredicateNameType.put("name", DataType.STRING);
        simplePredicateNameType.put("runner", DataType.BOOLEAN);
        simplePredicates = simplePredicateNameType.entrySet().stream().map(entry -> PMMLModelTestUtils.getSimplePredicate((String)entry.getKey(), PMMLModelTestUtils.getRandomValue((DataType)entry.getValue()), PMMLModelTestUtils.getRandomSimplePredicateOperator())).collect(Collectors.toList());
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        simplePredicateNameType.forEach((name, dataType) -> {
            DataField toAdd = new DataField();
            toAdd.setName(FieldName.create((String)name));
            toAdd.setDataType(dataType);
            dataFields.add(toAdd);
        });
        dataDictionary = PMMLModelTestUtils.getDataDictionary(dataFields);
        simpleSetPredicateNameType = new HashMap<String, Array.Type>();
        simpleSetPredicateNameType.put("age", Array.Type.INT);
        simpleSetPredicateNameType.put("weight", Array.Type.REAL);
        simpleSetPredicateNameType.put("name", Array.Type.STRING);
        simpleSetPredicates = simpleSetPredicateNameType.entrySet().stream().map(entry -> {
            List<String> values = PMMLModelTestUtils.getStringObjects((Array.Type)entry.getValue(), 4);
            return PMMLModelTestUtils.getSimpleSetPredicate((String)entry.getKey(), (Array.Type)entry.getValue(), values, PMMLModelTestUtils.getRandomSimpleSetPredicateOperator());
        }).collect(Collectors.toList());
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        pmmlDataDictionary = pmmlModel.getDataDictionary();
        Assert.assertNotNull((Object)pmmlDataDictionary);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
        derivedFields = ModelUtils.getDerivedFields((TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
    }

    @Test
    public void getPredicates() {
        ArrayList<SimplePredicate> predicates = new ArrayList<SimplePredicate>(simplePredicates);
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        predicates.add((SimplePredicate)compoundPredicate);
        True truePredicate = new True();
        predicates.add((SimplePredicate)truePredicate);
        False falsePredicate = new False();
        predicates.add((SimplePredicate)falsePredicate);
        List retrieved = KiePMMLPredicateFactory.getPredicates(predicates, (DataDictionary)dataDictionary);
        Assert.assertEquals((long)predicates.size(), (long)retrieved.size());
    }

    @Test
    public void getPredicateSimple() {
        simplePredicates.forEach(simplePredicate -> {
            KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)simplePredicate, (DataDictionary)dataDictionary);
            Assert.assertTrue((boolean)(retrieved instanceof KiePMMLSimplePredicate));
        });
    }

    @Test
    public void getPredicateSimpleSet() {
        simpleSetPredicates.forEach(simpleSetPredicate -> {
            KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)simpleSetPredicate, (DataDictionary)dataDictionary);
            Assert.assertTrue((boolean)(retrieved instanceof KiePMMLSimpleSetPredicate));
        });
    }

    @Test
    public void getPredicateCompound() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        compoundPredicate.getPredicates().addAll(simpleSetPredicates);
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)compoundPredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLCompoundPredicate));
    }

    @Test
    public void getPredicateTrue() {
        True truePredicate = new True();
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)truePredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLTruePredicate));
    }

    @Test
    public void getPredicateFalse() {
        False falsePredicate = new False();
        KiePMMLPredicate retrieved = KiePMMLPredicateFactory.getPredicate((Predicate)falsePredicate, (DataDictionary)dataDictionary);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLFalsePredicate));
    }

    @Test(expected=KiePMMLException.class)
    public void getPredicateUnknown() {
        Predicate unknownPredicate = new Predicate(){

            public VisitorAction accept(Visitor visitor) {
                return null;
            }
        };
        KiePMMLPredicateFactory.getPredicate((Predicate)unknownPredicate, (DataDictionary)dataDictionary);
    }

    @Test
    public void getKiePMMLSimpleSetPredicate() {
        simpleSetPredicates.forEach(simpleSetPredicate -> {
            KiePMMLSimpleSetPredicate retrieved = KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicate((SimpleSetPredicate)simpleSetPredicate);
            this.commonVerifySimpleSetPredicate(retrieved, null);
        });
    }

    @Test
    public void getKiePMMLCompoundPredicate() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        KiePMMLCompoundPredicate retrieved = KiePMMLPredicateFactory.getKiePMMLCompoundPredicate((CompoundPredicate)compoundPredicate, (DataDictionary)dataDictionary);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.XOR, (Object)retrieved.getBooleanOperator());
        Assert.assertEquals((long)simplePredicates.size(), (long)retrieved.getKiePMMLPredicates().size());
        retrieved.getKiePMMLPredicates().forEach(simplePredicate -> this.commonVerifySimplePredicate((KiePMMLSimplePredicate)simplePredicate, retrieved.getId()));
    }

    @Test
    public void getKiePMMLTruePredicate() {
        KiePMMLTruePredicate retrieved = KiePMMLPredicateFactory.getKiePMMLTruePredicate();
        Assert.assertNotNull((Object)retrieved);
        KiePMMLTruePredicate expected = (KiePMMLTruePredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        Assert.assertEquals((Object)expected.getName(), (Object)retrieved.getName());
        Assert.assertNotEquals((Object)expected.getId(), (Object)retrieved.getId());
    }

    @Test
    public void getKiePMMLFalsePredicate() {
        KiePMMLFalsePredicate retrieved = KiePMMLPredicateFactory.getKiePMMLFalsePredicate();
        Assert.assertNotNull((Object)retrieved);
        KiePMMLFalsePredicate expected = (KiePMMLFalsePredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        Assert.assertEquals((Object)expected.getName(), (Object)retrieved.getName());
        Assert.assertNotEquals((Object)expected.getId(), (Object)retrieved.getId());
    }

    @Test
    public void getSimplePredicateNoRefPredicateBody() {
        Predicate predicate = KiePMMLPredicateFactoryTest.getNodeById(model, "A_A").getPredicate();
        ArrayList compoundPredicateMethods = new ArrayList();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLPredicateFactory.getPredicateBody((Predicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Object value = \"sunny\";\n    if (stringObjectMap.containsKey(\"outlook\")) {\n        return value.equals(stringObjectMap.get(\"outlook\"));\n    } else {\n        return false;\n    }\n}");
        JavaParserUtils.equalsNode((com.github.javaparser.ast.Node)expected, (com.github.javaparser.ast.Node)retrieved);
        Assert.assertTrue((boolean)compoundPredicateMethods.isEmpty());
    }

    @Test
    public void getSimplePredicateRefPredicateBody() {
        Predicate predicate = KiePMMLPredicateFactoryTest.getNodeById(model, "A_A_A_A").getPredicate();
        ArrayList compoundPredicateMethods = new ArrayList();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLPredicateFactory.getPredicateBody((Predicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Object inputValue = null;\n    Object value = 80.0;\n    if (stringObjectMap.containsKey(\"HumidityRef\")) {\n        inputValue = stringObjectMap.get(\"HumidityRef\");\n    } else {\n        return false;\n    }\n    if (inputValue instanceof Number && value instanceof Number) {\n        return ((Number) inputValue).doubleValue() < ((Number) value).doubleValue();\n    } else {\n        return false;\n    }\n}");
        JavaParserUtils.equalsNode((com.github.javaparser.ast.Node)expected, (com.github.javaparser.ast.Node)retrieved);
        Assert.assertTrue((boolean)compoundPredicateMethods.isEmpty());
    }

    @Test
    public void getSimpleSetPredicatePredicateBody() {
        Predicate predicate = KiePMMLPredicateFactoryTest.getNodeById(model, "A_A_B").getPredicate();
        ArrayList compoundPredicateMethods = new ArrayList();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLPredicateFactory.getPredicateBody((Predicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    org.kie.pmml.api.enums.ARRAY_TYPE arrayType = org.kie.pmml.api.enums.ARRAY_TYPE.STRING;\n    if (!stringObjectMap.containsKey(\"occupation\")) {\n        return false;\n    }\n    final String stringValue = (String) org.kie.pmml.api.utils.ConverterTypeUtil.convert(String.class, stringObjectMap.get(\"occupation\"));\n    final Object value = arrayType.getValue(stringValue);\n    final List values = java.util.Arrays.asList(\"SKYDIVER\", \"ASTRONAUT\");\n    return values.contains(value);\n}");
        JavaParserUtils.equalsNode((com.github.javaparser.ast.Node)expected, (com.github.javaparser.ast.Node)retrieved);
        Assert.assertTrue((boolean)compoundPredicateMethods.isEmpty());
    }

    @Test
    public void getCompoundPredicatePredicateBody() {
        Predicate predicate = KiePMMLPredicateFactoryTest.getNodeById(model, "A_B_A").getPredicate();
        ArrayList compoundPredicateMethods = new ArrayList();
        String rootNodeClassName = "rootNodeClassName";
        String nodeClassName = "nodeClassName";
        AtomicInteger counter = new AtomicInteger();
        BlockStmt retrieved = KiePMMLPredicateFactory.getPredicateBody((Predicate)predicate, (DataDictionary)pmmlDataDictionary, derivedFields, compoundPredicateMethods, (String)"rootNodeClassName", (String)"nodeClassName", (AtomicInteger)counter);
        Assert.assertNotNull((Object)retrieved);
        BlockStmt expected = JavaParserUtils.parseBlock((String)"{\n    Boolean toReturn = null;\n    final List<Function<Map<String, Object>, Boolean>> functions = java.util.Arrays.asList(rootNodeClassName::evaluateNestedPredicatenodeClassName1, rootNodeClassName::evaluateNestedPredicatenodeClassName2, rootNodeClassName::evaluateNestedPredicatenodeClassName3, rootNodeClassName::evaluateNestedPredicatenodeClassName4, rootNodeClassName::evaluateNestedPredicatenodeClassName5);\n    for (Function<Map<String, Object>, Boolean> function : functions) {\n        Boolean evaluation = function.apply(stringObjectMap);\n        // generated\n        toReturn = toReturn != null ? toReturn && evaluation : evaluation;\n    }\n    return toReturn != null && toReturn;\n}");
        JavaParserUtils.equalsNode((com.github.javaparser.ast.Node)expected, (com.github.javaparser.ast.Node)retrieved);
        Optional optVar = CommonCodegenUtils.getVariableDeclarator((BlockStmt)retrieved, (String)"functions");
        Assert.assertTrue((boolean)optVar.isPresent());
        VariableDeclarator variableDeclarator = (VariableDeclarator)optVar.get();
        Optional optInit = variableDeclarator.getInitializer();
        Assert.assertTrue((boolean)optInit.isPresent());
        MethodCallExpr methodCallExpr = (MethodCallExpr)optInit.get();
        NodeList arguments = methodCallExpr.getArguments();
        Assert.assertEquals((long)5L, (long)arguments.size());
        Assert.assertEquals((long)arguments.size(), (long)compoundPredicateMethods.size());
        arguments.forEach(expression -> {
            Assert.assertTrue((boolean)(expression instanceof MethodReferenceExpr));
            MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)expression;
            Assert.assertEquals((Object)"rootNodeClassName", (Object)methodReferenceExpr.getScope().toString());
            String identifier = methodReferenceExpr.getIdentifier();
            Assert.assertTrue((boolean)compoundPredicateMethods.stream().anyMatch(methodDeclaration -> identifier.equals(methodDeclaration.getName().asString())));
        });
    }

    @Test
    public void getPredicateSourcesMap() {
        String packageName = "PACKAGENAME";
        String predicateName = "PREDICATENAME";
        KiePMMLPredicate kiePMMLPredicate = (KiePMMLPredicate)KiePMMLSimplePredicate.builder((String)predicateName, Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        Map retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.OR).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
        kiePMMLPredicate = (KiePMMLPredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        retrieved = KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)kiePMMLPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLPredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLSimpleSetPredicateSourcesMap() {
        String predicateName = "PREDICATENAME";
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)predicateName, Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicateSourcesMap((KiePMMLSimpleSetPredicate)kiePMMLSimpleSetPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLSimpleSetPredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLCompoundPredicateSourcesMap() {
        KiePMMLSimplePredicate kiePMMLSimplePredicateInt = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATEINTNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        KiePMMLSimplePredicate kiePMMLSimplePredicateString = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATESTRINGNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)"FOR").build();
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATE", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        List<KiePMMLPredicate> kiePMMLPredicates = Arrays.asList(kiePMMLSimplePredicateInt, kiePMMLSimplePredicateString, kiePMMLSimpleSetPredicate);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.OR).withKiePMMLPredicates(kiePMMLPredicates).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLCompoundPredicateSourcesMap((KiePMMLCompoundPredicate)kiePMMLCompoundPredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLCompoundPredicate.getId()), 4);
    }

    @Test
    public void getKiePMMLCompoundPredicateWithSurrogateSourcesMap() {
        KiePMMLSimplePredicate kiePMMLSimplePredicateInt = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATEINTNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)24).build();
        KiePMMLSimplePredicate kiePMMLSimplePredicateString = (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATESTRINGNAME", Collections.emptyList(), (OPERATOR)OPERATOR.GREATER_OR_EQUAL).withValue((Object)"FOR").build();
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATE", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
        List<KiePMMLPredicate> kiePMMLPredicates = Arrays.asList(kiePMMLSimplePredicateInt, kiePMMLSimplePredicateString, kiePMMLSimpleSetPredicate);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.SURROGATE).withKiePMMLPredicates(kiePMMLPredicates).build();
        KiePMMLPredicateFactory.getKiePMMLCompoundPredicateSourcesMap((KiePMMLCompoundPredicate)kiePMMLCompoundPredicate, (String)"PACKAGENAME");
    }

    @Test
    public void getKiePMMLTruePredicateSourcesMap() {
        KiePMMLTruePredicate kiePMMLTruePredicate = (KiePMMLTruePredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLTruePredicateSourcesMap((KiePMMLTruePredicate)kiePMMLTruePredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLTruePredicate.getId()), 1);
    }

    @Test
    public void getKiePMMLFalsePredicateSourcesMap() {
        KiePMMLFalsePredicate kiePMMLFalsePredicate = (KiePMMLFalsePredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
        String packageName = "PACKAGENAME";
        Map retrieved = KiePMMLPredicateFactory.getKiePMMLFalsePredicateSourcesMap((KiePMMLFalsePredicate)kiePMMLFalsePredicate, (String)packageName);
        this.commonVerifySourceMap(retrieved, packageName, KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLFalsePredicate.getId()), 1);
    }

    @Test
    public void setSimpleSetPredicateConstructor() {
        this.init("KiePMMLSimpleSetPredicateTemplate.tmpl", "KiePMMLSimpleSetPredicateTemplate");
        AssignExpr valueAssignExpr = this.assignExprs.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().getNameAsString().equals("values")).findFirst().orElseThrow(() -> new RuntimeException("Missing \"values\" assign variable"));
        Assert.assertTrue((boolean)(valueAssignExpr.getValue() instanceof NullLiteralExpr));
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        IN_NOTIN inNotIn = IN_NOTIN.IN;
        List<Object> values = this.getObjects(arrayType, 3);
        KiePMMLPredicateFactory.setSimpleSetPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn, values);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(arrayType.getClass().getCanonicalName() + "." + arrayType.name()));
        superInvocationExpressionsMap.put(3, (Expression)new NameExpr(inNotIn.getClass().getCanonicalName() + "." + inNotIn.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("values", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
        List methodCallExprs = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExpressionStmt).map(statement -> (ExpressionStmt)statement).filter(expressionStmt -> expressionStmt.getExpression() instanceof MethodCallExpr).map(expressionStmt -> (MethodCallExpr)expressionStmt.getExpression()).filter(methodCallExpr -> methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).asNameExpr().getName().asString().equals("values") && methodCallExpr.getName().asString().equals("add")).collect(Collectors.toList());
        Assert.assertNotNull(methodCallExprs);
        Assert.assertEquals((long)values.size(), (long)methodCallExprs.size());
        values.forEach(o -> {
            NameExpr expected = new NameExpr(o.toString());
            Assert.assertTrue((boolean)methodCallExprs.stream().anyMatch(arg_0 -> KiePMMLPredicateFactoryTest.lambda$null$16((Expression)expected, arg_0)));
        });
    }

    @Test
    public void setCompoundPredicateConstructorOr() {
        this.init("KiePMMLCompoundPredicateTemplate.tmpl", "KiePMMLCompoundPredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.OR;
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(booleanOperator.getClass().getCanonicalName() + "." + booleanOperator.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Expression expression = StaticJavaParser.parseExpression((String)"(aBoolean, aBoolean2) -> aBoolean != null ? aBoolean || aBoolean2 : aBoolean2");
        assignExpressionMap.put("operatorFunction", expression);
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("kiePMMLPredicates", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
        List methodCallExprs = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExpressionStmt).map(statement -> (ExpressionStmt)statement).filter(expressionStmt -> expressionStmt.getExpression() instanceof MethodCallExpr).map(expressionStmt -> (MethodCallExpr)expressionStmt.getExpression()).filter(methodCallExpr -> methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).asNameExpr().getName().asString().equals("kiePMMLPredicates") && methodCallExpr.getName().asString().equals("add")).collect(Collectors.toList());
        Assert.assertNotNull(methodCallExprs);
        Assert.assertEquals((long)predicatesClasses.size(), (long)methodCallExprs.size());
        predicatesClasses.forEach(predicateClass -> {
            ClassOrInterfaceType kiePMMLPredicateClass = StaticJavaParser.parseClassOrInterfaceType((String)predicateClass);
            ObjectCreationExpr expected = new ObjectCreationExpr();
            expected.setType(kiePMMLPredicateClass);
            Assert.assertTrue((boolean)methodCallExprs.stream().anyMatch(methodCallExpr -> methodCallExpr.getArguments().size() == 1 && ((Expression)methodCallExpr.getArguments().get(0)).equals((Object)expected)));
        });
    }

    @Test
    public void setCompoundPredicateConstructorAnd() {
        this.init("KiePMMLCompoundPredicateTemplate.tmpl", "KiePMMLCompoundPredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.AND;
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        superInvocationExpressionsMap.put(2, (Expression)new NameExpr(booleanOperator.getClass().getCanonicalName() + "." + booleanOperator.name()));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Expression expression = StaticJavaParser.parseExpression((String)"(aBoolean, aBoolean2) -> aBoolean != null ? aBoolean && aBoolean2 : aBoolean2");
        assignExpressionMap.put("operatorFunction", expression);
        ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentClass);
        assignExpressionMap.put("kiePMMLPredicates", (Expression)objectCreationExpr);
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
    }

    @Test
    public void setCompoundPredicateConstructorSurrogate() {
        this.init("KiePMMLCompoundPredicateTemplate.tmpl", "KiePMMLCompoundPredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        BOOLEAN_OPERATOR booleanOperator = BOOLEAN_OPERATOR.SURROGATE;
        HashSet<String> predicatesClasses = new HashSet<String>(Arrays.asList("PREDICATE_A", "PREDICATE_B"));
        KiePMMLPredicateFactory.setCompoundPredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration, (BOOLEAN_OPERATOR)booleanOperator, predicatesClasses);
    }

    @Test
    public void setTrueFalsePredicateConstructor() {
        this.init("KiePMMLTruePredicateTemplate.tmpl", "KiePMMLTruePredicateTemplate");
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateName = "PREDICATENAME";
        KiePMMLPredicateFactory.setTrueFalsePredicateConstructor((String)generatedClassName, (String)predicateName, (ConstructorDeclaration)this.constructorDeclaration);
        HashMap<Integer, Expression> superInvocationExpressionsMap = new HashMap<Integer, Expression>();
        superInvocationExpressionsMap.put(0, (Expression)new NameExpr(String.format("\"%s\"", predicateName)));
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor(this.constructorDeclaration, generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
    }

    @Test
    public void getObjectsFromArray() {
        Number expected;
        Object obj;
        int i;
        List<String> values = Arrays.asList("32", "11", "43");
        Array array = PMMLModelTestUtils.getArray(Array.Type.INT, values);
        List retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Integer));
            expected = Integer.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
        values = Arrays.asList("just", "11", "fun");
        array = PMMLModelTestUtils.getArray(Array.Type.STRING, values);
        retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof String));
            Assert.assertEquals((Object)values.get(i), obj);
        }
        values = Arrays.asList("23.11", "11", "123.123");
        array = PMMLModelTestUtils.getArray(Array.Type.REAL, values);
        retrieved = KiePMMLPredicateFactory.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Double));
            expected = Double.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
    }

    private void init(String templateSource, String templateClassName) {
        CompilationUnit compilationUnit = JavaParserUtils.getFromFileName((String)templateSource);
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(templateClassName).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration " + templateClassName + "  from " + templateSource))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from " + templateSource));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertEquals((Object)templateClassName, (Object)this.constructorDeclaration.getName().asString());
        Assert.assertTrue((boolean)compilationUnit.getClassByName(templateClassName).isPresent());
        this.superInvocation = this.constructorDeclaration.getBody().getStatements().stream().filter(statement -> statement instanceof ExplicitConstructorInvocationStmt).map(statement -> (ExplicitConstructorInvocationStmt)statement).findFirst().orElseThrow(() -> new RuntimeException("Failed to retrieve super invocation from " + templateSource));
        Assert.assertEquals((Object)"name", (Object)this.superInvocation.getArgument(0).asNameExpr().getNameAsString());
        this.assignExprs = this.constructorDeclaration.getBody().findAll(AssignExpr.class);
        Assert.assertNotNull(this.assignExprs);
    }

    private void commonVerifySimplePredicate(KiePMMLSimplePredicate toVerify, String parentId) {
        Optional<SimplePredicate> simplePredicate = simplePredicates.stream().filter(predicate -> predicate.getField().getValue().equals(toVerify.getName())).findFirst();
        if (!simplePredicate.isPresent()) {
            Assert.fail();
        } else {
            simplePredicate.ifPresent(predicate -> {
                OPERATOR expected = OPERATOR.byName((String)predicate.getOperator().value());
                Assert.assertEquals((Object)expected, (Object)toVerify.getOperator());
                Assert.assertEquals((Object)parentId, (Object)toVerify.getParentId());
            });
        }
    }

    private void commonVerifySimpleSetPredicate(KiePMMLSimpleSetPredicate toVerify, String parentId) {
        Optional<SimpleSetPredicate> simpleSetPredicate = simpleSetPredicates.stream().filter(predicate -> predicate.getField().getValue().equals(toVerify.getName())).findFirst();
        if (!simpleSetPredicate.isPresent()) {
            Assert.fail();
        } else {
            simpleSetPredicate.ifPresent(predicate -> {
                ARRAY_TYPE arrayTypeExpected = ARRAY_TYPE.byName((String)predicate.getArray().getType().value());
                Assert.assertEquals((Object)arrayTypeExpected, (Object)toVerify.getArrayType());
                IN_NOTIN inNotInExpected = IN_NOTIN.byName((String)predicate.getBooleanOperator().value());
                Assert.assertEquals((Object)inNotInExpected, (Object)toVerify.getInNotIn());
                Assert.assertEquals((Object)parentId, (Object)toVerify.getParentId());
            });
        }
    }

    private void commonVerifySourceMap(Map<String, String> toVerify, String packageName, String predicateName, int expectedSize) {
        Assert.assertNotNull(toVerify);
        Assert.assertEquals((long)expectedSize, (long)toVerify.size());
        String expectedKey = String.format("%s.%s", packageName, predicateName);
        Assert.assertTrue((boolean)toVerify.containsKey(expectedKey));
        CodegenTestUtils.commonValidateCompilation(toVerify);
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }

    static Node getNodeById(TreeModel treeModel, String id) {
        return KiePMMLPredicateFactoryTest.getNodeById(treeModel.getNode(), id);
    }

    static Node getNodeById(Node current, String id) {
        Node toReturn;
        block2: {
            Node child;
            if (id.equals(current.getId())) {
                return current;
            }
            toReturn = null;
            if (!current.hasNodes()) break block2;
            Iterator iterator = current.getNodes().iterator();
            while (iterator.hasNext() && (toReturn = KiePMMLPredicateFactoryTest.getNodeById(child = (Node)iterator.next(), id)) == null) {
            }
        }
        return toReturn;
    }

    private static /* synthetic */ boolean lambda$null$16(Expression expected, MethodCallExpr methodCallExpr) {
        return methodCallExpr.getArguments().size() == 1 && ((Expression)methodCallExpr.getArguments().get(0)).equals((Object)expected);
    }
}

